#!/bin/sh

rsyncd_startup() {
    rsync_support=`/sbin/getcfg System "Rsync Support" -u`
    if [ "x${rsync_support}" = "x" ]; then
	/sbin/setcfg System "Rsync Support" TRUE
    fi
    [ -f /etc/rsyncd.conf ] || /etc/init.d/rsyncd_srv.sh
    [ -f /etc/config/rsync_schedule.conf ] || echo "" > /etc/config/rsync_schedule.conf

    if [ `/sbin/getcfg System "Rsync Support" -u -d FALSE` = TRUE ]; then
	echo "Starting rsync server..."
	/sbin/daemon_mgr rsync start "/usr/bin/rsync --daemon"
    fi
}

check_def_share() {
    DEF_SHARE="Public Qusb Qweb Qmultimedia Qdownload"
    noshare=""
    cnt=0

    [ -z "`/bin/df | /bin/grep /dev/sda3`" ] && return

    for i in $DEF_SHARE
    do
	if [ ! -d /share/HDA_DATA/$i ]; then
	    [ $cnt = 0 ] && noshare="$i" || noshare="$noshare, $i"
	    cnt=`expr $cnt + 1`
	fi 
    done

    if [ $cnt -gt 0 ]; then
	[ $cnt = 1 ] \
	&& msg="The system default share folder($noshare) is not exist. It's suggested reformatting your SATA disk." \
	|| msg="The system default share folder($noshare) are not exist. It's suggested reformatting your SATA disk."
	echo "Warning: $msg"
	/sbin/write_log "$msg" 2
    fi
}


/sbin/daemon_mgr bcclient start /sbin/bcclient
/sbin/daemon_mgr picd start "/sbin/picd -d"

if [ `/sbin/getcfg "" "User Enable" -u -d FALSE -f /etc/config/usr_quota.conf` = TRUE ]; then
	/sbin/quotaon -au > /dev/null 2>&1
fi

rsyncd_startup

# for customer
#Shone added for Quick Steps
touch /tmp/quick_tmp.conf
mount /dev/mtdblock4 -t ext2 /tmp/config
if [ "$?" = "0" ]; then
	[ -f /tmp/config/autorun.sh ] && /tmp/config/autorun.sh
	umount /dev/mtdblock4
fi

# For Badblocks Scan
if [ -f /etc/config/badblocks.conf ]; then
	/sbin/setcfg -f /etc/config/badblocks.conf "Bad Block" Status 0
fi

check_def_share

/sbin/pic_raw 81
set -- `cat /proc/scsi/SiI3512`
if [ $2 = 0 ]; then
	# ERROR_NO_HD
	set_status_led 1 1
elif [ `getcfg "VOLUME 1" status -f /etc/config/storage.conf -d -1` != 0 ]; then
	# ERROR_HD_WRONG_FORMAT
	set_status_led 2 1
else
	set_status_led -1 0
fi

# For utelnetd
/usr/bin/readlink /etc/inittab | grep enable > /dev/null
if [ $? = 0 ]; then
	utelnetd -d -p 13131
fi
