#!/bin/sh

DAEMON_MGR="/sbin/daemon_mgr"
CROND="/usr/sbin/crond"

test -f $CROND || exit 0 # check if crond exists...

case "$1" in
	start)
		echo -n "Starting periodic command scheduler: "
		$DAEMON_MGR crond start "$CROND -l 9"
		echo "crond."
		;;

	stop)
		echo -n "Stopping periodic command scheduler: "
		$DAEMON_MGR crond stop "$CROND"
		echo "crond."
		;;

	restart)
		start
		stop
		;;

	*)
		echo "Usage: $1 start|stop|restart"
		exit 1
		;;
esac

exit 0
