#!/bin/sh
PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin

SYSTEM_DEV=`/sbin/getcfg System "System Device"`
UPDATE_FOLDER="/mnt/update"
FLASH_KERNEL="/dev/mtdblock1"
FLASH_ROOTFS_BASIC="/dev/mtdblock2"
FLASH_ROOTFS_EXT="/dev/mtdblock3"
PIC_RAW="/sbin/pic_raw"
UPDATE_PROCESS="/tmp/update_process"
TMP_UPDATE_FLAG="/tmp/update_flag"

begin_led()
{
	${PIC_RAW} 88; ${PIC_RAW} 76
}

end_led()
{
	${PIC_RAW} 77; ${PIC_RAW} 86
}

do_beep()
{
	${PIC_RAW} 81; sleep 2; ${PIC_RAW} 81; sleep 2; ${PIC_RAW} 81
}

remove_update()
{
	rm -rf ${UPDATE_FOLDER}/*
}

get_new_ver()
{
	local filename=$path_name
	set -- `ls -l "$path_name"`
	local pos=`expr $5 - 48`
	dd if=$filename of=${UPDATE_FOLDER}/newver skip=$pos bs=1 count=16
	[ $? = 0 ] && cat /tmp/mycheck || echo ""
}

do_exit()
{
	local ret=0
	local old_ver=`/sbin/getcfg System Version`
	local new_ver=`get_new_ver`

	case $1 in
		0)#normal exit
			ret=0
			[ ! -z $new_ver ]	\
			&& /sbin/write_log "System was updated successfully from $old_ver to $new_ver." 4			\
			|| /sbin/write_log "System was updated successfully." 4
			;;
		1)#list tar failed
			echo -1 > ${UPDATE_PROCESS}
			ret=1
			[ ! -z $new_ver ]	\
			&& /sbin/write_log "System was updated failed from $old_ver to $new_ver." 1				\
			|| /sbin/write_log "System was updated failed." 1
			;;
		2)#extract tar failed
			echo -2 > ${UPDATE_PROCESS}
			ret=1
			[ ! -z $new_ver ]	\
			&& /sbin/write_log "System was updated failed from $old_ver to $new_ver." 1				\
			|| /sbin/write_log "System was updated failed." 1
			;;
		3)#CRC check failed
			echo -3 > ${UPDATE_PROCESS}
			ret=1
			[ ! -z $new_ver ]	\
			&& /sbin/write_log "System was updated failed from $old_ver to $new_ver." 1				\
			|| /sbin/write_log "System was updated failed." 1
			;;
		*)
			echo -5 > ${UPDATE_PROCESS}
			ret=1
			[ ! -z $new_ver ]	\
			&& /sbin/write_log "System was updated failed from $old_ver to $new_ver." 1				\
			|| /sbin/write_log "System was updated failed." 1
	esac

	end_led
	remove_update
	exit $ret
}

#return 1 if success, 0 if failed
check_sum()
{
	local file_cksum=`/sbin/cksum $1`
	local file_crc=`echo $file_cksum | cut -d ' ' -f 1`
	local file_size=`echo $file_cksum | cut -d ' ' -f 2`

	local cksum_cksum=`cat $2`
	local cksum_crc=`echo $cksum_cksum | cut -d ' ' -f 1`
	local cksum_size=`echo $cksum_cksum | cut -d ' ' -f 2`

	if [ $file_crc = $cksum_crc ] && [ $file_size = $cksum_size ]; then
		return 1
	fi
	return 0
}

CRC_check()
{
	for i in uImage initrd.boot rootfs_ext.tgz
	do
		check_sum "$UPDATE_FOLDER/$i" "$UPDATE_FOLDER/$i.cksum"
		if [ $? = 0 ]; then
			do_exit 3
		fi
	done
	return 0
}

#
# Set Status flag
# 
set_status_flag()
{
	#this step is unneccessary since we can only update if hd is ready but
	#we check anyway XD
	if [ `getcfg "Volume 1" "status" -f "/etc/config/storage.conf"` = 0 ]; then
		echo $1 > $TMP_UPDATE_FLAG
		# 73400336 = 70M + 16 bytes = 70 * 1024 * 1024 + 16
		dd if=$TMP_UPDATE_FLAG of=/dev/sda4 seek=73400336 bs=1 count=1
		rm -f $TMP_UPDATE_FLAG
	fi
}

clean_files()
{
	/etc/init.d/smb.sh stop
	rm -rf /usr/local/samba
	rm -f /usr/bin/smbmnt /usr/bin/smbmount /usr/bin/wbinfo

	/etc/init.d/atalk.sh stop
	rm -rf /usr/local/etc/netatalk
	rm -f /usr/sbin/afpd /usr/sbin/atalkd /usr/sbin/papd

	/etc/init.d/btd.sh stop
	rm -f /sbin/btd
	rm -f /usr/bin/python
	rm -rf /usr/local/BitTornado
	rm -rf /home/httpd/Qdownload
	rm -rf /usr/lib/python2.3

	/etc/init.d/Qthttpd.sh stop
	rm -f /usr/local/sbin/ImR_all /usr/local/sbin/cjpeg
	rm -f /usr/local/sbin/gifrsize /usr/local/sbin/jhead
	rm -f /usr/local/sbin/Qthttpd
	rm -rf /home/Qhttpd
	rm -rf /home/httpd/Qmultimedia

	/etc/init.d/ftp.sh stop
	rm -f /usr/local/sbin/proftpd

	/sbin/daemon_mgr rsync stop "/usr/bin/rsync"
	rm /usr/bin/rsync
	rm /usr/bin/rr

	rm -rf /usr/local/lib
}

begin_led
path_name=$1
if [ `/sbin/getcfg "VOLUME 1" status -f /etc/config/storage.conf` = 0 ]; then
	echo "Extract update image using HDD ..."
	/sbin/PC1 d QNAPNASVERSION4 $path_name ${path_name}.tgz
	/bin/tar tzf ${path_name}.tgz; [ $? != 0 ] && do_exit 1;
	/bin/tar xzf ${path_name}.tgz -C ${UPDATE_FOLDER}; [ $? != 0 ] && do_exit 2;
else
	clean_files
	fname=`basename $path_name`
	echo "Extract update image using RAM disk ..."
	/sbin/PC1 d QNAPNASVERSION4 $path_name /mnt/ext/${fname}.tgz
	/bin/rm -f $path_name
	/bin/tar tzf /mnt/ext/${fname}.tgz; [ $? != 0 ] && do_exit 1;
	/bin/tar xzf /mnt/ext/${fname}.tgz -C ${UPDATE_FOLDER}; [ $? != 0 ] && do_exit 2;
	/bin/rm -f /mnt/ext/${fname}.tgz
fi

echo "CRC checks..."
CRC_check

echo "Update Kernel..."
echo 1 > ${UPDATE_PROCESS}
dd if=${UPDATE_FOLDER}/uImage of=${FLASH_KERNEL}

echo "Update Basic RootFs..."
echo 2 > ${UPDATE_PROCESS}
dd if=${UPDATE_FOLDER}/initrd.boot of=${FLASH_ROOTFS_BASIC}

echo "Update Extended RootFS..."
dd if=${UPDATE_FOLDER}/rootfs_ext.tgz of=${FLASH_ROOTFS_EXT}
set_status_flag 1

echo "Update Finished."
echo 3 > ${UPDATE_PROCESS}
do_beep
do_exit 0
