#!/bin/sh
RSYNCD_CONF="/etc/rsyncd.conf"
echo "uid = administrator" > ${RSYNCD_CONF}
echo "gid = administrators" >> ${RSYNCD_CONF}
echo "log file = /var/log/rsyncd.log" >> ${RSYNCD_CONF}
echo "pid file = /var/run/rsyncd.pid" >> ${RSYNCD_CONF}
echo "read only = false" >> ${RSYNCD_CONF}
echo "hosts allow = *" >> ${RSYNCD_CONF}
echo >> ${RSYNCD_CONF}

tmp_smb_conf="/tmp/smb.conf.`date +%s`"
/bin/cp /etc/smb.conf ${tmp_smb_conf}
share_list="/tmp/share_list.`date +%s`"
/bin/sed -n 's/^\[\(.*\)\]/\1/p' ${tmp_smb_conf} | /bin/grep global -v | /bin/grep printer -v > ${share_list}

while read LINE
do
	share_path=`/sbin/getcfg "${LINE}" "path" -f ${tmp_smb_conf} -d ""`
	[ "x${share_path}" = "x" ] || /sbin/setcfg "${LINE}" "path" "${share_path}" -f ${RSYNCD_CONF}
done < ${share_list}

/bin/rm -f ${tmp_smb_conf} ${share_list}
