#!/bin/sh
#
# named           This shell script takes care of starting and stopping
#                 named (BIND DNS server).
#

# See how we were called.
case "$1" in
  start)
        # Start daemons.
        
        /usr/sbin/create_zone_file > /dev/null

	echo -n "Starting named: "
	
	if [ `/sbin/getcfg "DNS Server" "Enable" -u -d "FALSE"` = FALSE ]
	then
		echo disabled
		exit 0
	fi

	conf_path=`/sbin/getcfg "DNS Server" "Named conf" -d "/etc/named.conf"`

	/sbin/daemon_mgr named start "/usr/sbin/named -c $conf_path"

	touch /var/lock/subsys/named
	echo -n "named"
	echo "."
        ;;
  stop)
        # Stop daemons.
	echo -n "Shutting down named: "
	/sbin/daemon_mgr named stop /usr/sbin/named
	echo -n "named"
	echo "."
        rm -f /var/lock/subsys/named
        echo
        ;;
  restart)
	$0 stop
	$0 start
	;;
  reload)
	/usr/sbin/ndc -q reload > /dev/null
	exit $?
	;; 
  *)
        echo "Usage: named {start|stop|restart|reload}"
        exit 1
esac

exit $RETVAL

