#!/bin/sh
#
# initialize MAC address
#

MOUNTPOINT="/tmp/config"
DEV_MTD5="/dev/mtdblock6"
ETH0_MAC_ADDR="$MOUNTPOINT/ETH0.MAC_ADDR"

get_mac_address()
{
	local mac_addr

        mount $DEV_MTD5 -t ext2 $MOUNTPOINT > /dev/null 2>&1
        if [ "$?" = "0" ]; then
                if [ -f $ETH0_MAC_ADDR ]; then
                        mac_addr=`cat $ETH0_MAC_ADDR`
        		/sbin/ifconfig $1 hw ether $mac_addr
		else
			# if mac address is not set, test the performance of hd & usb
			hdperm_test
                fi
                umount $DEV_MTD5 > /dev/null 2>&1
	fi
}

echo "initializing MAC address..."

# setup lo
/sbin/ifconfig lo 127.0.0.1 up 2> /dev/null 1> /dev/null
/sbin/route add -net 127.0.0.0 netmask 255.0.0.0 lo 2> /dev/null 1> /dev/null

# setup eth0
/sbin/ifconfig eth0 > /dev/null
[ $? = 0 ] && get_mac_address eth0

#ldconfig
/sbin/ldconfig 2>/dev/null 1>/dev/null