MDADM(8)                                                 MDADM(8)



NNAAMMEE
       mdadm - manage MD devices _a_k_a Linux Software Raid.


SSYYNNOOPPSSIISS
       mmddaaddmm _[_m_o_d_e_] _<_r_a_i_d_d_e_v_i_c_e_> _[_o_p_t_i_o_n_s_] _<_c_o_m_p_o_n_e_n_t_-_d_e_v_i_c_e_s_>


DDEESSCCRRIIPPTTIIOONN
       RAID  devices are virtual devices created from two or more
       real block devices. This allows  multiple  devices  (typi
       cally  disk  drives or partitions there-of) to be combined
       into a single  device  to  hold  (for  example)  a  single
       filesystem.   Some  RAID  levels include redundancy and so
       can survive some degree of device failure.

       Linux Software RAID devices are implemented through the md
       (Multiple Devices) device driver.

       Currently, Linux supports LLIINNEEAARR md devices, RRAAIIDD00 (strip
       ing), RRAAIIDD11 (mirroring), RRAAIIDD44, RRAAIIDD55, and MMUULLTTIIPPAATTHH.

       MMUULLTTIIPPAATTHH iiss nnoott  aa  SSooffttwwaarree  RRAAIIDD  mmeecchhaanniissmm,,  bbuutt  ddooeess
       iinnvvoollvvee  multiple devices.  For MMUULLTTIIPPAATTHH each device is a
       path to one common physical storage device.


       mmddaaddmm is a program that can be used to create, manage, and
       monitor  MD devices.  As such it provides a similar set of
       functionality to the rraaiiddttoooollss packages.  The key  differ
       ences between mmddaaddmm and rraaiiddttoooollss are:

          mmddaaddmm is a single program and not a collection of pro
           grams.

          mmddaaddmm can perform (almost) all of its functions  with
           out  having  a configuration file and does not use one
           by default.  Also mmddaaddmm helps with management  of  the
           configuration file.

          mmddaaddmm   can  provide  information  about  your  arrays
           (through Query, Detail, and  Examine)  that  rraaiiddttoooollss
           cannot.

       _m_d_a_d_m  does not use _/_e_t_c_/_r_a_i_d_t_a_b, the rraaiiddttoooollss configura
       tion file, at all.  It has a different configuration  file
       with a different format and an different purpose.


MMOODDEESS
       mdadm has 6 major modes of operation:

       AAsssseemmbbllee
              Assemble  the  parts  of a previously created array
              into an active array. Components can be  explicitly
              given  or  can  be searched for.  mmddaaddmm checks that
              the components do form a bona fide array, and  can,
              on  request, fiddle superblock information so as to
              assemble a faulty array.


       BBuuiilldd  Build   a   legacy   array    without    per-device
              superblocks.


       CCrreeaattee Create a new array with per-device superblocks.


       MMaannaaggee This  is for doing things to specific components of
              an array such as adding  new  spares  and  removing
              faulty devices.


       MMiisscc   This  mode allows operations on independent devices
              such  as  examine  MD  superblocks,   erasing   old
              superblocks and stopping active arrays.


       FFoollllooww oorr MMoonniittoorr
              Monitor one or more md devices and act on any state
              changes.  This is only meaningful for raid1,  raid5
              or  multipath arrays as only these have interesting
              state.  raid0 or linear never have missing,  spare,
              or failed drives, so there is nothing to monitor.



OOPPTTIIOONNSS
       Available options are:


       --AA, ----aasssseemmbbllee
              Assemble a pre-existing array.


       --BB, ----bbuuiilldd
              Build a legacy array without superblocks.


       --CC, ----ccrreeaattee
              Create a new array.


       --QQ, ----qquueerryy
              Examine  a  device to see (1) if it is an md device
              and (2) if it  is  a  component  of  an  md  array.
              Information  about what is discovered is presented.


       --DD, ----ddeettaaiill
              Print detail of one or more md devices.


       --EE, ----eexxaammiinnee
              Print content of md superblock on device(s).


       --FF, ----ffoollllooww, ----mmoonniittoorr
              Select MMoonniittoorr mode.


       --hh, ----hheellpp
              Display help message or, after above  option,  mode
              specific help message.


       ----hheellpp--ooppttiioonnss
              Display  more  detailed  help  about  command  line
              parsing and some commonly used options.


       --VV, ----vveerrssiioonn
              Print version information for mdadm.


       --vv, ----vveerrbboossee
              Be more verbose about what is happening.


       --bb, ----bbrriieeff
              Be less verbose.  This is used  with  ----ddeettaaiill  and
              ----eexxaammiinnee.


       --ff, ----ffoorrccee
              Be more forceful about certain operations.  See the
              various modes of the exact meaning of  this  option
              in different contexts.


       --cc, ----ccoonnffiigg==
              Specify    the    config    file.     Default    is
              //eettcc//mmddaaddmm..ccoonnff.  If the config file given is  ppaarr
              ttiittiioonnss  then  nothing will be read, but _m_d_a_d_m will
              act as though the  config  file  contained  exactly
              DDEEVVIICCEE ppaarrttiittiioonnss and will read //pprroocc//ppaarrttiittiioonnss to
              find a list of devices to scan.  If the  word  nnoonnee
              is  given  for the config file, then _m_d_a_d_m will act
              as though the config file were empty.


       --ss, ----ssccaann
              scan config file or //pprroocc//mmddssttaatt for missing infor
              mation.   In  general, this option gives mmddaaddmm per
              mission to get any missing information, like compo
              nent  devices, array devices, array identities, and
              alert  destination  from  the  configuration  file:
              //eettcc//mmddaaddmm..ccoonnff.   One  exception is MISC mode when
              using ----ddeettaaiill or ----ssttoopp in which case ----ssccaann  says
              to get a list of array devices from //pprroocc//mmddssttaatt.


FFoorr ccrreeaattee oorr bbuuiilldd::
       --cc, ----cchhuunnkk==
              Specify  chunk  size  of kibibytes.  The default is
              64.


       ----rroouunnddiinngg==
              Specify rounding factor for linear  array  (==chunk
              size)


       --ll, ----lleevveell==
              Set  raid  level.  When used with _-_-_c_r_e_a_t_e, options
              are: linear, raid0, 0, stripe,  raid1,  1,  mirror,
              raid5,  4, raid5, 5, multipath, mp.  Obviously some
              of these are synonymous.

              When used with  _-_-_b_u_i_l_d,  only  linear,  raid0,  0,
              stripe are valid.


       --pp, ----ppaarriittyy==
              Set raid5 parity algorithm. Options are: left-asym
              metric,  left-symmetric,  right-asymmetric,  right-
              symmetric,  la,  ra,  ls, rs.  The default is left-
              symmetric.


       ----llaayyoouutt==
              same as --parity


       --nn, ----rraaiidd--ddeevviicceess==
              Specify the number of active devices in the  array.
              This,  plus the number of spare devices (see below)
              must equal the number of _c_o_m_p_o_n_e_n_t_-_d_e_v_i_c_e_s (includ
              ing  "mmiissssiinngg" devices) that are listed on the com
              mand line.  Setting a value of 1 is probably a mis
              take  and  so  requires  that  ----ffoorrccee be specified
              first.  A value of 1 will then be allowed for  lin
              ear,  multipath,  raid0  and  raid1.   It  is never
              allowed for raid4 or raid5.
              Note that this number cannot be  changed  once  the
              array has been created.


       --xx, ----ssppaarree--ddeevviicceess==
              Specify  the number of spare (eXtra) devices in the
              initial  array.   Spares  can  also  be  added  and
              removed  later.   The  number  of component devices
              listed on the command line must equal the number of
              raid devices plus the number of spare devices.



       --zz, ----ssiizzee==
              Amount  (in  Kibibytes)  of  space to use from each
              drive in RAID1/4/5.  This must be a multiple of the
              chunk  size, and must leave about 128Kb of space at
              the end of the drive for the RAID  superblock.   If
              this  is  not specified (as it normally is not) the
              smallest drive (or partition) sets the size, though
              if  there is a variance among the drives of greater
              than 1%, a warning is issued.


FFoorr aasssseemmbbllee::
       --uu, ----uuuuiidd==
              uuid of array to assemble. Devices which don't have
              this uuid are excluded


       --mm, ----ssuuppeerr--mmiinnoorr==
              Minor  number of device that array was created for.
              Devices which don't  have  this  minor  number  are
              excluded.  If you create an array as /dev/md1, then
              all superblocks will contain the  minor  number  1,
              even if the array is later assembled as /dev/md2.

              Giving  the  literal  word  "dev" for ----ssuuppeerr--mmiinnoorr
              will cause _m_d_a_d_m to use the minor number of the  md
              device  that  is being assembled.  e.g. when assem
              bling //ddeevv//mmdd00, will look for super blocks  with  a
              minor number of 0.


       --ff, ----ffoorrccee
              Assemble  the array even if some superblocks appear
              out-of-date


       --RR, ----rruunn
              Attempt to start the array  even  if  fewer  drives
              were  given  than are needed for a full array. Nor
              mally if not all drives are found and ----ssccaann is not
              used,  then  the  array  will  be assembled but not
              started.  With ----rruunn an attempt  will  be  made  to
              start it anyway.


       --UU, ----uuppddaattee==
              Update  the  superblock on each device while assem
              bling the array.  The argument given to  this  flag
              can  be one of ssppaarrcc22..22, ssuummmmaarriieess, or ssuuppeerr--mmiinnoorr.

              The ssppaarrcc22..22 option will  adjust the superblock  of
              an  array  what was created on a Sparc machine run
              ning a patched 2.2 Linux kernel.  This  kernel  got
              the alignment of part of the superblock wrong.  You
              can use the ----eexxaammiinnee ----ssppaarrcc22..22 option to _m_d_a_d_m to
              see what effect this would have.

              The  ssuuppeerr--mmiinnoorr  option  will  update the pprreeffeerreedd
              mmiinnoorr field on each superblock to match  the  minor
              number  of  the array being assembled.  This is not
              needed on 2.6 and later kernels as they  make  this
              adjustment automatically.

              The  ssuummmmaarriieess option will correct the summaries in
              the superblock. That is the counts of total,  work
              ing, active, failed, and spare devices.


FFoorr MMaannaaggee mmooddee::
       --aa, ----aadddd
              hotadd listed devices.


       --rr, ----rreemmoovvee
              remove  listed  devices.   They must not be active.
              i.e. they should be failed or spare devices.


       --ff, ----ffaaiill
              mark listed devices as faulty.


       ----sseett--ffaauullttyy
              same as --fail.


FFoorr EExxaammiinnee mmooddee::
       ----ssppaarrcc22..22
              In an array was  created  on  a  2.2  Linux  kernel
              patched with RAID support, the superblock will have
              been created incorrectly, or at least  incompatibly
              with  2.4  and later kernels.  Using the ----ssppaarrcc22..22
              flag with ----eexxaammiinnee will fix the superblock  before
              displaying  it.   If  this  appears to do the right
              thing, then the array can be successfully assembled
              using ----aasssseemmbbllee ----uuppddaattee==ssppaarrcc22..22.


FFoorr MMiisscc mmooddee::
       --RR, ----rruunn
              start a partially built array.


       --SS, ----ssttoopp
              deactivate array, releasing all resources.


       --oo, ----rreeaaddoonnllyy
              mark array as readonly.


       --ww, ----rreeaaddwwrriittee
              mark array as readwrite.


       ----zzeerroo--ssuuppeerrbblloocckk
              If  the  device contains a valid md superblock, the
              block is over-written with zeros.  With --force the
              block where the superblock would be is over-written
              even if it doesn't appear to be valid.


       --tt, ----tteesstt
              When used with ----ddeettaaiill, the exit status  of  _m_d_a_d_m
              is set to reflect the status of the device.


FFoorr MMoonniittoorr mmooddee::
       --mm, ----mmaaiill
              Give a mail address to send alerts to.


       --pp, ----pprrooggrraamm, ----aalleerrtt
              Give  a  program  to  be  run  whenever an event is
              detected.


       --dd, ----ddeellaayy
              Give a delay in seconds.  mmddaaddmm polls the md arrays
              and  then  waits  this  many seconds before polling
              again.  The default is 60 seconds.


       --ff, ----ddaaeemmoonniissee
              Tell mmddaaddmm to run as  a  background  daemon  if  it
              decides  to  monitor  anything.   This causes it to
              fork and run in the child, and to  disconnect  form
              the terminal.  The process id of the child is writ
              ten to stdout.  This is useful  with  ----ssccaann  which
              will  only continue monitoring if a mail address or
              alert program is found in the config file.


       --11, ----oonneesshhoott
              Check arrays only once.  This will generate  NNeewwAArr
              rraayy  events  and  more  significantly DDeeggrraaddeeddAArrrraayy
              events.  Running
                      mmddaaddmm ----mmoonniittoorr ----ssccaann --11
              from a cron script will ensure regular notification
              of any degraded arrays.


AASSSSEEMMBBLLEE MMOODDEE
       Usage:  mmddaaddmm  ----aasssseemmbbllee _m_d_-_d_e_v_i_c_e _o_p_t_i_o_n_s_-_a_n_d_-_c_o_m_p_o_n_e_n_t_-
                   _d_e_v_i_c_e_s_._._.

       Usage: mmddaaddmm ----aasssseemmbbllee ----ssccaann _m_d_-_d_e_v_i_c_e_s_-_a_n_d_-_o_p_t_i_o_n_s_._._.

       Usage: mmddaaddmm ----aasssseemmbbllee ----ssccaann _o_p_t_i_o_n_s_._._.


       This usage assembles one or more  raid  arrays  from  pre-
       existing  components.  For each array, mdadm needs to know
       the md device, the identity of the array, and a number  of
       component-devices. These can be found in a number of ways.

       In the first usage example (without the ----ssccaann) the  first
       device  given is the md device.  In the second usage exam
       ple, all devices listed are  treated  as  md  devices  and
       assembly is attempted.  In the third (where no devices are
       listed) all md devices that are listed in  the  configura
       tion file are assembled.

       If  precisely  one  device  is  listed,  but ----ssccaann is not
       given, that _m_d_a_d_m acts as  though  ----ssccaann  was  given  and
       identify  information  is extracted from the configuration
       file.

       The identity can be given with the ----uuuuiidd option, with the
       ----ssuuppeerr--mmiinnoorr option, can be found  in the config file, or
       will be taken from the super block on the first component-
       device listed on the command line.

       Devices  can be given on the ----aasssseemmbbllee command line or in
       the config file. Only devices which have an md  superblock
       which  contains  the right identity will be considered for
       any array.

       The config file is only  used  if  explicitly  named  with
       ----ccoonnffiigg  or  requested with (a possibly implicit) ----ssccaann..
       In the later case, //eettcc//mmddaaddmm..ccoonnff is used.

       If ----ssccaann is not given, then the config file will only  be
       used to find the identity of md arrays.

       Normally  the array will be started after it is assembled.
       However if ----ssccaann is not  given  and  insufficient  drives
       were listed to start a complete (non-degraded) array, then
       the array is not started (to guard against usage  errors).
       To  insist  that the array be started in this case (as may
       work for RAID1 or RAID5), give the ----rruunn flag.



BBUUIILLDD MMOODDEE
       Usage: mmddaaddmm ----bbuuiilldd _d_e_v_i_c_e  ----cchhuunnkk==_X  ----lleevveell==_Y  ----rraaiidd--
                   ddeevviicceess==_Z _d_e_v_i_c_e_s


       This usage is similar to ----ccrreeaattee.  The difference is that
       it creates a legacy array without a superblock. With these
       arrays  there  is no difference between initially creating
       the array and subsequently assembling  the  array,  except
       that  hopefully  there  is useful data there in the second
       case.

       The level may only be 0, raid0,  or  linear.  All  devices
       must  be  listed  and  the array will be started once com
       plete.


CCRREEAATTEE MMOODDEE
       Usage: mmddaaddmm ----ccrreeaattee _d_e_v_i_c_e ----cchhuunnkk==_X ----lleevveell==_Y
                   ----rraaiidd--ddeevviicceess==_Z _d_e_v_i_c_e_s


       This usage will initialise a new md array, associate  some
       devices with it, and activate the array.

       As devices are added, they are checked to see if they con
       tain  raid  superblocks  or  filesystems.  They  are  also
       checked  to see if the variance in device size exceeds 1%.

       If any discrepancy is found, the array will not  automati
       cally  be run, though the presence of a ----rruunn can override
       this caution.

       To create a "degraded" array in  which  some  devices  are
       missing,  simply  give  the  word  "mmiissssiinngg" in place of a
       device name.  This will cause mmddaaddmm to  leave  the  corre
       sponding  slot  in  the array empty.  For a RAID4 or RAID5
       array at most one slot can  be  "mmiissssiinngg".   For  a  RAID1
       array, only one real device needs to be given.  All of the
       others can be "mmiissssiinngg".

       When creating a RAID5 array, mmddaaddmm will automatically cre
       ate  a  degraded array with an extra spare drive.  This is
       because building the spare into a  degraded  array  is  in
       general  faster  than  resyncing  the  parity  on  a  non-
       degraded, but not clean, array.  This feature can be over-
       ridden with the -I --force option.


       The  General Management options that are valid with --cre
       ate are:

       ----rruunn  insist of running the array even  if  some  devices
              look like they might be in use.


       ----rreeaaddoonnllyy
              start the array readonly - not supported yet.


MMAANNAAGGEE MMOODDEE
       Usage: mmddaaddmm _d_e_v_i_c_e _o_p_t_i_o_n_s_._._. _d_e_v_i_c_e_s_._._.


       This usage will allow individual devices in an array to be
       failed, removed or added.  It is possible to perform  mul
       tiple operations with on command. For example:
         mmddaaddmm //ddeevv//mmdd00 --ff //ddeevv//hhddaa11 --rr //ddeevv//hhddaa11 --aa //ddeevv//hhddaa11
       will firstly mark //ddeevv//hhddaa11 as faulty in //ddeevv//mmdd00 and will
       then remove it from the array and finally add it  back  in
       as  a spare.  However only one md array can be affected by
       a single command.


MMIISSCC MMOODDEE
       Usage: mmddaaddmm _o_p_t_i_o_n_s _._._.  _d_e_v_i_c_e_s _._._.


       MISC mode includes a number if  distinct  operations  that
       operate on distinct devices.  The operations are:

       --query
              The  device  is  examined  to  see  if it is (1) an
              active md array, or (2) a component of an md array.
              The information discovered is reported.


       --detail
              The  device  should  be an active md device.  mmddaaddmm
              will display a detailed description of  the  array.
              ----bbrriieeff  or ----ssccaann will cause the output to be less
              detailed and the format to be suitable  for  inclu
              sion  in //eettcc//mmddaaddmm..ccoonnff.  The exit status of _m_d_a_d_m
              will normally be 0 unless _m_d_a_d_m failed to get  use
              ful  information  about  the device(s).  However if
              the ----tteesstt option is given, then  the  exit  status
              will be:

              0      The array is functioning normally.

              1      The array has at least one failed device.

              2      The  array  has  multiple failed devices and
                     hence is unusable (raid4 or raid5).

              4      There was  an  error  while  trying  to  get
                     information about the device.


       --examine
              The  device  should  be a component of an md array.
              mmddaaddmm will read the md superblock of the device and
              display  the  contents.   If  ----bbrriieeff  is given, or
              ----ssccaann then multiple devices that are components of
              the  one array are grouped together and reported in
              a  single   entry   suitable   for   inclusion   in
              //eettcc//mmddaaddmm..ccoonnff.

              Having  ----ssccaann  without  listing  any  devices will
              cause all devices listed in the config file  to  be
              examined.


       --stop This  devices should active md arrays which will be
              deactivated, if they are not currently in use.


       --run  This will fully activate a partially  assembled  md
              array.


       --readonly
              This  will  mark an active array as read-only, pro
              viding that it is not currently being used.


       --readwrite
              This will change a rreeaaddoonnllyy  array  back  to  being
              read/write.


       --scan For  all  operations  except ----eexxaammiinnee, ----ssccaann will
              cause the operation to be  applied  to  all  arrays
              listed  in  //pprroocc//mmddssttaatt.   For  ----eexxaammiinnee,,  ----ssccaann
              causes all devices listed in the config file to  be
              examined.



MMOONNIITTOORR MMOODDEE
       Usage: mmddaaddmm ----mmoonniittoorr _o_p_t_i_o_n_s_._._. _d_e_v_i_c_e_s_._._.


       This  usage  causes mmddaaddmm to periodically poll a number of
       md arrays and to report on any events noticed.  mmddaaddmm will
       never  exit  once  it  decides that there are arrays to be
       checked, so it should normally be run in the background.

       As well as reporting events, mmddaaddmm may move a spare  drive
       from  one  array to another if they are in the same ssppaarree--
       ggrroouupp and if the destination array has a failed drive  but
       not spares.

       If  any devices are listed on the command line, mmddaaddmm will
       only monitor those devices. Otherwise all arrays listed in
       the  configuration  file  will  be monitored.  Further, if
       ----ssccaann is given, then any other md devices that appear  in
       //pprroocc//mmddssttaatt will also be monitored.

       The  result  of monitoring the arrays is the generation of
       events.  These events are passed to a separate program (if
       specified) and may be mailed to a given E-mail address.

       When passing event to program, the program is run once for
       each event and is given 2 or  3  command-line  arguements.
       The  first is the name of the event (see below).  The sec
       ond is the name of the md device which  is  affected,  and
       the  third  is  the  name of a related device if relevant,
       such as a component device that has failed.

       If ----ssccaann is given, then a program or  an  E-mail  address
       must  be  specified  on  the command line or in the config
       file.  If neither are available, then mmddaaddmm will not moni
       tor anything.  Without ----ssccaann mmddaaddmm will continue monitor
       ing as long as something was found to monitor.  If no pro
       gram  or  email  is  given, then each event is reported to
       ssttddoouutt.

       The different events are:


           DDeevviicceeDDiissaappppeeaarreedd
                  An md array  which  previously  was  configured
                  appears to no longer be configured.


           RReebbuuiillddSSttaarrtteedd
                  An md array started reconstruction.


           RReebbuuiilldd_N_N
                  Where  _N_N  is 20, 40, 60, or 80, this indicates
                  that rebuild has passed that many percentage of
                  the total.


           FFaaiill   An active component device of an array has been
                  marked as faulty.


           FFaaiillSSppaarree
                  A  spare  component  device  which  was   being
                  rebuilt  to replace a faulty device has failed.


           SSppaarreeAAccttiivvee
                  A  spare  component  device  which  was   being
                  rebuilt to replace a faulty device as been suc
                  cessfully rebuild and has been made active.


           NNeewwAArrrraayy
                  A  new  md  array  has  been  detected  in  the
                  //pprroocc//mmddssttaatt file.


           DDeeggrraaddeeddAArrrraayy
                  A  newly  noticed array appears to be degraded.
                  This  message  is  not  generated  when   _m_d_a_d_m
                  notices  a  drive failure which causes degrada
                  tion, but only when _m_d_a_d_m notices that an array
                  is degraded when it first sees the array.


           MMoovveeSSppaarree
                  A  spare drive has been moved from one array in
                  a ssppaarree--ggrroouupp to  another  to  allow  a  failed
                  drive to be replaced.


       Only  FFaaiill  and  FFaaiillSSppaarree  cause  Email  to be sent.  All
       events cause the program to be run.  The  program  is  run
       with  two  or  three arguments, they being the event name,
       the array device and possibly a second device.

       Each event has an associated array device (e.g.  //ddeevv//mmdd11)
       and  possibly  a  second device.  For FFaaiill, FFaaiillSSppaarree, and
       SSppaarreeAAccttiivvee the second device is  the  relevant  component
       device.  For MMoovveeSSppaarree the second device is the array that
       the spare was moved from.

       For mmddaaddmm to move spares from one array  to  another,  the
       different  arrays need to be labelled with the same ssppaarree--
       ggrroouupp in the configuration file.  The ssppaarree--ggrroouupp name can
       be  any  string. It is only necessary that different spare
       groups use different names.

       When mmddaaddmm detects that an array which is in a spare group
       has  fewer  active devices than necessary for the complete
       array, and has no spare devices, it will look for  another
       array  in  the same spare group that has a full complement
       of working drive and a spare.  It  will  then  attempt  to
       remove  the  spare from the second drive and add it to the
       first.  If the removal succeeds but the adding fails, then
       it is added back to the original array.


EEXXAAMMPPLLEESS
         mmddaaddmm ----qquueerryy //ddeevv//nnaammee--ooff--ddeevviiccee
       This  will  find out if a given device is a raid array, or
       is part of one, and will provide brief  information  about
       the device.

         mmddaaddmm ----aasssseemmbbllee ----ssccaann
       This  will  assemble  and  start  all arrays listed in the
       standard confile file.  This command will typically go  in
       a system startup file.

         mmddaaddmm ----ssttoopp ----ssccaann
       This  will shut down all array that can be shut down (i.e.
       are not currently in used).  This will typically going  in
       a system shutdown script.

         mmddaaddmm ----ffoollllooww ----ssccaann ----ddeellaayy==112200
       If  (and  only  if)  there  is an Email address or program
       given in the standard config file, then monitor the status
       of  all  arrays listed in that file by polling them ever 2
       minutes.

          mmddaaddmm  ----ccrreeaattee  //ddeevv//mmdd00  ----lleevveell==11   ----rraaiidd--ddeevviicceess==22
       //ddeevv//hhdd[[aacc]]11
       Create  /dev/md0  as a RAID1 array consisting of /dev/hda1
       and /dev/hdc1.

         eecchhoo ''DDEEVVIICCEE //ddeevv//hhdd**[[00--99]] //ddeevv//ssdd**[[00--99]]'' >> mmddaaddmm..ccoonnff
         mmddaaddmm ----ddeettaaiill ----ssccaann >>>> mmddaaddmm..ccoonnff
       This will create a prototype config  file  that  describes
       currently  active  arrays  that  are known to be made from
       partitions of IDE or SCSI drives.   This  file  should  be
       reviewed  before  being  used  as  it may contain unwanted
       detail.

         eecchhoo ''DDEEVVIICCEE //ddeevv//hhdd[[aa--zz]] //ddeevv//ssdd**[[aa--zz]]'' >> mmddaaddmm..ccoonnff
         mmddaaddmm ----eexxaammiinnee ----ssccaann ----ccoonnffiigg==mmddaaddmm..ccoonnff >>>> mmddaaddmm..ccoonnff
       This  will  find  what  arrays  could  be  assembled  from
       existign IDE and SCSI whole drives  (not  partitions)  and
       store  the  information  is  the  format of a config file.
       This file is very likely to contain unwanted detail,  par
       ticularly the ddeevviicceess== entries.  It should be reviewed and
       edited before being used as an actual config file.

         mmddaaddmm ----eexxaammiinnee ----bbrriieeff ----ssccaann ----ccoonnffiigg==ppaarrttiittiioonnss
         mmddaaddmm --EEbbsscc ppaarrttiittiioonnss
       Create a list of devices by reading //pprroocc//ppaarrttiittiioonnss, scan
       these  for  RAID superblocks, and printout a brief listing
       of all that was found.

         mmddaaddmm --AAcc ppaarrttiittiioonnss --mm 00 //ddeevv//mmdd00
       Scan all partitions and devices listed in //pprroocc//ppaarrttiittiioonnss
       and  assemble //ddeevv//mmdd00 out of all such devices with a RAID
       superblock with a minor number of 0.

         mmddaaddmm ----mmoonniittoorr ----ssccaann ----ddaaeemmoonniissee >> //vvaarr//rruunn//mmddaaddmm
       If config file contains a mail address or  alert  program,
       run mdadm in the background in monitor mode monitoring all
       md  devices.   Also  write  pid   of   mdadm   daemon   to
       //vvaarr//rruunn//mmddaaddmm.

         mmddaaddmm ----ccrreeaattee ----hheellpp
       Providew help about the Create mode.

         mmddaaddmm ----ccoonnffiigg ----hheellpp
       Provide help about the format of the config file.

         mmddaaddmm ----hheellpp
       Provide general help.



FFIILLEESS
   //pprroocc//mmddssttaatt
       If  you're  using the //pprroocc filesystem, //pprroocc//mmddssttaatt lists
       all active md devices with information about them.   mmddaaddmm
       uses  this  to  find  arrays  when ----ssccaann is given in Misc
       mode, and to monitor array reconstruction on Monitor mode.



   //eettcc//mmddaaddmm..ccoonnff
       The  config file lists which devices may be scanned to see
       if they contain MD  super  block,  and  gives  identifying
       information  (e.g.  UUID)  about  known  MD  arrays.   See
       mmddaaddmm..ccoonnff(5) for more details.



NNOOTTEE
       mmddaaddmm was previously known as mmddccttll.


SSEEEE AALLSSOO
       For information on the various levels of RAID, check out:


              http://ostenfeld.dk/~jakob/Software-RAID.HOWTO/

       for new releases of the RAID driver check out:


              ftp://ftp.kernel.org/pub/linux/kernel/peo
              ple/mingo/raid-patches

       or

              http://www.cse.unsw.edu.au/~neilb/patches/linux-
              stable/

       mmddaaddmm..ccoonnff(5), mmdd(4).

       _r_a_i_d_t_a_b(5), _r_a_i_d_0_r_u_n(8), _r_a_i_d_s_t_o_p(8), _m_k_r_a_i_d(8)



v1.4.0                                                   MDADM(8)
