/*
 * icp_nas_functions
 * change log :
 *		2003/04/03	Catherine Shen created
 */
#ifdef ICP_NAS_2
 #include <liblvm.h>
 #include <naslvm.h>

 //-----------------------------------------------------------------------------
 // get_raid_number
 // description : get the RAID device's number
 //-----------------------------------------------------------------------------
 int get_raid_number(char* device)
 {
	if (device==NULL) return -1;

	if (strstr(device, "/dev/md")!=NULL) {
		int raidno;

		raidno = atoi(device+7);
		return raidno;
	}
	else return -1;
 }
 //-----------------------------------------------------------------------------
 // convert_md_name
 // description : get required formated raid device name, if not raid device name
 //		just keep it
 // input :
 //	md_path : original device path
 //	mdname : output string
 //	buf_size : the size of the output buffer
 //	out_format : 1 -- long format (ex. /dev/md00), 0 -- short (ex. /dev/md0)
 //-----------------------------------------------------------------------------
 int convert_md_name(char* md_path, char* mdname, int buf_size, int out_format)
 {
	int raidno;

	if (md_path==NULL || mdname==NULL || strlen(md_path) > buf_size-1)
		return -1;

	raidno = get_raid_number(md_path);
	if (raidno>=0) {
		if (out_format) // long format
			sprintf(mdname, "/dev/md%02d", raidno);
		else
			sprintf(mdname, "/dev/md%d", raidno);
	}	
	else if (md_path!=mdname)
		strcpy(mdname, md_path);
	return SUCCESS;
 }

 int is_icp_nas_valid_vg_pv(char* vg_name, char* pv_name)
 {
 	int drvno;
 	char devname[HD_DEVICE_NAME_LENGTH];
 	char vgname[LV_PATH_MAX_LEN];
 	char* p;

	if (vg_name == NULL || pv_name == NULL) return 0;

	strncpy(devname, pv_name, HD_DEVICE_NAME_LENGTH-1);
	if (strlen(pv_name) > HD_DEVICE_NAME_LENGTH - 1)
		devname[HD_DEVICE_NAME_LENGTH-1] = 0x0;
	else
		devname[strlen(pv_name)] = 0x0;

	drvno = Get_Drive_No(devname);

	if (drvno > 0 && !Is_Raid_HD(drvno, devname, sizeof(devname))) {
		char datapart[HD_DEVICE_NAME_LENGTH];

		// is data partition?
		Get_Partition_Name(drvno, DATA_PART, datapart);

		if (strcmp(datapart, pv_name) != 0) return 0;

		strncpy(devname, pv_name, HD_DEVICE_NAME_LENGTH-1);
		if (strlen(pv_name) > HD_DEVICE_NAME_LENGTH - 1)
			devname[HD_DEVICE_NAME_LENGTH-1] = 0x0;
		else
			devname[strlen(pv_name)] = 0x0;
	}
	else {
		strncpy(devname, pv_name, HD_DEVICE_NAME_LENGTH-1);
		if (strlen(pv_name) > HD_DEVICE_NAME_LENGTH - 1)
			devname[HD_DEVICE_NAME_LENGTH-1] = 0x0;
		else
			devname[strlen(pv_name)] = 0x0;

		convert_md_name(devname, devname, sizeof(devname), 1);
		if (!Is_RaidDev_Exist(devname))
			return 0;
	}	

 	if (Get_VG_Name_By_Device(devname, vgname, sizeof(vgname))<0) {
 		return 0;
 	}
 	if ((p=strrchr(vgname, '/')) == NULL)
 		p = vgname;
 	else
 		p++;

 	if ((strcmp(vg_name, vgname) != 0) &&
 		(strcmp(vg_name, p) != 0)) return 0;

 	return 1; 
 }
#endif /* ICP_NAS_2 */
