/*
 * $Log:    $
 * 
 */

/***********************************************************************************/
/*                        M-Systems Confidential                                   */
/*           Copyright (C) M-Systems Flash Disk Pioneers Ltd. 1995-2001            */
/*                         All Rights Reserved                                     */
/***********************************************************************************/
/*                            NOTICE OF M-SYSTEMS OEM                              */
/*                           SOFTWARE LICENSE AGREEMENT                            */
/*                                                                                 */
/*      THE USE OF THIS SOFTWARE IS GOVERNED BY A SEPARATE LICENSE                 */
/*      AGREEMENT BETWEEN THE OEM AND M-SYSTEMS. REFER TO THAT AGREEMENT           */
/*      FOR THE SPECIFIC TERMS AND CONDITIONS OF USE,                              */
/*      OR CONTACT M-SYSTEMS FOR LICENSE ASSISTANCE:                               */
/*      E-MAIL = info@m-sys.com                                                    */
/***********************************************************************************/

//
// Spin locks
//

static void spin_lock_init(spinlock_t *splp)
{
	splp->lock = 0;
}

static void spin_lock(spinlock_t *splp)
{
	/* spin on bit lock */
	while (set_bit(0,&(splp->lock)) != 0)
		/* spin */ ;
}

static void spin_unlock(spinlock_t *splp)
{
        /* unlock simple bit lock */
	if (clear_bit(0,&(splp->lock)) == 0) {
		printk(KERN_ERR "msys/fl/spin_unlock() failed\n");
	}
}

//
// Signals
//

#define sigmask(signum) (1UL << ((signum) - 1))

static void siginitsetinv(sigset_t *set, unsigned long mask)
{
    *set = ~mask;
}

static void sigemptyset(sigset_t *set)
{
    *set = 0;
}

#define lock_kernel()  /* ToDo */
#define unlock_kernel()  /* ToDo */

//
// copy user space to/from kernel space
//

static inline unsigned long copy_to_user(void *to,
					 const void *from, unsigned long n)
{
	int i;
	if ((i = verify_area(VERIFY_WRITE, to, n)) != 0)
		return i;
	memcpy_tofs(to, from, n);
	return 0;
}

static inline unsigned long copy_from_user(void *to,
                                           const void *from, unsigned long n)
{
        int i;
        if ((i = verify_area(VERIFY_READ, from, n)) != 0)
                return i;
        memcpy_fromfs(to, from, n);
        return 0;
}

//
// Kernel threads.
//
#define exit_fs(foo)
#define exit_files(foo)

//
// I/O requests and locking
//

#define grab_io_request_lock(flags) do { save_flags(flags); cli(); } while (0)
    // spin_lock_irqsave(&io_request_lock,*(flgptr))
#define rlse_io_request_lock(flags) do { restore_flags(flags); } while (0)
    //spin_unlock_irqsave(&io_request_lock,*(flgptr))

static int end_that_request_first(struct request *req,
                                  int uptodate,
                                  char *devname)
{
    struct buffer_head * bh;
    int nsect;

    req->errors = 0;
    if (!uptodate)
	{
        printk("msys/fl/end_request_1st: I/O error, dev %s (%s), sector %lu\n",kdevname(req->rq_dev), devname, req->sector);
        if (NULL != (bh = req->bh))
		{
            nsect = bh->b_size >> 9;
            req->nr_sectors--;
            req->nr_sectors &= ~(nsect - 1);
            req->sector += nsect;
            req->sector &= ~(nsect - 1);
        }
    }

    if (NULL != (bh = req->bh))
	{
        req->bh = bh->b_reqnext;
        bh->b_reqnext = NULL;
 
        mark_buffer_uptodate(bh, uptodate);
        unlock_buffer(bh);
        if (NULL != (bh = req->bh))
		{
            req->current_nr_sectors = bh->b_size >> 9;
            if (req->nr_sectors < req->current_nr_sectors)
			{
                req->nr_sectors = req->current_nr_sectors;
                printk("msys/fl/end_request_1st: buffer-list destroyed\n");
            }
            req->buffer = bh->b_data;
            return(1);
        }
    }
    return(0);
}

static void end_that_request_last(struct request *req) {
    if (NULL != req->sem)
        up(req->sem);
    req->rq_status = RQ_INACTIVE;
    wake_up(&wait_for_request);
}
