#!/bin/bash

. build.conf

TARGET=hda
homedir=`pwd`
TMP=${homedir}/tmp/root

. tools.sh
check_arg mkrootfs.sh $1
select_model $1

#---------------------------------
# delete previous temp file
#---------------------------------
rm -rf $TMP/*

echo "Set Version and Build Number"
setcfg -f $homedir/$model/config/uLinux.conf System Version $VERSION
setcfg -f $homedir/$model/config/uLinux.conf System "Build Number" `/bin/date +%m%d`

# set default language
setcfg -f $homedir/$model/config/uLinux.conf System "Code Page" 437
setcfg -f $homedir/$model/config/smb.conf global "client code page" 437

echo "Set Apple Interface"
echo "`/sbin/getcfg Network Interface1 -f $homedir/$model/config/uLinux.conf -d eth0`" > $homedir/rootfs/etc/atalk/etc/atalkd.conf

echo "Mount /dev/ram (size=$ramdisk)..."
if [ ! -d /mnt/ram ]; then
	mkdir /mnt/ram
fi
umount /mnt/ram
dd if=/dev/zero of=/dev/ram bs=1k count=$ramdisk

echo "Create /mnt/ram and copy all the files..."
dd if=/dev/zero of=/dev/ram
mke2fs -m0 /dev/ram
mount /dev/ram /mnt/ram

echo
echo "delete origin root filesystem..."
rm -rf ${TMP}/*
if [ ! -d $TMP ]; then
	mkdir ${TMP}
fi

echo "copy root filesystem..."
cp -rav rootfs/* ${TMP} > /dev/null

echo "copy default config..."
cp -avf image/$model/config/* ${TMP}/etc/default_config

echo "---- del /home/httpd/v3_menu/image un-necessary files ----"
rm -rf ${TMP}/home/httpd/v3_menu/images/*
cp ${homedir}/rootfs/home/httpd/v3_menu/images/* ${TMP}/home/httpd/v3_menu/images -f
cp ${homedir}/rootfs/home/httpd/v3_menu/images/${model}/* ${TMP}/home/httpd/v3_menu/images -f

echo "----- del /home/httpd/cgi-bin/data un-necessary files -----"
cp ${homedir}/rootfs/home/httpd/cgi-bin/data/${model}/* ${TMP}/home/httpd/cgi-bin/data -f
while read NASMODEL
do
	prefix=`/bin/echo $NASMODEL | /bin/cut -c-3`
	if [ "$prefix" = "nas" ]; then
		rm -rf ${TMP}/home/httpd/cgi-bin/data/$NASMODEL
	fi
done < ./nas-model

####-----------------------------------------------
####	check NAS version (use help or help2 ?)
####-----------------------------------------------
tmpver=`/bin/echo $VERSION | /bin/cut -c-3`
if [ "$tmpver" = "2.1" ]; then
	echo "---- del /home/httpd/help2 files ----"
	rm -rf $TMP/home/httpd/help2
	HELP=help
else
	echo "---- del /home/httpd/help files ----"
	rm -rf $TMP/home/httpd/help
	echo "---- move help2 to help ----"
	mv $TMP/home/httpd/help2 $TMP/home/httpd/help
	HELP=help2
fi
echo "----- remove /home/httpd/help un-necessary files -----"
while read NASLANG
do
	if [ "$NASLANG" != "" ]; then
		while read NASMODEL
		do
			cp -vf ${homedir}/rootfs/home/httpd/$HELP/$NASLANG/${model}/* $TMP/home/httpd/help/$NASLANG -f
			prefix=`/bin/echo $NASMODEL | /bin/cut -c-3`
			if [ "$prefix" = "nas" ]; then
				rm -rf $TMP/home/httpd/help/$NASLANG/$NASMODEL
			fi
		done < ./nas-model
	fi
done < ./nas-lang


echo "delete IEI test files..."
rm -rf $TMP/sbin/test
#ln -sf $TMP/etc/logs/test $TMP/sbin/test
ln -sf ../etc/logs/test $TMP/sbin/test
echo "------- generate all necessary index files -------"
generate_lang_conf $model $homedir
$homedir/nasbin/genindex $homedir/$model/index/lang.conf $homedir/$model/index

echo "------- mystrip all html or htm files -------"
$homedir/nasbin/mystrip $TMP/home/httpd

#--------------------------------------------------
#	delete none support function related files
#--------------------------------------------------
echo "delete none support function related files"
if [ `getcfg "DNS Server" "Support" -f $homedir/$model/config/uLinux.conf -u -d FALSE` = FALSE ]; then
	echo "delete DNS related files"
	rm -f $TMP/usr/sbin/named
	rm -f $TMP/usr/sbin/named-xfer
	rm -rf $TMP/home/httpd/cgi-bin/network/ddns_setting
fi
if [ `getcfg "DDNS" "Support" -f $homedir/$model/config/uLinux.conf -u -d FALSE` = FALSE ]; then
	echo "delete DDNS related files"
        rm -f $TMP/usr/sbin/ez-ipupdate
	rm -rf $TMP/home/httpd/cgi-bin/network/dns_setting
fi
if [ `getcfg "Printers" "Support" -f $homedir/$model/config/uLinux.conf -u -d FALSE` = FALSE ]; then
	echo "delete PRINTER releted files"
        rm -f $TMP/usr/sbin/lpd
	rm -f $TMP/usr/bin/lpc
	rm -f $TMP/usr/bin/lpq
	rm -f $TMP/usr/bin/lpr
	rm -f $TMP/usr/bin/lprm
	rm -rf $TMP/home/httpd/cgi-bin/network/prn_setting
fi
if [ `getcfg "Network" "Interface Number" -f $homedir/$model/config/uLinux.conf -u -d 1` = 2 ]; then
	echo "delete one nic related files"
else
	echo "delete two nic related files"
fi
if [ `getcfg "NAT" "Support" -f $homedir/$model/config/uLinux.conf -u -d FALSE` = FALSE ]; then
	echo "delete NAT related files"
        rm -f $TMP/sbin/iptables
        rm -rf $TMP/usr/local/lib/iptables
	rm -rf $TMP/usr/local/lib/ulogd
	rm -f $TMP/usr/local/lib/libip*.a
	rm -f $TMP/usr/local/sbin/ulogd
	rm -rf $TMP/home/httpd/cgi-bin/firewall
fi
if [ `getcfg "PPPOE" "Support" -f $homedir/$model/config/uLinux.conf -u -d FALSE` = FALSE ]; then
	echo "delete PPPOE & PPTP related files"
        rm -f $TMP/usr/sbin/pppd
        rm -f $TMP/usr/sbin/pppoe
	rm -rf $TMP/usr/sbin/pptp
	rm -f $TMP/usr/sbin/pptp_callmgr
	rm -f $TMP/usr/sbin/adsl*
	rm -rf $TMP/home/httpd/cgi-bin/network/wlan_setting
fi
if [ `getcfg "WLAN" "Support" -f $homedir/$model/config/uLinux.conf -u -d FALSE` = FALSE ]; then
	echo "delete WLAN related files"
	rm -f $TMP/lib/modules/misc/p80211.o
	rm -f $TMP/lib/modules/misc/prism2_pci.o
	rm -f $TMP/sbin/brctl
	rm -f $TMP/sbin/wlanctl-ng
	rm -f $TMP/sbin/prism2dl
	rm -f $TMP/sbin/*.hex
fi
if [ `getcfg "UPS" "Support" -f $homedir/$model/config/uLinux.conf -u -d FALSE` = FALSE ]; then
	echo "delete UPS related files"
	rm -f $TMP/sbin/genpowerd
	rm -f $TMP/sbin/gengetstatus
	rm -rf $TMP/home/httpd/cgi-bin/ups_setting
	rm -f $TMP/lib/modules/misc/serial.o
fi
if [ `getcfg Storage "Support RAID 5" -f $homedir/$model/config/uLinux.conf -u -d FALSE` = FALSE ]; then
	echo "delete raid5 related files"
fi
if [ `getcfg "Storage" "SUPPORT HOTSWAP" -f $homedir/$model/config/uLinux.conf -u -d FALSE` = FALSE ]; then
	echo "delete hotspare related files"
fi
if [ `getcfg "Storage" "Support Hot Spare" -f $homedir/$model/config/uLinux.conf -u -d FALSE` = FALSE ]; then
	echo "delete hotspare related files"
fi
if [ `/sbin/getcfg Tape Support -f $homedir/$model/config/uLinux.conf -u -d FALSE` = FALSE ]; then
	echo "delete tape related files"
	rm -f $TMP/bin/mt
	rm -rf $TMP/etc/config/tape
fi

if [ `/sbin/getcfg System "Model" -f $homedir/$model/config/uLinux.conf -u` = "NAS-5100" ]; then
	echo "NAS-5100, creating SCSI hard disk devices and generic SCSI drivers"
	minor=0
	for i in a b c d e f g h i j k l m n o p q r s t u v w x y z
	do
		/bin/mknod $TMP/dev/sd${i} b 8 ${minor}
		minor2=${minor}
		for j in 1 2 3 4
		do
			minor2=`/usr/bin/expr ${minor2} + 1`
			/bin/mknod $TMP/dev/sd${i}${j} b 8 ${minor2}
		done
		minor=`/usr/bin/expr ${minor} + 16`
	done
	minor=0
	for i in a b c d e f g h i j k l m n o p q r s t u v w x y z
	do
		/bin/mknod $TMP/dev/sg${i} c 21 ${minor}
		minor=`/usr/bin/expr ${minor} + 1`
	done
else
	echo "Not NAS-5100"
fi

if [ `/sbin/getcfg System "USB Support" -f $homedir/$model/config/uLinux.conf -u -d FALSE` = FALSE ]; then
	echo "delete usb related files"
	rm -f $TMP/lib/modules/misc/hid.o
	rm -f $TMP/lib/modules/misc/input.o
	rm -f $TMP/lib/modules/misc/usb-ohci.o
	rm -f $TMP/lib/modules/misc/usbcore.o
	rm -rf $TMP/dev/usb/hid
else
	echo "creating usb devices $TMP/dev/usb/hid/*"
	mkdir -p $TMP/dev/usb/hid
	mknod $TMP/dev/usb/hid/hiddev0 c 180 96
	mknod $TMP/dev/usb/hid/hiddev1 c 180 97
	mknod $TMP/dev/usb/hid/hiddev2 c 180 98
	mknod $TMP/dev/usb/hid/hiddev3 c 180 99
	mknod $TMP/dev/usb/hid/hiddev4 c 180 100
	mknod $TMP/dev/usb/hid/hiddev5 c 180 101
	mknod $TMP/dev/usb/hid/hiddev6 c 180 102
	mknod $TMP/dev/usb/hid/hiddev7 c 180 103
	mknod $TMP/dev/usb/hid/hiddev8 c 180 104
	mknod $TMP/dev/usb/hid/hiddev9 c 180 105
	mknod $TMP/dev/usb/hid/hiddev10 c 180 106
	mknod $TMP/dev/usb/hid/hiddev11 c 180 107
	mknod $TMP/dev/usb/hid/hiddev12 c 180 108
	mknod $TMP/dev/usb/hid/hiddev13 c 180 109
	mknod $TMP/dev/usb/hid/hiddev14 c 180 110
fi
if [ `/sbin/getcfg RTRR Support -f $homedir/$model/config/uLinux.conf -u -d FALSE` = FALSE ]; then
	echo "delete rtrr related files"
	rm -f $TMP/sbin/rtrrd
#	rm -f $TMP/usr/bin/rsync
#	rm -f $TMP/usr/bin/rsyncd
#	rm -f $TMP/etc/rsyncd.conf
	rm -f $TMP/lib/modules/misc/rtrr.o
	rm -f $TMP/etc/rc2.d/S97rtrrd
#	rm -f $TMP/etc/rc2.d/S98rsyncd
	rm -f $TMP/etc/init.d/rtrrd.sh
#	rm -f $TMP/etc/init.d/rsyncd.sh
else
	echo "making rtrr related links"
	cd $TMP/etc/rc2.d
	ln -sf ../init.d/rtrrd.sh S97rtrrd
	ln -sf ../init.d/rsyncd.sh S98rsyncd
	mknod $TMP/dev/changedfiles c 40 0
fi
if [ `/sbin/getcfg UPS "USB UPS" -f $homedir/$model/config/uLinux.conf -u -d FALSE` = FALSE ]; then
	echo "delete usb ups related files"
	rm -rf $TMP/etc/apcupsd
	rm -f $TMP/etc/init.d/apcupsd
	rm -f $TMP/sbin/apcupsd
	rm -f $TMP/sbin/apcaccess
fi
echo "Delete /boot/*..."
rm -f ${TMP}/boot/*

echo "Clean /etc/mtab..."
> ${TMP}/etc/mtab

echo "Configure lilo corresponding files..."
if [ "$1" = "NAS-104R" -o "$1" = "NAS-2000" -o "$1" = "NAS-2000-SQP" ]; then
	cp -avf $homedir/nasbin/doc-lilo ${TMP}/sbin/lilo
fi

echo -n "Delete /bin/bash"
cd ${TMP}/bin
rm -f ${TMP}/bin/bash
ln -s kentbash bash

echo "Clean /var /tmp..."
cd ${TMP}/var
./clean
rm -rf /mnt/ram/tmp/*


echo "Clean DHCP cache..."
cd ${TMP}/etc/dhcpc
> dhcpcd-eth0.cache 
> dhcpcd-eth0.info

echo "Clean netatalk unused files..."
rm -f -v ${TMP}/usr/sbin/psf
# for atalk printer use
#rm -f -v ${TMP}/usr/sbin/papd
rm -f -v ${TMP}/usr/bin/papstatus
rm -rf -v ${TMP}/usr/lib/atalk/filters
rm -f -v ${TMP}/usr/bin/unbin
rm -f -v ${TMP}/usr/bin/unhex
rm -f -v ${TMP}/usr/bin/unsingle
rm -f -v ${TMP}/usr/bin/hqx2bin
rm -f -v ${TMP}/usr/bin/macbinary
rm -f -v ${TMP}/usr/bin/single2bin
rm -f -v ${TMP}/usr/bin/megatron

echo "Clean samba unused codepages..."
rm -f -v ${TMP}/usr/local/samba/lib/codepages/unicode_map.ISO8859-2
rm -f -v ${TMP}/usr/local/samba/lib/codepages/unicode_map.ISO8859-5
rm -f -v ${TMP}/usr/local/samba/lib/codepages/unicode_map.ISO8859-7

echo "Clean unused daemons..."
rm -f -v ${TMP}/usr/sbin/in.ftpd
#rm -f -v ${TMP}/usr/sbin/in.telnetd
rm -f -v ${TMP}/usr/sbin/nhfsstone

echo "Clean hwmon unused driver..."
rm -f -v ${TMP}/lib/modules/misc/e2keydemo
rm -f -v ${TMP}/sbin/e2keydemo

echo "Clean Linux unused share library..."
rm -f -v ${TMP}/usr/lib/libttf*

echo "--- Clean zoneinfo unused directories..."
rm -rf -v ${TMP}/usr/share/zoneinfo/Antarctica
rm -rf -v ${TMP}/usr/share/zoneinfo/Arctic
rm -rf -v ${TMP}/usr/share/zoneinfo/Brazil
rm -rf -v ${TMP}/usr/share/zoneinfo/Chile
rm -rf -v ${TMP}/usr/share/zoneinfo/China
rm -rf -v ${TMP}/usr/share/zoneinfo/Etc
rm -rf -v ${TMP}/usr/share/zoneinfo/Indian
rm -rf -v ${TMP}/usr/share/zoneinfo/Mexico
rm -rf -v ${TMP}/usr/share/zoneinfo/Mideast
rm -rf -v ${TMP}/usr/share/zoneinfo/SystemV
rm -rf -v ${TMP}/usr/share/zoneinfo/posix
rm -rf -v ${TMP}/usr/share/zoneinfo/right
echo "--- Clean zoneinfo unused single files..."
rm -f -v ${TMP}/usr/share/zoneinfo/CET
rm -f -v ${TMP}/usr/share/zoneinfo/CST6CDT
rm -f -v ${TMP}/usr/share/zoneinfo/Cuba
rm -f -v ${TMP}/usr/share/zoneinfo/EET
rm -f -v ${TMP}/usr/share/zoneinfo/EST
rm -f -v ${TMP}/usr/share/zoneinfo/EST5EDT
rm -f -v ${TMP}/usr/share/zoneinfo/Egypt
rm -f -v ${TMP}/usr/share/zoneinfo/Eire
rm -f -v ${TMP}/usr/share/zoneinfo/Factory
rm -f -v ${TMP}/usr/share/zoneinfo/GB
rm -f -v ${TMP}/usr/share/zoneinfo/GB-Eire
rm -f -v ${TMP}/usr/share/zoneinfo/GMT
rm -f -v ${TMP}/usr/share/zoneinfo/GMT+0
rm -f -v ${TMP}/usr/share/zoneinfo/GMT-0
rm -f -v ${TMP}/usr/share/zoneinfo/GMT0
rm -f -v ${TMP}/usr/share/zoneinfo/Greenwich
rm -f -v ${TMP}/usr/share/zoneinfo/HST
rm -f -v ${TMP}/usr/share/zoneinfo/Hongkong
rm -f -v ${TMP}/usr/share/zoneinfo/Iceland
rm -f -v ${TMP}/usr/share/zoneinfo/Iran
rm -f -v ${TMP}/usr/share/zoneinfo/Israel
rm -f -v ${TMP}/usr/share/zoneinfo/Jamaica
rm -f -v ${TMP}/usr/share/zoneinfo/Japan
rm -f -v ${TMP}/usr/share/zoneinfo/Kwajalein
rm -f -v ${TMP}/usr/share/zoneinfo/Libya
rm -f -v ${TMP}/usr/share/zoneinfo/MET
rm -f -v ${TMP}/usr/share/zoneinfo/MST
rm -f -v ${TMP}/usr/share/zoneinfo/MST7MDT
rm -f -v ${TMP}/usr/share/zoneinfo/NZ
rm -f -v ${TMP}/usr/share/zoneinfo/NZ-CHAT
rm -f -v ${TMP}/usr/share/zoneinfo/Navajo
rm -f -v ${TMP}/usr/share/zoneinfo/PRC
rm -f -v ${TMP}/usr/share/zoneinfo/PST8PDT
rm -f -v ${TMP}/usr/share/zoneinfo/Poland
rm -f -v ${TMP}/usr/share/zoneinfo/Portugal
rm -f -v ${TMP}/usr/share/zoneinfo/ROC
rm -f -v ${TMP}/usr/share/zoneinfo/ROK
rm -f -v ${TMP}/usr/share/zoneinfo/Singapore
rm -f -v ${TMP}/usr/share/zoneinfo/Turkey
rm -f -v ${TMP}/usr/share/zoneinfo/UCT
rm -f -v ${TMP}/usr/share/zoneinfo/UTC
rm -f -v ${TMP}/usr/share/zoneinfo/Universal
rm -f -v ${TMP}/usr/share/zoneinfo/W-SU
rm -f -v ${TMP}/usr/share/zoneinfo/WET
rm -f -v ${TMP}/usr/share/zoneinfo/Zulu
echo "--- Clean zoneinfo unused single files at sub-directories..."
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Abidjan
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Accra
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Addis_Ababa
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Algiers
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Asmera
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Bamako
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Bangui
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Banjul
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Bissau
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Blantyre
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Brazzaville
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Bujumbura
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Ceuta
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Conakry
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Dakar
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Dar_es_Salaam
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Djibouti
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Douala
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/El_Aaiun
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Freetown
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Gaborone
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Johannesburg
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Kampala
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Khartoum
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Kigali
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Kinshasa
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Lagos
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Libreville
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Lome
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Luanda
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Lubumbashi
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Lusaka
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Malabo
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Maputo
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Maseru
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Mbabane
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Mogadishu
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Monrovia
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Nairobi
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Ndjamena
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Niamey
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Nouakchott
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Ouagadougou
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Porto-Novo
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Sao_Tome
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Timbuktu
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Tunis
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Windhoek
rm -f -v ${TMP}/usr/share/zoneinfo/Africa/Tripoli
rm -f -v ${TMP}/usr/share/zoneinfo/America/Anguilla
rm -f -v ${TMP}/usr/share/zoneinfo/America/Antigua
rm -f -v ${TMP}/usr/share/zoneinfo/America/Araguaina
rm -f -v ${TMP}/usr/share/zoneinfo/America/Aruba
rm -f -v ${TMP}/usr/share/zoneinfo/America/Asuncion
rm -f -v ${TMP}/usr/share/zoneinfo/America/Barbados
rm -f -v ${TMP}/usr/share/zoneinfo/America/Belem
rm -f -v ${TMP}/usr/share/zoneinfo/America/Belize
rm -f -v ${TMP}/usr/share/zoneinfo/America/Boa_Vista
rm -f -v ${TMP}/usr/share/zoneinfo/America/Boise
rm -f -v ${TMP}/usr/share/zoneinfo/America/Cancun
rm -f -v ${TMP}/usr/share/zoneinfo/America/Catamarca
rm -f -v ${TMP}/usr/share/zoneinfo/America/Cayenne
rm -f -v ${TMP}/usr/share/zoneinfo/America/Cayman
rm -f -v ${TMP}/usr/share/zoneinfo/America/Chihuahua
rm -f -v ${TMP}/usr/share/zoneinfo/America/Cordoba
rm -f -v ${TMP}/usr/share/zoneinfo/America/Costa_Rica
rm -f -v ${TMP}/usr/share/zoneinfo/America/Cuiaba
rm -f -v ${TMP}/usr/share/zoneinfo/America/Curacao
rm -f -v ${TMP}/usr/share/zoneinfo/America/Dawson
rm -f -v ${TMP}/usr/share/zoneinfo/America/Dawson_Creek
rm -f -v ${TMP}/usr/share/zoneinfo/America/Dominica
rm -f -v ${TMP}/usr/share/zoneinfo/America/El_Salvador
rm -f -v ${TMP}/usr/share/zoneinfo/America/Fortaleza
rm -f -v ${TMP}/usr/share/zoneinfo/America/Glace_Bay
rm -f -v ${TMP}/usr/share/zoneinfo/America/Godthab
rm -f -v ${TMP}/usr/share/zoneinfo/America/Goose_Bay
rm -f -v ${TMP}/usr/share/zoneinfo/America/Grand_Turk
rm -f -v ${TMP}/usr/share/zoneinfo/America/Grenada
rm -f -v ${TMP}/usr/share/zoneinfo/America/Guadeloupe
rm -f -v ${TMP}/usr/share/zoneinfo/America/Guatemala
rm -f -v ${TMP}/usr/share/zoneinfo/America/Guayaquil
rm -f -v ${TMP}/usr/share/zoneinfo/America/Guyana
rm -f -v ${TMP}/usr/share/zoneinfo/America/Hermosillo
rm -f -v ${TMP}/usr/share/zoneinfo/America/Indiana
rm -f -v ${TMP}/usr/share/zoneinfo/America/Indiana/Marengo
rm -f -v ${TMP}/usr/share/zoneinfo/America/Indiana/Vevay
rm -f -v ${TMP}/usr/share/zoneinfo/America/Indiana/Indianapolis
rm -f -v ${TMP}/usr/share/zoneinfo/America/Indiana/Knox
rm -f -v ${TMP}/usr/share/zoneinfo/America/Inuvik
rm -f -v ${TMP}/usr/share/zoneinfo/America/Iqaluit
rm -f -v ${TMP}/usr/share/zoneinfo/America/Jujuy
rm -f -v ${TMP}/usr/share/zoneinfo/America/Juneau
rm -f -v ${TMP}/usr/share/zoneinfo/America/La_Paz
rm -f -v ${TMP}/usr/share/zoneinfo/America/Lima
rm -f -v ${TMP}/usr/share/zoneinfo/America/Louisville
rm -f -v ${TMP}/usr/share/zoneinfo/America/Maceio
rm -f -v ${TMP}/usr/share/zoneinfo/America/Managua
rm -f -v ${TMP}/usr/share/zoneinfo/America/Martinique
rm -f -v ${TMP}/usr/share/zoneinfo/America/Mendoza
rm -f -v ${TMP}/usr/share/zoneinfo/America/Menominee
rm -f -v ${TMP}/usr/share/zoneinfo/America/Miquelon
rm -f -v ${TMP}/usr/share/zoneinfo/America/Montevideo
rm -f -v ${TMP}/usr/share/zoneinfo/America/Montserrat
rm -f -v ${TMP}/usr/share/zoneinfo/America/Nassau
rm -f -v ${TMP}/usr/share/zoneinfo/America/Nipigon
rm -f -v ${TMP}/usr/share/zoneinfo/America/Nome
rm -f -v ${TMP}/usr/share/zoneinfo/America/Panama
rm -f -v ${TMP}/usr/share/zoneinfo/America/Pangnirtung
rm -f -v ${TMP}/usr/share/zoneinfo/America/Paramaribo
rm -f -v ${TMP}/usr/share/zoneinfo/America/Port-au-Prince
rm -f -v ${TMP}/usr/share/zoneinfo/America/Port_of_Spain
rm -f -v ${TMP}/usr/share/zoneinfo/America/Porto_Velho
rm -f -v ${TMP}/usr/share/zoneinfo/America/Puerto_Rico
rm -f -v ${TMP}/usr/share/zoneinfo/America/Rainy_River
rm -f -v ${TMP}/usr/share/zoneinfo/America/Rankin_Inlet
rm -f -v ${TMP}/usr/share/zoneinfo/America/Rosario
rm -f -v ${TMP}/usr/share/zoneinfo/America/Santo_Domingo
rm -f -v ${TMP}/usr/share/zoneinfo/America/Scoresbysund
rm -f -v ${TMP}/usr/share/zoneinfo/America/St_Kitts
rm -f -v ${TMP}/usr/share/zoneinfo/America/St_Lucia
rm -f -v ${TMP}/usr/share/zoneinfo/America/St_Vincent
rm -f -v ${TMP}/usr/share/zoneinfo/America/Swift_Current
rm -f -v ${TMP}/usr/share/zoneinfo/America/Tegucigalpa
rm -f -v ${TMP}/usr/share/zoneinfo/America/Thule
rm -f -v ${TMP}/usr/share/zoneinfo/America/Thunder_Bay
rm -f -v ${TMP}/usr/share/zoneinfo/America/Tortola
rm -f -v ${TMP}/usr/share/zoneinfo/America/Virgin
rm -f -v ${TMP}/usr/share/zoneinfo/America/St_Thomas
rm -f -v ${TMP}/usr/share/zoneinfo/America/Yakutat
rm -f -v ${TMP}/usr/share/zoneinfo/America/Yellowknife
rm -f -v ${TMP}/usr/share/zoneinfo/America/Porto_Acre
rm -f -v ${TMP}/usr/share/zoneinfo/America/Noronha
rm -f -v ${TMP}/usr/share/zoneinfo/America/Sao_Paulo
rm -f -v ${TMP}/usr/share/zoneinfo/America/Manaus
rm -f -v ${TMP}/usr/share/zoneinfo/America/Halifax
rm -f -v ${TMP}/usr/share/zoneinfo/America/Winnipeg
rm -f -v ${TMP}/usr/share/zoneinfo/America/Montreal
rm -f -v ${TMP}/usr/share/zoneinfo/America/Edmonton
rm -f -v ${TMP}/usr/share/zoneinfo/America/Vancouver
rm -f -v ${TMP}/usr/share/zoneinfo/America/Whitehorse
rm -f -v ${TMP}/usr/share/zoneinfo/America/Havana
rm -f -v ${TMP}/usr/share/zoneinfo/America/Jamaica
rm -f -v ${TMP}/usr/share/zoneinfo/America/Ensenada
rm -f -v ${TMP}/usr/share/zoneinfo/America/Mazatlan
rm -f -v ${TMP}/usr/share/zoneinfo/America/Adak
rm -f -v ${TMP}/usr/share/zoneinfo/America/Atka
rm -f -v ${TMP}/usr/share/zoneinfo/America/Chicago
rm -f -v ${TMP}/usr/share/zoneinfo/America/Fort_Wayne
rm -f -v ${TMP}/usr/share/zoneinfo/America/Indianapolis
rm -f -v ${TMP}/usr/share/zoneinfo/America/Knox_IN
rm -f -v ${TMP}/usr/share/zoneinfo/America/Detroit
rm -f -v ${TMP}/usr/share/zoneinfo/America/Denver
rm -f -v ${TMP}/usr/share/zoneinfo/America/Shiprock
rm -f -v ${TMP}/usr/share/zoneinfo/America/Los_Angeles
rm -f -v ${TMP}/usr/share/zoneinfo/America/New_York
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Aden
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Amman
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Anadyr
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Aqtau
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Aqtobe
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Ashkhabad
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Bahrain
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Beirut
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Bishkek
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Brunei
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Chungking
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Dacca
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Damascus
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Dili
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Dubai
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Dushanbe
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Gaza
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Harbin
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Hovd
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Irkutsk
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Jakarta
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Jayapura
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Kamchatka
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Kashgar
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Katmandu
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Krasnoyarsk
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Kuala_Lumpur
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Kuching
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Kuwait
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Macao
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Manila
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Nicosia
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Novosibirsk
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Omsk
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Phnom_Penh
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Pyongyang
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Qatar
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Rangoon
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Riyadh
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Saigon
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Samarkand
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Tashkent
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Tbilisi
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Thimbu
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Ujung_Pandang
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Ulan_Bator
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Ulaanbaatar
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Urumqi
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Vientiane
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Yerevan
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Jerusalem
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Tel_Aviv
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Riyadh87
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Riyadh88
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Riyadh89
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Shanghai
rm -f -v ${TMP}/usr/share/zoneinfo/Asia/Istanbul
rm -f -v ${TMP}/usr/share/zoneinfo/Atlantic/Bermuda
rm -f -v ${TMP}/usr/share/zoneinfo/Atlantic/Canary
rm -f -v ${TMP}/usr/share/zoneinfo/Atlantic/Cape_Verde
rm -f -v ${TMP}/usr/share/zoneinfo/Atlantic/Faeroe
rm -f -v ${TMP}/usr/share/zoneinfo/Atlantic/Jan_Mayen
rm -f -v ${TMP}/usr/share/zoneinfo/Atlantic/Madeira
rm -f -v ${TMP}/usr/share/zoneinfo/Atlantic/St_Helena
rm -f -v ${TMP}/usr/share/zoneinfo/Atlantic/Stanley
rm -f -v ${TMP}/usr/share/zoneinfo/Atlantic/Reykjavik
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/Lindeman
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/Lord_Howe
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/LHI
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/North
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/Queensland
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/South
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/Sydney
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/ACT
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/Canberra
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/NSW
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/Tasmania
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/Victoria
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/West
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/Yancowinna
rm -f -v ${TMP}/usr/share/zoneinfo/Australia/Broken_Hill
rm -f -v ${TMP}/usr/share/zoneinfo/Canada/Central
rm -f -v ${TMP}/usr/share/zoneinfo/Canada/Eastern
rm -f -v ${TMP}/usr/share/zoneinfo/Canada/Mountain
rm -f -v ${TMP}/usr/share/zoneinfo/Canada/Newfoundland
rm -f -v ${TMP}/usr/share/zoneinfo/Canada/Pacific
rm -f -v ${TMP}/usr/share/zoneinfo/Canada/Saskatchewan
rm -f -v ${TMP}/usr/share/zoneinfo/Canada/East-Saskatchewan
rm -f -v ${TMP}/usr/share/zoneinfo/Canada/Yukon
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Andorra
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Belfast
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Berlin
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Brussels
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Budapest
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Chisinau
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Copenhagen
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Dublin
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Gibraltar
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Kaliningrad
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Kiev
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Luxembourg
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Madrid
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Malta
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Minsk
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Monaco
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Oslo
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Prague
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Bratislava
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Riga
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Samara
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Simferopol
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Sofia
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Stockholm
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Tallinn
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Tirane
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Tiraspol
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Uzhgorod
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Vaduz
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Vatican
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Rome
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/San_Marino
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Vienna
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Vilnius
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Zagreb
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Ljubljana
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Skopje
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Zaporozhye
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Zurich
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Warsaw
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Lisbon
rm -f -v ${TMP}/usr/share/zoneinfo/Europe/Istanbul
rm -f -v ${TMP}/usr/share/zoneinfo/Mexico/BajaNorte
rm -f -v ${TMP}/usr/share/zoneinfo/Mexico/BajaSur
rm -f -v ${TMP}/usr/share/zoneinfo/Mexico/General
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Apia
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Chatham
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Easter
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Efate
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Enderbury
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Fakaofo
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Funafuti
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Galapagos
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Gambier
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Guadalcanal
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Johnston
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Kiritimati
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Kosrae
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Majuro
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Marquesas
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Nauru
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Niue
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Norfolk
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Noumea
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Palau
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Pitcairn
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Ponape
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Port_Moresby
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Rarotonga
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Saipan
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Tahiti
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Tarawa
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Tongatapu
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Truk
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Wake
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Wallis
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Yap
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Pago_Pago
rm -f -v ${TMP}/usr/share/zoneinfo/Pacific/Samoa
rm -f -v ${TMP}/usr/share/zoneinfo/US/Alaska
rm -f -v ${TMP}/usr/share/zoneinfo/US/Aleutian
rm -f -v ${TMP}/usr/share/zoneinfo/US/Arizona
rm -f -v ${TMP}/usr/share/zoneinfo/US/Hawaii
rm -f -v ${TMP}/usr/share/zoneinfo/US/Indiana-Starke
rm -f -v ${TMP}/usr/share/zoneinfo/US/Michigan
rm -f -v ${TMP}/usr/share/zoneinfo/US/Pacific
rm -f -v ${TMP}/usr/share/zoneinfo/US/Samoa

cp -av $TMP/* /mnt/ram > /dev/null

cp -av ${homedir}/etc/fstab /mnt/ram/etc
cp -av ${homedir}/etc/crontab /mnt/ram/etc
cp -av ${homedir}/etc/crontab /mnt/ram/etc/default_config

#--------------------------
# copy inittab
#--------------------------
if [ "$CONSOLE" = "yes" -o "$CONSOLE" = "Yes" ]; then
	cp -avf $homedir/etc/inittab.enable /mnt/ram/etc/inittab
else
	cp -avf $homedir/etc/inittab.disable /mnt/ram/etc/inittab
fi
cp -avf $homedir/etc/inittab.enable /mnt/ram/etc/inittab.enable
cp -avf $homedir/etc/inittab.disable /mnt/ram/etc/inittab.disable

setcfg -f /mnt/ram/etc/config/uLinux.conf System "System Device" /dev/${TARGET}

