#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../amit_open_include/sysinfo.h"
#include "../amit_open_include/open_debug.h"

#define WANIP			0x0000
#define LANIP			0x0001
#define LANMASK			0x0002
#define BRIDGEIP		0x0003
#define BRIDGEMASK		0x0004
#define DEVICEID		0x0005
#define VERSION			0x0006
#define WOLMAC			0x0007
#define WTYPE 			0x0008
#define _3GAUTOBACKUP  	0x0009
//
// ت:
//	qfileotθT
//
// J:
//	ret_p: return pointer
//	data_type:	WANIP, LANIP, BridgeIP, DeviceID
//
// X:
//	return 0 -- OK
//	return -1 -- NG
//
int read_sysinfo(void *ret_p, int data_type)
{
	FILE *fp;
	Sys_info sysinfo_temp;
	
	// file lock
	
	// }, ŪX
	fp = fopen(SYS_INFO_PATH, "r");
	if(fp == NULL)
	{
		Dprintf("open sysinfo error\n");
		return -1;
	}
	else
	{
		fread(&sysinfo_temp, sizeof(sysinfo_temp), 1, fp);
		fclose(fp);		

		// oUT
		switch(data_type)
		{
			case WANIP:
				*(unsigned long *)ret_p = sysinfo_temp.wan_ip;
				break;
			case LANIP:
				*(unsigned long *)ret_p = sysinfo_temp.lan_ip;
				break;
			case LANMASK:
				*(unsigned long *)ret_p = sysinfo_temp.lan_mask;
				break;
			case BRIDGEIP:
				*(unsigned long *)ret_p = sysinfo_temp.bridge_ip;		
				break;
			case BRIDGEMASK:
				*(unsigned long *)ret_p = sysinfo_temp.bridge_mask;
				break;
			case DEVICEID:
				strncpy((char *)ret_p, sysinfo_temp.device_ID, sizeof(sysinfo_temp.device_ID));
				break;
			case VERSION:
				strncpy((char *)ret_p, sysinfo_temp.VersionName, sizeof(sysinfo_temp.VersionName));
				break;
			case WOLMAC:
				memcpy((char *)ret_p, sysinfo_temp.wolmac, sizeof(sysinfo_temp.wolmac));
				break;
			case WTYPE:
				Dprintf("\n===== Read_sysinfo.c:GET WAN TYPE====\n ");
				(*(unsigned char* )ret_p) = sysinfo_temp.wtype;
				break;
			case _3GAUTOBACKUP:
				Dprintf("\n====GET IF 3G BACKUP==\n ");
				(*(unsigned char *)ret_p) = sysinfo_temp._3G_Auto_Backup;
			
				break;
			default:
				return -1;
		}
	}
	Dprintf("\n== == == Call Read_sysinfo.c OK== == == \n");
	return 0;

	// file unlock
}

unsigned long get_lanip()
{
	unsigned long lanip;
	
	if(read_sysinfo((void *)&lanip, LANIP) == 0)
		return lanip;	
	else
		return NULL;
}

unsigned long get_bridgeip()
{
	unsigned long bridgeip;
	
	if(read_sysinfo((void *)&bridgeip, BRIDGEIP) == 0)		
		return bridgeip;		
	else
		return NULL;
}


//
// ت:
//	Ǧ^wolmac
//
// J:
//	None
//
// ^:
//	wolmacr
//
char * get_wolmac()
{
	static char wolmac[6];
	
	if(read_sysinfo((void *)wolmac, WOLMAC) == 0)
		return wolmac;
	else
		return NULL;
}


//
// ت:
//	Ǧ^DeviceID
//
// J:
//	None
//
// ^:
//	DeviceIDr
//
char * get_DeviceID()
{
	static char DeviceID[16];
	
	if(read_sysinfo((void *)DeviceID, DEVICEID) == 0)
		return DeviceID;
	else
		return NULL;
}

//
// ت:
//	Ǧ^VersionName
//
// J:
//	None
//
// ^:
//	Versionr
//
char * get_VersionName()
{
	static char VersionName[32];
	
	if(read_sysinfo((void *)VersionName, VERSION) == 0)
		return VersionName;
	else
		return NULL;
}

// added 2007/07/30 cheng
unsigned  char  get_wan_type()
{
	static unsigned char wtype;
	if(read_sysinfo((void *)&wtype,WTYPE) == 0)
		return wtype;
	else
		return NULL;
}
unsigned char  get_3g_auto_backup()
{
	static unsigned char _3g_Auto_Backup;
	if(read_sysinfo((void *)&_3g_Auto_Backup , _3GAUTOBACKUP) == 0 )
		return _3g_Auto_Backup;
	else
		return NULL;
 

}

int get_3g_backup_status()
	
{
	 
	FILE *f;
	int status = 0;
	if((f=fopen("/var/run/backup_status","r"))!=NULL)
	{
		fscanf(f,"%d",&status);
		fclose(f);
	}
	return status;
}

int get_3g_link_status()
{
	   
	FILE *f;
	int status = 0;

	if((f=fopen("/var/run/3g_link_status","r"))!=NULL)
	{
		fscanf(f,"%d",&status);
		fclose(f);
	}
	return status;
}

