#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "sysinfo.h"
#include "open_debug.h"


extern void force_restart_dhcpcd(void);//
extern unsigned long getWANroute(char *p_wanname);//



int reset_pppserver_gateway(char* wantype_file)//
{
	FILE *fd;
	unsigned long gateway;
	unsigned char* gw_ip;
	char param[7][25], command[120];
	unsigned char dhcp_state[23];
	int i;

	fd = fopen(wantype_file,"r");
	if(fd != NULL) 		//check wantype and get server ip
	{
		for(i=0;i<7;i++)
		{
			memset(param[i],0,sizeof(param[i]));
			fgets(param[i],sizeof(param[i]),fd);
			ERASE_CARRY(param[i]);
		}
		fclose(fd);
	
		if(atoi(param[4])==1)	//dynamic ip
		{
			if( (fd=fopen("/var/run/wanget.result","r")) == NULL)
			{
				force_restart_dhcpcd();
				//wait for dhcpcd get ip
				for(i=0;i<300;i++)	//wait 3 Sec for get IP
				{
					if( (fd=fopen("/var/run/wanget.result","r")) != NULL)
					{
						memset(dhcp_state,0,sizeof(dhcp_state));
						fscanf(fd,"%s",dhcp_state);
						if(dhcp_state[0]=='1')
						{
							Dprintf("wait %d ms,dhcp_state->%c\n",i*10,dhcp_state[0]);
							fclose(fd);
							break;
						}
						else
						{
							usleep(10000);
							fclose(fd);
						}
					}
					else
					{
						usleep(10000);
					}
					if(i == (300-1))
					{
						Dprintf("Dhcpcd get wan ip failure!\n");
						return 0;
					}
				} //end for
			}
			gateway = getWANroute(WANPORTNAME);
			
			if(gateway == 0)
			{
				Dprintf("default gateway is 0.0.0.0 !\n");
			}
			else
			{
				gw_ip = (unsigned char*)&gateway;
				Sprintf(command	,"route add -host %s gw %d.%d.%d.%d dev %s"
								, param[2], gw_ip[0], gw_ip[1], gw_ip[2], gw_ip[3] ,WANPORTNAME);
				System(command);        //add l2tp server routing to routing table
				System("route del default");
			}
		}
		else if(atoi(param[4])==0)
		{
			//static ip routing rule has already been add. do nothing!
		}
	}
	else
	{	Dprintf("\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n");
		Dprintf("Can't open file '%s'",wantype_file);
		Dprintf("\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n");
		return 0;
	}
	return 1;
}

