#ifndef _SYSINFO_H
#define _SYSINFO_H

#define SYS_INFO_PATH	"/var/config/sysinfo"

#define WANIP		0x0000
#define LANIP		0x0001
#define BRIDGEIP	0x0002
#define DEVICEID	0x0003
#define VERSION		0x0004
#define WOLMAC		0x0005
#define WANMASK		0x0006
#define LANMASK		0x0007
#define BRIDGEMASK	0x0008

#define GET_WANIP()			get_ip(WANIP)
#define GET_WANMASK()		get_ip(WANMASK)
#define GET_LANIP()			get_ip(LANIP)
#define GET_LANMASK()		get_ip(LANMASK)
#define GET_BRIDGEIP()		get_ip(BRIDGEIP)
#define GET_BRIDGEMASK()	get_ip(BRIDGEMASK)

//add by cheng 2007/07/24 
#define MAX_L2TP_CLIENT_NUM         80 
#define MAX_NO_ACCOUNT_POOL         10
#define WT_L2TP                   0x04
#define MAX_PPTP_CLIENT_NUM         10
#define MAX_L2TP_SERVER_NUM         80
#define WT_PPTP                   0x03 
#define PPPOE_AUTO_BACKUP         0x04
#define WT_PPPOE      			  0x02    
#define WT_3G                     0x05    


typedef struct _sysinfo
{
	unsigned long wan_ip;
	unsigned long wan_mask;
	unsigned long lan_ip;
	unsigned long lan_mask;
	unsigned long bridge_ip;
	unsigned long bridge_mask;
	char device_ID[16];
	char VersionName[32];	
	unsigned char wolmac[6];
    unsigned char wtype;
	unsigned char _3G_Auto_Backup;
	
} Sys_info;

struct	dhcp_client_elm{
	unsigned long	client_ip;
	unsigned long	start_time;
	unsigned long	end_time;
	char	client_host[20];
	char	client_mac[6];
	char	reserv[2];
};

#	define	LANPORTNAME		"eth1"
#	define WANPORTNAME		"eth1"
#	define WLANPORTNAME    "wl0"  // wireless
#	define WDSPORTNAME     "wds"   // wds

#define PPPPORTNAME		"ppp0"
#define IPSECPORTNAME	"ipsec0"
#define BRIDGEPORTNAME	"br0"
#endif
