#ifndef _OPEN_INCLUDE_H
#define _OPEN_INCLUDE_H

#ifdef FOR_DEBUG
	#define Dprintf(x...)	 printf(x)
#else
	#define Dprintf(x...) do{}while(0);
#endif

#include <syslog.h>
#define Nprintf(x...)	syslog(LOG_INFO,x)

//////////////////////////////////////////////////////////////////////////
//
#ifdef	FOR_DEBUG
#	define System(command)																\
	{																					\
		printf("System: %s:%s:%d ->%s\n\r", __FILE__, __FUNCTION__, __LINE__, command);	\
		system(command);															\
	}
#else
#	define System(command)	system(command)
#endif

//////////////////////////////////////////////////////////////////////////
#ifdef  DEBUG_TRACE
#	define FUNC_LOG \
	{   \
		printf("FUNC:%s:%s:%d\n\r",__FILE__,__FUNCTION__,__LINE__); \
		fflush(stdout); \
	}
#else
#	define FUNC_LOG
#endif

//////////////////////////////////////////////////////////////////////////
//
#ifdef DEBUG_TRACE
#	define SHOW_LINE   \
	{   \
		printf("     %s:%s:%d\n\r",__FILE__,__FUNCTION__,__LINE__); \
		fflush(stdout); \
	}
#else
#	define SHOW_LINE
#endif


//////////////////////////////////////////////////////////////////////////
//
#ifdef FOR_DEBUG
#define Sprintf(_string, fmt, args...)							\
{																\
	sprintf(_string, fmt, ## args);								\
	if( strlen(_string) >= sizeof(_string) )					\
		printf("\r\n%s:%s:%d - string out of border\r\n\r\n",	\
					__FILE__, __FUNCTION__, __LINE__);			\
}
#else
#define Sprintf		sprintf
#endif

//////////////////////////////////////////////////////////////////////////
//
#ifdef FOR_DEBUG
#define Strcpy(dest, source)									\
{																\
	strcpy(dest, source);										\
	if( strlen(dest) >= sizeof(dest) )							\
		printf("\r\n%s:%s:%d - String out of border\r\n\r\n",	\
				__FILE__, __FUNCTION__, __LINE__);				\
}
#else
#define Strcpy	strcpy
#endif

//////////////////////////////////////////////////////////////////////////
//
#ifdef FOR_DEBUG
#define Strcat(dest, source)									\
{																\
	strcat(dest, source);										\
	if( strlen(dest) >= sizeof(dest) )							\
		printf("\r\n%s:%s:%d - String out of border\r\n\r\n",	\
				__FILE__, __FUNCTION__, __LINE__);				\
}
#else
#define Strcat strcat
#endif

//////////////////////////////////////////////////////////////////////////
//
#ifdef FOR_DEBUG
#define Assert(express)                                         \
{                                                               \
	if( 0==(express) ){                                         \
		printf("\r\n %s:%s:%d Assert express is False\r\n\r\n", \
			__FILE__, __FUNCTION__, __LINE__);                  \
		exit(-1);                                               \
	}                                                           \
}
#else
#define Assert(express)		{while(0);}
#endif

//////////////////////////////////////////////////////////////////////////
//
#ifdef FOR_DEBUG
#define Assert1(express, fmt, args...)							\
{                                                               \
	if( 0==(express) ){                                         \
		printf("\r\n %s:%s:%d Assert express is False\r\n",		\
			__FILE__, __FUNCTION__, __LINE__);                  \
		printf(fmt, ## args);									\
		printf("\r\n\r\n");										\
		exit(-1);                                               \
	}                                                           \
}
#else
#define Assert1(express, fmt, args...)	{while(0);}
#endif



//////////////////////////////////////////////////////////////////////////
//
#ifdef FOR_DEBUG
#define Warn(express, fmt, args...)										\
{																		\
		if( 0!=(express) ){												\
			printf("\r\n%s:%s:%d ", __FILE__, __FUNCTION__, __LINE__);	\
			printf(fmt, ## args);										\
			printf("\r\n");												\
		}																\
}
#else
#define Warn(express, fmt, args...)	{while(0);}
#endif

//////////////////////////////////////////////////////////////////////////
//
#ifdef FOR_DEBUG
#define Trace(fmt, args...)										\
{																\
	printf("%s:%s:%d ", __FILE__, __FUNCTION__, __LINE__);	\
	printf(fmt, ## args);										\
	printf("\r\n");												\
}
#else
#define Trace(fmt, args...)	{while(0);}
#endif



//////////////////////////////////////////////////////////////////////////
//
#define ERASE_CARRY(str)						\
{												\
	int _i, _length=strlen(str);				\
	for(_i=0; _i<_length; _i++)					\
			if('\n'==str[_i] || '\r'==str[_i])	\
			{									\
				str[_i]='\0';					\
				break;							\
			}									\
}



#endif
