/*
 * dhcpcd - DHCP client daemon -
 * Copyright (C) 1996 - 1997 Yoichi Hariguchi <yoichi@fore.com>
 * Copyright (C) January, 1998 Sergei Viznyuk <sv@phystech.com>
 * 
 * dhcpcd is an RFC2131 and RFC1541 compliant DHCP client daemon.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// added by lily@amit.com.tw for ARP checking -- 2006.06.06 (The devil number :D:D:D )

#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <net/if_packet.h>
#include <string.h>
#include <sys/ioctl.h>
#include <syslog.h>
#include <net/ethernet.h>

#define MAC_BCAST_ADDR		"\xff\xff\xff\xff\xff\xff"

struct packed_ether_header {
  u_int8_t  ether_dhost[ETH_ALEN];      /* destination eth addr */
  u_int8_t  ether_shost[ETH_ALEN];      /* source ether addr    */
  u_int16_t ether_type;                 /* packet type ID field */
} __attribute__((packed));

typedef struct arpMessage
{
  struct packed_ether_header	ethhdr;
  u_short htype;	/* hardware type (must be ARPHRD_ETHER) */
  u_short ptype;	/* protocol type (must be ETHERTYPE_IP) */
  u_char  hlen;		/* hardware address length (must be 6) */
  u_char  plen;		/* protocol address length (must be 4) */
  u_short operation;	/* ARP opcode */
  u_char  sHaddr[ETH_ALEN];	/* sender's hardware address */
  u_char  sInaddr[4];	/* sender's IP address */
  u_char  tHaddr[ETH_ALEN];	/* target's hardware address */
  u_char  tInaddr[4];	/* target's IP address */
  u_char  pad[18];	/* pad for min. Ethernet payload (60 bytes) */
} __attribute__((packed)) arpMessage;

const int inaddr_broadcast = INADDR_BROADCAST;
int DebugFlag=0;
/*****************************************************************************/
int arpCheck(unsigned long siaddr, unsigned long ciaddr, unsigned char *IfName,int IfName_len)
{
  int o=1;
  int dhcpSocket;
  struct ifreq	ifr;
  struct sockaddr_pkt sap;
  arpMessage ArpMsgSend,ArpMsgRecv;
  struct sockaddr addr;
  int j,i=0;
  unsigned char ClientHwAddr[ETH_ALEN];

  //---------added by lily@amit.com.tw-----------
  // for making arpCheck an independent function 
  
  memcpy(ifr.ifr_name,IfName, IfName_len);
  ifr.ifr_name[IfName_len]='\0';
  dhcpSocket = socket(AF_PACKET,SOCK_PACKET,htons(ETH_P_ALL));
  
  if ( dhcpSocket == -1 )
  {
	  //printf("socket error\n");
	  goto err;
  }
  if ( ioctl(dhcpSocket,SIOCGIFHWADDR,&ifr) )
  {
	  //printf("ioctrl error\n");
	  goto err;
  }
  if ( ifr.ifr_hwaddr.sa_family != ARPHRD_ETHER )
  {
	  //printf("dhcpStart: interface %s is not Ethernet\n",ifr.ifr_name);
	  goto err;
  }
  if ( setsockopt(dhcpSocket,SOL_SOCKET,SO_BROADCAST,&o,sizeof(o)) == -1 )
  {
	  //printf("dhcpStart: setsockopt\n");
	  goto err;
  }
  ifr.ifr_flags = IFF_UP | IFF_BROADCAST | IFF_NOTRAILERS | IFF_RUNNING;
  if ( ioctl(dhcpSocket,SIOCSIFFLAGS,&ifr) )
  {
	  //printf("dhcpStart: ioctl SIOCSIFFLAGS\n");
	  goto err;
  }
  
  memset(&sap,0,sizeof(sap));
  sap.spkt_family = AF_PACKET;
  sap.spkt_protocol = htons(ETH_P_ALL);
  memcpy(sap.spkt_device,IfName,IfName_len);
  if ( bind(dhcpSocket,(void*)&sap,sizeof(struct sockaddr)) == -1 )
  {
	//syslog(LOG_ERR,"dhcpStart: bind: %m\n");
  }

  memcpy(ClientHwAddr,ifr.ifr_hwaddr.sa_data,ETH_ALEN);
  //ip_id=time(NULL)&0xffff;
  //srandom(ip_id);
  
  //---------------------------------------------
  //---------End of lily@amit.com.tw modified----

  memset(&ArpMsgSend,0,sizeof(arpMessage));
  memcpy(ArpMsgSend.ethhdr.ether_dhost,MAC_BCAST_ADDR,ETH_ALEN);
  memcpy(ArpMsgSend.ethhdr.ether_shost,ClientHwAddr,ETH_ALEN);
  ArpMsgSend.ethhdr.ether_type = htons(ETHERTYPE_ARP);

  ArpMsgSend.htype	= htons(ARPHRD_ETHER);
  ArpMsgSend.ptype	= htons(ETHERTYPE_IP);
  ArpMsgSend.hlen	= ETH_ALEN;
  ArpMsgSend.plen	= 4;
  ArpMsgSend.operation	= htons(ARPOP_REQUEST);
  memcpy(ArpMsgSend.sHaddr,ClientHwAddr,ETH_ALEN);
  memcpy(&ArpMsgSend.tInaddr,ciaddr,4);
  memcpy(&ArpMsgSend.sInaddr,siaddr,4);

  if ( DebugFlag ) syslog(LOG_DEBUG,
    "broadcasting ARPOP_REQUEST for %u.%u.%u.%u\n",
    ArpMsgSend.tInaddr[0],ArpMsgSend.tInaddr[1],
    ArpMsgSend.tInaddr[2],ArpMsgSend.tInaddr[3]);
  do
    {
	  //send ARP msg
      do
    	{
      		if ( i++ > 4 ) goto no_reply; /*  5 probes  */
      		memset(&addr,0,sizeof(struct sockaddr));
      		memcpy(addr.sa_data,IfName,IfName_len);
      		if ( sendto(dhcpSocket,&ArpMsgSend,sizeof(arpMessage),0,
	   			&addr,sizeof(struct sockaddr)) == -1 )
			{
     			//printf("arpCheck: sendto error\n");
	      		goto err;
			}
    	}
      while ( peekfd(dhcpSocket,50000) ); /* 50 msec timeout */

	  //got something in socket
      do
    	{
      	  memset(&ArpMsgRecv,0,sizeof(arpMessage));
      	  j=sizeof(struct sockaddr);
      	  if ( recvfrom(dhcpSocket,&ArpMsgRecv,sizeof(arpMessage),0,
		    (struct sockaddr *)&addr,&j) == -1 )
    	    {
     	      	//syslog(LOG_ERR,"arpCheck: recvfrom: %m\n");
      			goto err;
    	    }
			if ( ArpMsgRecv.ethhdr.ether_type != htons(ETHERTYPE_ARP) )
				continue;
      		if ( ArpMsgRecv.operation == htons(ARPOP_REPLY) )
			{
				if ( DebugFlag ) 
					syslog(LOG_DEBUG,
						"ARPOP_REPLY received from %u.%u.%u.%u for %u.%u.%u.%u\n",
						ArpMsgRecv.sInaddr[0],ArpMsgRecv.sInaddr[1],
						ArpMsgRecv.sInaddr[2],ArpMsgRecv.sInaddr[3],
						ArpMsgRecv.tInaddr[0],ArpMsgRecv.tInaddr[1],
						ArpMsgRecv.tInaddr[2],ArpMsgRecv.tInaddr[3]);
			}
      		else
				continue;

			//got ARP reply
      		if ( memcmp(ArpMsgRecv.tHaddr,ClientHwAddr,ETH_ALEN) )
			{
				if ( DebugFlag )
	    			syslog(LOG_DEBUG,
	    				"target hardware address mismatch: %02X.%02X.%02X.%02X.%02X.%02X received, %02X.%02X.%02X.%02X.%02X.%02X expected\n",
	    				ArpMsgRecv.tHaddr[0],ArpMsgRecv.tHaddr[1],ArpMsgRecv.tHaddr[2],
	    				ArpMsgRecv.tHaddr[3],ArpMsgRecv.tHaddr[4],ArpMsgRecv.tHaddr[5],
	    				ClientHwAddr[0],ClientHwAddr[1],
						ClientHwAddr[2],ClientHwAddr[3],
						ClientHwAddr[4],ClientHwAddr[5]);
				continue;
			}
      		if ( memcmp(&ArpMsgRecv.sInaddr,ciaddr,4) )
			{
				if ( DebugFlag )
	    			syslog(LOG_DEBUG,
	    				"sender IP address mismatch: %u.%u.%u.%u received, %u.%u.%u.%u expected\n",
	    				ArpMsgRecv.sInaddr[0],ArpMsgRecv.sInaddr[1],ArpMsgRecv.sInaddr[2],ArpMsgRecv.sInaddr[3],
	    				((unsigned char *)ciaddr)[0],
	    				((unsigned char *)ciaddr)[1],
	    				((unsigned char *)ciaddr)[2],
	    				((unsigned char *)ciaddr)[3]);
				continue;
			}
      		goto err;
		}
		while ( peekfd(dhcpSocket,50000) == 0 );
	}
  while ( 1 );

no_reply:
  close(dhcpSocket);
  return 0;

err:
  close(dhcpSocket);
  return -1;
}

#if 0
/*****************************************************************************/
int arpRelease()  /* sends UNARP message, cf. RFC1868 */
{
  arpMessage ArpMsgSend;
  struct sockaddr addr;

/* build Ethernet header */
  memset(&ArpMsgSend,0,sizeof(arpMessage));
  memcpy(ArpMsgSend.ethhdr.ether_dhost,MAC_BCAST_ADDR,ETH_ALEN);
  memcpy(ArpMsgSend.ethhdr.ether_shost,ClientHwAddr,ETH_ALEN);
  ArpMsgSend.ethhdr.ether_type = htons(ETHERTYPE_ARP);

/* build UNARP message */
  ArpMsgSend.htype	= htons(ETHERTYPE_IP);
  ArpMsgSend.ptype	= htons(ETHERTYPE_IP);
  ArpMsgSend.plen	= 4;
  ArpMsgSend.operation	= htons(ARPOP_REPLY);
  memcpy(&ArpMsgSend.sInaddr,&DhcpIface.ciaddr,4);
  memcpy(&ArpMsgSend.tInaddr,&inaddr_broadcast,4);
 
  memset(&addr,0,sizeof(struct sockaddr));
  memcpy(addr.sa_data,IfName,IfName_len);
  if ( sendto(dhcpSocket,&ArpMsgSend,sizeof(arpMessage),0,
	      &addr,sizeof(struct sockaddr)) == -1 )
    {
    	#ifdef HSUJP
	#else
      		syslog(LOG_ERR,"arpRelease: sendto: %m\n");
      	#endif
      	return -1;
    }
  return 0;
}
/*****************************************************************************/
int arpInform()
{
  arpMessage ArpMsgSend;
  struct sockaddr addr;

  memset(&ArpMsgSend,0,sizeof(arpMessage));
  memcpy(ArpMsgSend.ethhdr.ether_dhost,MAC_BCAST_ADDR,ETH_ALEN);
  memcpy(ArpMsgSend.ethhdr.ether_shost,ClientHwAddr,ETH_ALEN);
  ArpMsgSend.ethhdr.ether_type = htons(ETHERTYPE_ARP);

  ArpMsgSend.htype	= htons(ARPHRD_ETHER);
  ArpMsgSend.ptype	= htons(ETHERTYPE_IP);
  ArpMsgSend.hlen	= ETH_ALEN;
  ArpMsgSend.plen	= 4;
  ArpMsgSend.operation	= htons(ARPOP_REPLY);
  memcpy(ArpMsgSend.sHaddr,ClientHwAddr,ETH_ALEN);
  memcpy(ArpMsgSend.tHaddr,DhcpIface.shaddr,ETH_ALEN);
  memcpy(ArpMsgSend.sInaddr,&DhcpIface.ciaddr,4);
  memcpy(ArpMsgSend.tInaddr,&inaddr_broadcast,4);
 
  memset(&addr,0,sizeof(struct sockaddr));
  memcpy(addr.sa_data,IfName,IfName_len);
  if ( sendto(dhcpSocket,&ArpMsgSend,sizeof(arpMessage),0,
	      &addr,sizeof(struct sockaddr)) == -1 )
    {
		syslog(LOG_ERR,"arpInform: sendto: %m\n");
      	return -1;
    }
  return 0;
}
#endif
