#ifndef _LINUX_LP_MODULE_H
#define _LINUX_LP_MODULE_H


#define LP_BUFFER_SIZE 256

#define LP_WAIT_ACK_TIMEOUT	1000

/* ioctl code */
#define IOCTL_GETSTATUS	0

/* printer status */
#define S_READY			0
#define S_NOT_READY		1
#define S_NO_PAPER		2
#define	S_DEVICE_ERROR	3

/*
 * flags
 */
#define LP_EXIST 0x0001
#define LP_SELEC 0x0002
#define LP_BUSY  0x0004
#define LP_OFFL  0x0008
#define LP_NOPA  0x0010
#define LP_ERR   0x0020
#define LP_ABORT 0x0040
#define LP_CAREFUL 0x0080
#define LP_ABORTOPEN 0x0100


/* timeout for each character.  This is relative to bus cycles -- it
 * is the count in a busy loop.  THIS IS THE VALUE TO CHANGE if you
 * have extremely slow printing, or if the machine seems to slow down
 * a lot when you print.  If you have slow printing, increase this
 * number and recompile, and if your system gets bogged down, decrease
 * this number.  This can be changed with the tunelp(8) command as well.
 */

#define LP_INIT_CHAR 1000

/* The parallel port specs apparently say that there needs to be
 * a .5usec wait before and after the strobe.  Since there are wildly
 * different computers running linux, I can't come up with a perfect
 * value, but since it worked well on most printers before without,
 * I'll initialize it to 0.
 */

#define LP_INIT_WAIT 0

/* This is the amount of time that the driver waits for the printer to
 * catch up when the printer's buffer appears to be filled.  If you
 * want to tune this and have a fast printer (i.e. HPIIIP), decrease
 * this number, and if you have a slow printer, increase this number.
 * This is in hundredths of a second, the default 2 being .05 second.
 * Or use the tunelp(8) command, which is especially nice if you want
 * change back and forth between character and graphics printing, which
 * are wildly different...
 */

#define LP_INIT_TIME 2

/* GPIO number */
//status
#define PRN_ACK		1
#define PRN_BUSY	15
#define PRN_PE		16		/* out of paper */
#define PRN_SLCT	17		/* Select */
#define PRN_ERROR	18		
//control
#define PRN_INIT	5
#define PRN_STROBE	4


/*
 * The following constants describe the various signals of the printer port
 * hardware.  Note that the hardware inverts some signals and that some
 * signals are active low.  An example is LP_STROBE, which must be programmed
 * with 1 for being active and 0 for being inactive, because the strobe signal
 * gets inverted, but it is also active low.
 */

/* 
 * bit defines for 8255 status port
 * base + 1
 * accessed with LP_S(minor), which gets the byte...
 */
//#define LP_PBUSY	0x80  /* inverted input, active high */
//#define LP_PACK		0x40  /* unchanged input, active low */
//#define LP_POUTPA	0x20  /* unchanged input, active high */
//#define LP_PSELECD	0x10  /* unchanged input, active high */
//#define LP_PERRORP	0x08  /* unchanged input, active low */
#define LP_PACK		0x00000002
#define LP_PBUSY	0x00008000
#define LP_POUTPA	0x00010000
#define LP_PSELECT  0x00020000
#define LP_PERRORP	0x00040000
/* 
 * defines for 8255 control port
 * base + 2 
 * accessed with LP_C(minor)
 */
//#define LP_PINTEN	0x10  /* high to read data in or-ed with data out */
//#define LP_PSELECP	0x08  /* inverted output, active low */
//#define LP_PINITP	0x04  /* unchanged output, active low */
//#define LP_PAUTOLF	0x02  /* inverted output, active low */
//#define LP_PSTROBE	0x01  /* short high output on raising edge */
#define LP_PSTROBE	0x00000010

/* 
 * the value written to ports to test existence. PC-style ports will 
 * return the value written. AT-style ports will return 0. so why not
 * make them the same ? 
 */
//#define LP_DUMMY	0x00

/*
 * This is the port delay time, in microseconds.
 * It is used only in the lp_init() and lp_reset() routine.
 */
#define LP_DELAY 	50

/*
 * delay time when printer busy or out-of-paper, in miniseconds
 */
#define LP_WAIT_BUSY	10
#define LP_WAIT_OUTPA	1000

#endif
