/* vi: set sw=4 ts=4: */
/*
 * Mini ps implementation(s) for busybox
 *
 * Copyright (C) 1999-2004 by Erik Andersen <andersen@codepoet.org>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 */

#if 1
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <ctype.h>
#include <string.h>
#include <termios.h>
#include <sys/ioctl.h>
#include "busybox.h"
#ifdef FEATURE_CPU_USAGE_PERCENTAGE
#include <linux/major.h>
#include <linux/types.h>
#include <asm/param.h>
#include <math.h>
#endif
#ifdef CONFIG_SELINUX
#include <fs_secure.h>
#include <ss.h>
#include <flask_util.h>          /* for is_flask_enabled() */
#endif

static const int TERMINAL_WIDTH = 79;      /* not 80 in case terminal has linefold bug */



extern int ps_main(int argc, char **argv)
{
	procps_status_t * p;
	int i, len;
	int terminal_width = TERMINAL_WIDTH;
#ifdef FEATURE_CPU_USAGE_PERCENTAGE
	long uptime_secs, seconds, total_time;
	char psbuf[40];
#endif

#ifdef CONFIG_SELINUX
	int use_selinux = 0;
	security_id_t sid;
	if(is_flask_enabled() && argv[1] && !strcmp(argv[1], "-c") )
		use_selinux = 1;
#endif

	get_terminal_width_height(0, &terminal_width, NULL);
	/* Go one less... */
	terminal_width--;

#ifdef FEATURE_CPU_USAGE_PERCENTAGE
	i = open("/proc/uptime", O_RDONLY);
	if (i==-1)	//cant open uptime
		exit(0);

	len = read(i, psbuf, sizeof(psbuf));
	close(i);

	if (len<=0)	//cant read uptime
		exit(0);

	psbuf[len] = '\0';

	sscanf(psbuf, "%lu.%lu %*s.%*s", &uptime_secs, &seconds);
	uptime_secs = uptime_secs*100+seconds;
#endif
	
#ifdef CONFIG_SELINUX
	if(use_selinux)
		printf("  PID Context                          Stat Command\n");
	else
#endif
		
#ifdef FEATURE_CPU_USAGE_PERCENTAGE
	printf("  PID  Uid     VmSize Stat %%CPU  Command\n");
#else
	printf("  PID  Uid     VmSize Stat Command\n");
#endif
	
#ifdef CONFIG_SELINUX
	while ((p = procps_scan(1, use_selinux, &sid)) != 0) {
#else
	while ((p = procps_scan(1)) != 0) {
#endif
		char *namecmd = p->cmd;

#ifdef CONFIG_SELINUX
		if(use_selinux)
		{
			char sbuf[128];
			len = sizeof(sbuf);
			if(security_sid_to_context(sid, (security_context_t)&sbuf, &len))
				strcpy(sbuf, "unknown");

			len = printf("%5d %-32s %s ", p->pid, sbuf, p->state);
		}
		else
#endif
		if(p->rss == 0)
			len = printf("%5d %-8s        %s ", p->pid, p->user, p->state);
		else
			len = printf("%5d %-8s %6ld %s ", p->pid, p->user, p->rss, p->state);
#ifdef FEATURE_CPU_USAGE_PERCENTAGE
		seconds = ((uptime_secs) - p->start_time) / 100;
		total_time = (p->utime + p->stime);
		p->pcpu = 	seconds ?  (total_time * 10.0 ) / seconds : 0;
		if (p->pcpu > 999) p->pcpu = 999;
		len += printf(" %2u.%u  ", p->pcpu / 10, p->pcpu % 10);
#endif
		i = terminal_width-len;

		if(namecmd != 0 && namecmd[0] != 0) {
			if(i < 0)
		i = 0;
			if(strlen(namecmd) > i)
				namecmd[i] = 0;
			printf("%s\n", namecmd);
		} else {
			namecmd = p->short_cmd;
			if(i < 2)
				i = 2;
			if(strlen(namecmd) > (i-2))
				namecmd[i-2] = 0;
			printf("[%s]\n", namecmd);
		}
		free(p->cmd);
	}
	return EXIT_SUCCESS;
}
#else	//NEW CODE
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <string.h>
#include <sys/stat.h>
#include <dirent.h>
#include <pwd.h>
#include <grp.h>
#include <time.h>
#include <linux/major.h>
#include <linux/types.h>
#include <sys/time.h>
#include <asm/param.h>
#include <math.h>

char psbuf[256];
char name[40];
int pid, state;
char statec;
int ppid, pgrp, session;
dev_t tty;
char tty_name[10];

char master[] = "pqrstuvwxyzabcde";

#define MAJOR(x) ((x) >> 8)
#define MINOR(x) ((x) & 0xff)
#ifndef isdigit
#define isdigit(X) ((X) >= '0' && (X) <= '9' ? 1 : 0)
#endif

int port_xlate[16] = {1, 3, 5, 7,9 ,11,13,15,
                      2, 4, 6, 8,10,12,14,16};

void dev_to_name(dev_t dev, char * Dttyname)
{
	strcpy(Dttyname, "");
	if (MAJOR(dev) == 75)
		sprintf(Dttyname,"X%d", (int)MINOR(dev));
	else if (MAJOR(dev) == TTY_MAJOR)
		sprintf(Dttyname,"S%d", (int)MINOR(dev)-64);
	else if (MAJOR(dev) == PTY_SLAVE_MAJOR)
		sprintf(Dttyname,"%c%x", master[MINOR(dev) / 16], (int)MINOR(dev) & 0xf);
}

static inline int is_all_digits(char *entry_name)
{
	int i;

	for(i=0;i<strlen(entry_name);i++)
		if (!isdigit(entry_name[i]))
			return 0;
	return 1;
}

int
ps_main(argc, argv)
	char	**argv;
{
	int h;
/* 	int max; */
	FILE * f;
	DIR * d;
	unsigned long bytes, sbytes;
	struct dirent * de;
	char *ext;
	int l;
	time_t time_now;
	long uptime_secs;
/* 	float idle_secs; */
	float seconds, start, total_time;
	int utime, Mstime, start_time;
	int pcpu;
	/*extern int _vfprintf_fp_ref, _vfscanf_fp_ref;*/

	fclose(stdin);

	printf("  PID PORT STAT   SIZE   SHARED %%CPU COMMAND\n"/*, _vfprintf_fp_ref, _vfscanf_fp_ref*/);

	h = open("/proc/uptime", O_RDONLY);

	if (h==-1) {
		perror("Unable to open /proc/uptime\n");
		exit(0);
	}

	l = read(h, psbuf, 255);

	close(h);


	if (l<=0) {
		perror("Unable to read uptime");
		exit(0);
	}


	psbuf[l] = '\0';
	psbuf[255] = '\0';

	ext = psbuf;


	uptime_secs = atol(ext);


	time_now = time(0);

	d = opendir("/proc");
	if (!d)
		return (1);

	while ((de = readdir(d)) != NULL) {
		if (!is_all_digits(de->d_name))
			continue;

		sprintf(psbuf, "/proc/%s/stat", de->d_name);

		h = open(psbuf, O_RDONLY);

		if (h==-1)
			continue;

		l = read(h, psbuf, 255);
		if (l<=0) {
			perror("Unable to read status");
			close(h);
			continue;
		}

		psbuf[l] = '\0';
		psbuf[255] = '\0';

		ext = (char *)strrchr(psbuf, ')');
		ext[0] = '\0';

		statec = ext[2];

		ext += 4;

		ppid = atoi(ext);
		ext = strchr(ext, ' ')+1;

		pgrp = atoi(ext);
		ext = strchr(ext, ' ')+1;

		session = atoi(ext);
		ext = strchr(ext, ' ')+1;

		tty = atoi(ext);
		ext = strchr(ext, ' ')+1;

		//printf("1|%s\n", ext);
		//tpgid
		ext = strchr(ext, ' ')+1;

		//printf("2|%s\n", ext);
		//flags
		ext = strchr(ext, ' ')+1;

		//printf("3|%s\n", ext);
		//min_flt
		ext = strchr(ext, ' ')+1;

		//printf("4|%s\n", ext);
		//cmin_flt
		ext = strchr(ext, ' ')+1;

		//printf("5|%s\n", ext);
		//maj_flt
		ext = strchr(ext, ' ')+1;

		//printf("6|%s\n", ext);
		//cmaj_flt
		ext = strchr(ext, ' ')+1;

		//printf("7|%s\n", ext);
		utime = atoi(ext);
		ext = strchr(ext, ' ')+1;

		//printf("8|%s\n", ext);
		Mstime = atoi(ext);
		ext = strchr(ext, ' ')+1;

		//printf("9|%s\n", ext);
		//cutime
		ext = strchr(ext, ' ')+1;

		//printf("10|%s\n", ext);
		//cstime
		ext = strchr(ext, ' ')+1;

		//priority
		ext = strchr(ext, ' ')+1;

		//nice
		ext = strchr(ext, ' ')+1;

		//timeout
		ext = strchr(ext, ' ')+1;

		//it_real_value
		ext = strchr(ext, ' ')+1;

		start_time = atoi(ext);

		ext = strchr(psbuf, '(');
		ext++;
		strcpy(name, ext);

		pid = atoi(psbuf);


		state = statec;

		close(h);

		dev_to_name(tty, tty_name);

		bytes = 0;
		sbytes = 0;
		sprintf(psbuf, "/proc/%s/status", de->d_name);

		f = fopen(psbuf, "r");

		if (f) {
			while (fgets(psbuf, 250, f)) {
				if (strncmp(psbuf, "Mem:", 4) == 0) {
					bytes = atol(psbuf+5);
				} else if (strncmp(psbuf, "Shared:", 7) == 0) {
					sbytes = atol(psbuf+8);
				}
			}
			fclose(f);
		}

		bytes /= 1024;
		sbytes /= 1024;

		seconds = ((uptime_secs * (long)HZ) - start_time) / HZ;

		/*printf("seconds=%s\n", gcvt(seconds, 15, psbuf));*/

		start = time_now - seconds;

		/*
		printf("1\n");

		gcvt(start, 15, psbuf);

		printf("2\n");

		printf("start=%s\n", psbuf);

		printf("utime=%d, Mstime=%d. start_time=%d\n", utime, Mstime, start_time);
		*/

		total_time = (utime + Mstime);

		/*printf("total_time=%s\n", gcvt(total_time, 15, psbuf));*/

		pcpu = 	seconds ?
			(total_time * 10.0 * 100.0 / (float)HZ) / seconds :
			0;
		if (pcpu > 999) pcpu = 999;


		sprintf(psbuf, "/proc/%s/cmdline", de->d_name);
		h = open(psbuf, O_RDONLY);

		if (h == -1) {
			perror("Unable to open cmdline");
			continue;
		}

		l = read(h, psbuf, 255);
		if (l < 0) {
			perror("Unable to read cmdline");
			close(h);
			continue;
		}

		close(h);

		psbuf[255] = psbuf[l] = '\0';


		printf("%5d %4s %c    %5ldK   %5ldK %2u.%u %s\n", pid, tty_name, state,
			bytes, sbytes,
			 pcpu / 10, pcpu % 10,
			 /*(int)seconds / 60, (int)seconds % 60,*/
			 l ? psbuf : name);
	}

	closedir(d);
	return(0);
}

#endif
