/* 
   Unix SMB/Netbios implementation.
   Version 1.9.
   status reporting
   Copyright (C) Andrew Tridgell 1994-1998
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Revision History:

   12 aug 96: Erik.Devriendt@te6.siemens.be
   added support for shared memory implementation of share mode locking

   21-Jul-1998: rsharpe@ns.aus.com (Richard Sharpe)
   Added -L (locks only) -S (shares only) flags and code

*/

/*
 * This program reports current SMB connections
 */

#define NO_SYSLOG

#include "includes.h"
#include "smbintl.h"
#define	MOUNT_PATH	"/share"

extern int DEBUGLEVEL;
extern FILE *dbf;

static pstring Ucrit_username = "";                   /* added by OH */
#define SMB_MAXPIDS		512
static pid_t		Ucrit_pid[SMB_MAXPIDS];  /* Ugly !!! */   /* added by OH */
static int            Ucrit_MaxPid=0;                        /* added by OH */
static unsigned int   Ucrit_IsActive = 0;                    /* added by OH */
char prefix[12]={0};

static void Ucrit_addPid(pid_t pid)
{
	int i;
	for (i=0;i<Ucrit_MaxPid;i++)
		if( pid == Ucrit_pid[i] ) return;
	Ucrit_pid[Ucrit_MaxPid++] = pid;
}

static unsigned int Ucrit_checkPid(pid_t pid)
{
	int i;
	if ( !Ucrit_IsActive) return 1;
	for (i=0;i<Ucrit_MaxPid;i++)
		if( pid == Ucrit_pid[i] ) return 1;
	return 0;
}


static void print_share_mode(share_mode_entry *e, char *fname)
{
	char path[64]={0};		

	if(!fname||!fname[0])
		return;
#undef sprintf	
	sprintf(path,"%s/%s",MOUNT_PATH,prefix);
	if(!strncmp(fname,path,strlen(path))){
		printf("print_share_mode:pid '%d'\n",e->pid);
		Ucrit_addPid(e->pid);
	}

	return;
}

static int traverse_fn1(TDB_CONTEXT *tdb, TDB_DATA kbuf, TDB_DATA dbuf, void *state)
{
	struct connections_data crec;
		
	if (dbuf.dsize != sizeof(crec))
		return 0;

	memcpy(&crec, dbuf.dptr, sizeof(crec));
	if (crec.cnum == -1)
		return 0;

	if (!process_exists(crec.pid)) {
		return 0;
	}
	printf("crec.name=%s,prefix=%s\n",crec.name,prefix);
	if( !strncmp(crec.name,prefix,strlen(prefix)) ){
		printf("traverse_fn1: pid '%d'\n",crec.pid);
		Ucrit_addPid(crec.pid);
	}
	  
	return 0;
}

int main(int argc, char *argv[])
{
	pstring fname;
	static pstring servicesf = CONFIGFILE;
	extern char *optarg;
	int ret=0,num=0;
	TDB_CONTEXT *tdb;

	TimeInit();
	if(argc!=2){
		printf("Usage: %s [FLASH_X|HDD_X]\n",argv[0]);
		return(1);
	}
	setup_logging(argv[0],True);
	memset(prefix,'\0',sizeof(prefix));
	strncpy(prefix,argv[1],sizeof(prefix)-1);
	setup_logging(argv[0],True);
	
	charset_initialise();

	DEBUGLEVEL = 0;
	dbf = stderr;
	
	if (getuid() != geteuid()) {
		printf("smbstatus should not be run setuid\n");
		return(1);
	}

	if (!lp_load(servicesf,False,False,False)) {
		fprintf(stderr, "Can't load %s - run testparm to debug it\n", servicesf);
		return (-1);
	}
	
	tdb = tdb_open_log(lock_path("connections.tdb"), 0, TDB_DEFAULT, O_RDONLY, 0);
	if (!tdb) {
		printf("connections.tdb not initialised\n");
		if (!lp_status(-1))
			printf("You need to have status=yes in your smb config file\n");
		return(0);
	}
	tdb_traverse(tdb, traverse_fn1, NULL);
	tdb_close(tdb);
	if (!locking_init(1)) {
		printf("Can't initialise locking module\n");
	}
	ret = share_mode_forall(print_share_mode);
	if (ret == 0) {
		printf("No locked files\n");
	}
	else if (ret == -1) {
		printf("locked file list truncated\n");
	}	
	while(num<Ucrit_MaxPid){
		kill(Ucrit_pid[num],SIGTERM);
		sleep(1);
		if(process_exists(Ucrit_pid[num]))
			kill(Ucrit_pid[num],SIGTERM);		
		num++;
	}
	locking_end();
	return (0);
}

