/* 
   Unix SMB/Netbios implementation.
   Version 1.9.
   status reporting
   Copyright (C) Andrew Tridgell 1994-1998
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Revision History:

   12 aug 96: Erik.Devriendt@te6.siemens.be
   added support for shared memory implementation of share mode locking

   21-Jul-1998: rsharpe@ns.aus.com (Richard Sharpe)
   Added -L (locks only) -S (shares only) flags and code

*/

/*
 * This program reports current SMB connections
 */

#define NO_SYSLOG

#include "includes.h"
#include "smbintl.h"

struct session_record{
  pid_t pid;
  uid_t uid;
  char machine[31];
  time_t start;
  struct session_record *next;
} *srecs;

extern int DEBUGLEVEL;
extern FILE *dbf;

#define DISK	0
#define	FLASH	1

//static pstring Ucrit_username = "";                   /* added by OH */
static pid_t	Ucrit_pid[100];  /* Ugly !!! */        /* added by OH */
static int            Ucrit_MaxPid=0;                        /* added by OH */
static unsigned int   Ucrit_IsActive = 0;                    /* added by OH */
static int type;

#if 0
static unsigned int Ucrit_checkUsername(char *username)
{
	if ( !Ucrit_IsActive) return 1;
	if (strcmp(Ucrit_username,username) ==0) return 1;
	return 0;
}

static unsigned int Ucrit_checkPid(pid_t pid)
{
	int i;
	if ( !Ucrit_IsActive) return 1;
	for (i=0;i<Ucrit_MaxPid;i++)
		if( pid == Ucrit_pid[i] ) return 1;
	return 0;
}

static void print_share_mode(share_mode_entry *e, char *fname)
{
	return;
}


#endif

static void Ucrit_addPid(pid_t pid)
{
	int i;
	if ( !Ucrit_IsActive) return;
	for (i=0;i<Ucrit_MaxPid;i++)
		if( pid == Ucrit_pid[i] ) return;
	Ucrit_pid[Ucrit_MaxPid++] = pid;
}



static int traverse_fn1(TDB_CONTEXT *tdb, TDB_DATA kbuf, TDB_DATA dbuf, void *state)
{
	//struct session_record *ptr;
	struct connections_data crec;
	//FILE *fp;
	//pstring unixname;
	pstring unixcrecname;

	if (dbuf.dsize != sizeof(crec))
		return 0;

	memcpy(&crec, dbuf.dptr, sizeof(crec));
	if (crec.cnum == -1)
		return 0;
//	if (!process_exists(crec.pid) || !Ucrit_checkUsername(uidtoname(crec.uid))) {
//		return 0;
//	}
	if (!process_exists(crec.pid))
		return 0;
	Ucrit_addPid(crec.pid); 
	if(type==FLASH){
		
		if(!strcmp(dos_to_unix(unixcrecname, crec.name),"FLASH")){
			kill(crec.pid,SIGTERM);
			if(process_exists(crec.pid))
				kill(crec.pid,SIGTERM);
		}
	}
	else{
		if(strcmp(dos_to_unix(unixcrecname, crec.name),"FLASH") && strcmp(dos_to_unix(unixcrecname, crec.name),"IPC$")){
			kill(crec.pid,SIGTERM);	
			if(process_exists(crec.pid))
				kill(crec.pid,SIGTERM);			
		}
	}			  

	return 0;
}




 int main(int argc, char *argv[])
{
	//pstring fname;
	static pstring servicesf = CONFIGFILE;
	extern char *optarg;
	//int ret=0;
	TDB_CONTEXT *tdb;

	TimeInit();
	if(argc!=2 || (strcmp(argv[1],"flash") && strcmp(argv[1],"disk"))){
		printf("Usage: %s [flash|disk]\n",argv[0]);
		return(1);
	}
	if(!strcmp(argv[1],"flash"))
		type=FLASH;
	else
		type=DISK;
	setup_logging(argv[0],True);
	
	charset_initialise();

	DEBUGLEVEL = 0;
	dbf = stderr;
	
	if (getuid() != geteuid()) {
		printf("smbstatus should not be run setuid\n");
		return(1);
	}

	if (!lp_load(servicesf,False,False,False)) {
		fprintf(stderr, "Can't load %s - run testparm to debug it\n", servicesf);
		return (-1);
	}
	
	tdb = tdb_open_log(lock_path("connections.tdb"), 0, TDB_DEFAULT, O_RDONLY, 0);
	if (!tdb) {
		printf("connections.tdb not initialised\n");
		if (!lp_status(-1))
			printf("You need to have status=yes in your smb config file\n");
		return(0);
	}
	tdb_traverse(tdb, traverse_fn1, NULL);
	if (!locking_init(1)) {
		//printf("Can't initialise locking module - exiting\n");
		exit(1);
	}
	locking_end();
	return (0);
}

