#ifndef _CONSTANT_H_
#define _CONSTANT_H_
#include "fsh_err.h"
   
#define DSK_NUM                                     2
#define FIRST_DSK                                   0 // First DSK
#define SECOND_DSK                                  1 // Second DSK

/*-------------------------------------------------------------------------------------------*/
#define DSK1_TYPE                                   DSK_TYPE_IDE
#define DSK2_TYPE                                   DSK_TYPE_USB

#define DSK_TYPE_IDE                                0                           /* IDE HDD */
#define DSK_TYPE_USB                                1                           /* USB HDD */

/*-------------------------------------------------------------------------------------------*/
#define DSK1_MODE                                   DSK_MODE_NORMAL
#define DSK2_MODE                                   DSK_MODE_SHARE

/*----------------------------------------------------------*/
#define DISK1_PUB_NAME      "DISK (Public Data)"
#define DISK2_PUB_NAME      "FLASH/USB HDD"
/*----------------------------------------------------------*/

/* 
 * normal mode means we will save config file to this HDD,
 * while share mode means we ONLY share the partitions in this HDD.
 */
#define DSK_MODE_NORMAL                             0
#define DSK_MODE_SHARE                              1

/*-------------------------------------------------------------------------------------------*/

/*
 * For historical reason, we should combine these two values
 *  
 *  Disk is not installed                   :       valid    ==   VALID_NOT_READY
 *                                                  invalid  ==   INVALID_NO_DISK
 *
 *  Disk is installed but not ready to use  :       valid    ==   VALID_NOT_READY
 *                                                  invalid  ==   INVALID_INSTALLED
 *
 *  Disk is ready to use                    :       valid    ==   VALID_READY
 *                                                  invalid  ==   INVALID_NO_DISK
 *
 *  Disk is in backup mode                  :       valid    ==   VALID_BACKUP
 *                                                  invalid  ==   INVALID_NO_DISK
 */
#define VALID_NOT_READY                             0
#define VALID_READY                                 1
#define VALID_BACKUP                                2

#define INVALID_NO_DISK                             0
#define INVALID_INSTALLED                           1

#define SWAP_SIZE                                   131072          //K (128MB)


#define LINE_SIZE                                   256

#define FSH_MaxUser                                 255
#define FSH_MaxGroup                                255
#define FSH_MaxShare                                255
                                                    
#define FSH_MaxUserLen                              20
#define FSH_MaxShareLen                             12
#define FSH_MaxGroupLen                             20
#define FSH_MaxCommentLen                           48
#define FSH_MaxDirLen                               256
#define FSH_MaxPassLen                              15
#define FSH_MaxIPLen                                16
#define FSH_MaxWorkGroupLen                         16
#define FSH_MaxZoneLen                              32
#define FSH_MaxPrinterLen                           12
#define FSH_MaxEnableLen                            4                       //"yes","no"
#define FSH_DefaultCodePage                         437
#define FSH_ADMINISTRATOR_GID                       500
#define FSH_EVERYONE_GID                            501
                                                    
#define FSH_ADMIN_UID                               500
#define FSH_GUEST_UID                               501
#define FSH_ADMINISTRATOR_UID                       502

#define FSH_ILLEGAL_ZONE_CHAR                       "\\]/\">[<.:;,|=+?`'"
#define FSH_ILLEGAL_WG_CHAR                         "\"/\\[]:;|=.,+*?<>"
#define FSH_ILLEGAL_PRINTER_CHAR                    "/\\[]:;|=., +*?<>'`\""
#define FSH_SPECIAL_CHAR                            "\"$\\`"
#define FLAG                                        ".g2_flag"

/*the simple_nas has one harddisk and one usb device, however, the efg120v2 has two harddisks, 
* so we must change something to make the code fitting simple_nas.
* ada, 2004.5.14
*/
#define __FOR_SINGLE_HDD_AND_USB_
#ifndef __FOR_SINGLE_HDD_AND_USB_
#define FSH_DEV_HD1                                 "/dev/hdc"
#define FSH_DEV_HD2                                 "/dev/hdd"
#else                                               
#undef _DEFRAG_                                  
#define FSH_DEV_HD1                                 "/dev/hda"
#define FSH_DEV_HD2                                 "/dev/sda"
#endif   /* __FOR_SINGLE_HDD_AND_USB_ */            
                                                    
#define FSH_MNT_ROOT                                "/harddisk"
#define FSH_HD1_NAME                                "hd~2"
#define FSH_HD2_NAME                                "hd~3"
#define FSH_DATA_NAME                               "data"
#define FSH_CONF_NAME                               "conf"
                                                    
                                                    
#define FSH_MNTHD1                                  FSH_MNT_ROOT"/"FSH_HD1_NAME              /* /harddisk/hd~2           */
#define FSH_MNTHD1_DATA                             FSH_MNTHD1"/"FSH_DATA_NAME               /* /harddisk/hd~2/data      */
#define FSH_MNTHD1_CONF                             FSH_MNTHD1"/"FSH_CONF_NAME               /* /harddisk/hd~2/conf      */
#define FSH_MNTHD1_SHARE_CONF                       FSH_MNTHD1_CONF"/share/share.info"       /* /harddisk/hd~2/conf/share/share.info */
#define FSH_MNTHD1_SMB_CONF                         FSH_MNTHD1_CONF"/share/smb.conf"         /* /harddisk/hd~2/conf/share/smb.conf */
#define FSH_MNTHD1_MAGIC                            FSH_MNTHD1_CONF"/"FLAG                   /* /harddisk/hd~2/conf/.g2_flag  */
#define FSH_MNTHD1_SHARE_SPOOL                      FSH_MNTHD1_CONF"/share/spool"                 /* /harddisk/hd~2/share/spool  */
                                                    
#define FSH_MNTHD2                                  FSH_MNT_ROOT"/"FSH_HD2_NAME              /* /harddisk/hd~3         */
#define FSH_MNTHD2_DATA                             FSH_MNTHD2"/"FSH_DATA_NAME               /* /harddisk/hd~3/data    */
#define FSH_MNTHD2_CONF                             FSH_MNTHD2"/"FSH_CONF_NAME               /* /harddisk/hd~3/conf    */
#define FSH_MNTHD2_SHARE_CONF                       FSH_MNTHD2_CONF"/share/share.info"       /* /harddisk/hd~3/conf/share/share.info */
#define FSH_MNTHD2_SMB_CONF                         FSH_MNTHD2_CONF"/share/smb.conf"         /* /harddisk/hd~3/conf/share/smb.info */
#define FSH_MNTHD2_MAGIC                            FSH_MNTHD2"/"FLAG                        /* /harddisk/hd~3/.g2_flag */
#define FSH_MNTHD2_SHARE_SPOOL                      FSH_MNTHD2_CONF"/share/spool"                 /* /harddisk/hd~3/share/spool  */
                                                    
#define LOG_FILE                                    "/var/log/server.log"
#define HDD_LOG_FILE                                FSH_MNTHD1_CONF"/server.log"
#define FLASH_LOG_FILE                              FSH_MNTHD2_CONF"/server.log"
                                                    
#define FSH_SMB_CONF                                "/etc/samba/smb.conf"
#define FSH_DISK_GROUP_INFO                         "/etc/usrgrp.info"
#define FSH_SHARE_CONF                              "/etc/share.info"
#define FSH_SHARE_CONF_NAME                         "share.info"
#define FSH_NETWORK_SEC                             "network"
#define FSH_SYS_PASSWD                              "/etc/passwd"
#define FSH_SMB_PASSWD                              "/etc/samba/smbpasswd"
#define FSH_WEB_PASSWD                              "/home/httpd/html/Management/.htpasswd"
#define FSH_SYS_GROUP                               "/etc/group"
#define FSH_DS_CONF_FILE                            "/etc/CGI_ds.conf"
#define FSH_DEF_DS_CONF_FILE                        "/usr/local/CGI_ds.conf"
#define FSH_QUOTA_TMPFILE                           "/tmp/edquota.tmp"
#define FSH_XINETD_FTP_CONF                         "/usr/local/xinetd.d/ftp"
#define FSH_INETD_CONF                              "/etc/inetd.conf"
#define FSH_PASSWD_SALT                             "sc"
#define FSH_EVERYONE_GRP                            "everyone"
#define FSH_SPOOL                                   "/var/spool"
#define FSH_SHARE_SPOOL                             "/var/spool/print"
#define FSH_SHARE_BAK_CONF                          "/usr/local/share.info.1"
                                                    
#ifndef __FOR_SINGLE_HDD_AND_USB_                                               
#define FSH_FLASH_SHARE_DIR                         "/share/flash/data"
#else
#define FSH_FLASH_SHARE_DIR                         "/share"
#endif
#define FSH_ADMIN_GRP                               "administrators"
#define FSH_ADMINISTRATOR_USER                      "admin"
#define FSH_ADMINISTRATOR_PASSWD                    ""
#define FSH_GUEST_USER                              "guest"
#define FSH_HDD_SHARE                               "ADMIN"
#define FSH_PUBLIC_SHARE                            "DISK"
#define FSH_FLASH_SHARE                             "FLASH"
#define FSH_DEFAULT_PASS                            "zGf8Ikl50e3aPM"
#define FSH_RESERVED_SHARE1                         FSH_HDD_SHARE
#define FSH_RESERVED_SHARE2                         FSH_PUBLIC_SHARE

#define FSH_THTTPD_HDD                              "HDD"
#define FSH_THTTPD_USB_FLASH                        "SHARE"

#define FSH_MNT_DIR_HDD                             "harddisk"
#define FSH_MNT_DIR_USB_FLASH                       "share"

//Backup file flag
#define fPass                                       1                               //passwd
#define fGrp                                        2                               //group
#define fShare                                      4                               //share.info
#define fUser                                       8                               //usrgrp.info
#define fSmb                                        0x10                            //smb.conf
#define fSmbPass                                    0x20                            //smbpasswd
#define fWebPass                                    0x40                            //.htpasswd
#define fGroups                                     (fGrp|fUser|fShare|fSmb)
#define fUsers                                      (fPass|fGrp|fUser|fSmbPass)
#define fShares                                     (fSmb|fShare)

#define UID_Start                                   2000
#define GID_Start                                   2000

#define USB_FLASH_DIR_NAME                          "flash"
#define USB_FLASH_INFO_NAME                         USB_FLASH_DIR_NAME

#define USB_HDD_DIR_NAME                            "usb_hdd"
#define USB_HDD_INFO_NAME                           USB_HDD_DIR_NAME

#define	MAX_ATTACH_DEV	4

#define USB_DEV                                     "/dev/sda"

/* Network part */
#define DEF_NET_IPADDR                              "192.168.0.100"
#define DEF_NET_NETMASK                             "255.255.255.0"
#define DEF_NET_BOOTPROTO                           "static"

#define DEF_NAME_PREFIX                             "SC"
#define DEF_NAME_LEN                                8	    /* default server name length: SCxxxxxx */
#define DEF_SMB_WORKGROUP                           "workgroup"     /* default value */
#define DEF_SMB_PRINTERNAME_LEN                     11             /* SCxxxxxx_p1 */
#define DEF_SMB_PRINTERNAME                         "lp"
#define DEF_SMB_CODEPAGE                            "437"           /* English */
#define DEF_SMB_RESOLVEORDER                        "wins bcast"

/* FLASH SIZE (MB) */
#define BIN_SIZE                                    8

#define CASE_SENSITIVE                              0
#define CASE_INSENSITIVE                            1

#endif /* _CONSTANT_H_ */

