/* thread.h
 * Thread utility
 *
 *---------------------------------------------------------------------------
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
 *---------------------------------------------------------------------------
 *
 *  system: SA1200
 *  subsystem: Common
 * Author: Intel Corporation
 * ---------------------------------------------------------------------
 */

#ifndef __THREAD_H
#define __THREAD_H

#include "ostype.h"


#if (OS == WIN_32)
#include <wtypes.h>
#include <winbase.h>

typedef HANDLE thread_T;
#define LOW_PRIORITY THREAD_PRIORITY_LOWEST
#define HIGH_PRIORITY THREAD_PRIORITY_HIGHEST
#define MID_PRIORITY THREAD_PRIORITY_NORMAL
#endif	                        /* WIN32 */

#if (OS == UCOS)
#include "os.h"
typedef int thread_T;

extern int getNextUniqueTaskID(void);

/* priority stuff are not used in uCOS */
#define HIGH_PRIORITY  0
#define LOW_PRIORITY   63
#define MID_PRIORITY  (LOW_PRIORITY + HIGH_PRIORITY)/2
#endif				/* UCOS */


#if (OS == VXWORKS)
#include <taskLib.h>
typedef int thread_T;
#define HIGH_PRIORITY  0
#define LOW_PRIORITY   255
#define MID_PRIORITY  (LOW_PRIORITY + HIGH_PRIORITY)/2
#endif				/* VXWORKS */


#if (OS == UNIX) 
#include <pthread.h>
typedef pthread_t thread_T;
typedef void  *(*pthread_startroutine_t) (void *);
typedef void  *pthread_addr_t;

#if defined(__sun)
#define HIGH_PRIORITY  -41
#define LOW_PRIORITY   -100
#endif

#if defined(__linux__)
#define HIGH_PRIORITY  99
#define LOW_PRIORITY   1
#endif

#if defined(__DECC) || defined(__DECCXX)
#define HIGH_PRIORITY  PRI_OTHER_MAX
#define LOW_PRIORITY   PRI_OTHER_MIN
#endif

#define MID_PRIORITY  (LOW_PRIORITY + HIGH_PRIORITY)/2
#endif				/* UNIX */

typedef void threadArg_T;
typedef void (*threadFunc_T)(void *);

#ifdef __cplusplus
extern "C"{
#endif

thread_T Thread_Create(int priority, void (*startFunc)(threadArg_T *), threadArg_T *arg);
int Thread_Cancel(thread_T thread);
int Thread_SetPriority(thread_T, int priority);
#ifdef __cplusplus
}
#endif

#endif /* __THREAD_H */

