/* thread.c
 * Thread utility
 *
 *---------------------------------------------------------------------------
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
 *---------------------------------------------------------------------------
 *  system: SA1200
 *  subsystem: Common
 * Author: Intel Corporation
 * ---------------------------------------------------------------------
 */

#include "ostype.h"
#include "thread.h"

#if (OS == WIN_32)

thread_T Thread_Create(int priority, void (* startFunc)(void *), threadArg_T *arg)
{
	thread_T thread;
	unsigned threadId;

	thread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE) startFunc,
						arg, 0,	&threadId);

	SetThreadPriority(thread, priority);
	return(thread);
}

int Thread_SetPriority(thread_T thread, int priority)
{
	return(SetThreadPriority(thread, priority));
}

int Thread_Cancel(thread_T thread)
{

    TerminateThread(thread, 0);
	CloseHandle(thread);
	return(0);
}
#endif		/* OS == WIN_32 */


#if (OS == VXWORKS)
thread_T Thread_Create(int priority, threadFunc_T startFunc, threadArg_T *arg)
{
   thread_T thread;

   thread = taskSpawn(NULL,				    /* task name tn will be assigned */
					    priority,			/* Priority */
						0,			        /* option word */
						1024 * 32,			    /* stack size bytes */
						(FUNCPTR) startFunc,/* Thread to run */
						(int) arg,0,0,0,0,0,0,0,0,0);	/* args */

  return(thread);
}

int Thread_SetPriority(thread_T thread, int priority)
{
	return(taskPrioritySet(thread, priority));
}

int Thread_Cancel(thread_T thread)
{
   return(taskDelete(thread));
}

#endif		/* OS == VXWORKS */


#if (OS == UCOS)
#include <stdlib.h>
#define STACKSIZE 0x400
#define STACKSIZE_BYTES 0x1000

static int nextUniqueTaskID = 10;

int getNextUniqueTaskID(void)
{
   nextUniqueTaskID++;
   return(nextUniqueTaskID);
}

thread_T Thread_Create(int priority, void(* startFunc)(void *) , threadArg_T *arg)
{
   unsigned int * Stack;

    Stack = (unsigned int*) malloc(STACKSIZE_BYTES);
    if (!Stack)
        return(-1);

   
   OSTaskCreate(   startFunc,
              arg,
              &Stack[STACKSIZE],
              priority,
              STACKSIZE*sizeof(int));


  return(priority);
}

int Thread_SetPriority(thread_T thread, int priority){
	/* not used for uCOS */
	return(0);
}


int Thread_Cancel(thread_T thread)
{
   /* later free stack kill task */
   return 0;
}

#endif		/* OS == UCOS */


#if (OS == UNIX)

thread_T Thread_Create(int priority, threadFunc_T startFunc, threadArg_T *arg)
{
   thread_T		thread;
   pthread_attr_t       thread_attr;
   struct sched_param   param;

   pthread_attr_init(&thread_attr);
   /* pthread_attr_setinheritsched(PTHREAD_EXPLICT_SCHED); */
   pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED);
   param.sched_priority = priority;
   pthread_attr_setschedparam(&thread_attr, &param);

   pthread_create(&thread, &thread_attr, (pthread_startroutine_t)startFunc, (pthread_addr_t)arg);
   return(thread);
}

int Thread_SetPriority(thread_T thread, int priority)
{
   struct sched_param param;
   param.sched_priority = priority;
   return(pthread_setschedparam(thread, SCHED_OTHER, &param));
}

int Thread_Cancel(thread_T thread)
{
   return(pthread_cancel(thread));
}

#endif  /* OS == UNIX */
