/*----------------------------------------------------------------------------
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
 ***************************************************************************
*/
#ifndef OSTYPE_H
#define OSTYPE_H

/*************************************************************************
 * This file is used to define two Operating System types:
 * VXWORKS
 * UCOS
 *
 * Files that depend on the type of the OS should include this file and
 * conditionalize their code along the lines of:
 * 
 * #if (OS == VXWORKS)
 * ...
 * #elif (OS == UCOS)
 * ...
 * #endif
 *
 * Then the command line for the module should include something to 
 * the effect:
 *
 *      ... -DOS=VXWORKS ...
 * or   ... -DOS=UCOS ...
 * etc.
 * 
 **********************************************************************/

#define VXWORKS   1
#define UCOS      2
#define WIN_32	   3
#define UNIX      4

/* try default settings */
#ifndef OS
 #if defined(WIN32)
 #define OS WIN_32
 #elif defined(__unix) || defined(__unix__)
 #define OS UNIX
 #endif
#endif

#ifndef OS
#error OS must be defined on the command line
#endif
#if ((OS != VXWORKS) && (OS != UCOS) && (OS != WIN_32) && (OS != UNIX))
#error "OS" contains an invalid value: OS
#endif

#endif
/* ifdef OSTYPE_H, leave blank line at end of this file, please */
