/**
 * ============================================================================
 * = COPYRIGHT
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
 *
 * = PRODUCT
 *      Intel(r) IXP425 Software Release
 *
 * = LIBRARY
 *      OSSL - Operating System Services  Library
 *
 * = MODULE
 *      OSSL Wrapper functions header file
 *
 * = FILENAME
 *      internal-osslThreadUtils.h
 *
 * = DESCRIPTION
 *      
 *   This file currently defines only one function, namely the thread-
 *   compliant entry point function that acts as a wrapper around the
 *   caller-provided entry point function.
 *
 *   Functions:  ix_ossl_thread_main_wrapper
 * = AUTHOR
 *     Intel Corporation
 *
 * = ACKNOWLEDGEMENTS
 *      
 *
 * = CREATION TIME
 *      1/8/2002 1:53:42 PM
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 */


#ifndef _OSSL_THREAD_UTILS_H
#define _OSSL_THREAD_UTILS_H

/* INCLUDES */
#include "ix_types.h"
#include "ix_macros.h"
#include "ix_error.h"

/* DEBUG DEFINES */

#undef IX_OSSL_DEBUG_MALLOC

/* MACROS */

#ifdef IX_OSSL_DEBUG_MALLOC
#define IX_OSSL_ERROR_MALLOC(__p, __type, __size, __err)                            \
        do                                                                          \
        {                                                                           \
            (__p) = (__type)malloc(__size);                                         \
            if((__p) == NULL)                                                       \
            {                                                                       \
                __err = ix_error_new(IX_ERROR_LEVEL_LOCAL,                          \
                                    IX_ERROR_OOM,                                   \
                                    0,                                              \
                                    "In file %s at line %d: malloc() failed\n"      \
                                    "Could not allocate %d bytes\n"                 \
                                    "for \"%s\" data type\n",                       \
                                    __FILE__, __LINE__, __size, #__type);           \
            }                                                                       \
            else                                                                    \
            {                                                                       \
                printf("[%d]: IX_OSSL_ERROR_MALLOC() called\n"                      \
                        "---> %p points to %d bytes of data of type %s\n\n",        \
                        (int)getpid(), __p, __size, #__type);                       \
            }                                                                       \
        }                                                                           \
        while(0)
#else
#define IX_OSSL_ERROR_MALLOC(__p, __type, __size, __err)                            \
        do                                                                          \
        {                                                                           \
            (__p) = (__type)malloc(__size);                                         \
            if((__p) == NULL)                                                       \
            {                                                                       \
  		printf("In file %s at line %d: malloc() failed\n"      \
                                    "Could not allocate %d bytes\n"                 \
                                    "for \"%s\" data type\n",                       \
                                    __FILE__, __LINE__, (INT32)__size, #__type);    \
            }                                                                       \
        }                                                                           \
        while(0)
#endif

#ifdef IX_OSSL_DEBUG_MALLOC
#define IX_OSSL_FREE_POINTER(__p)                               \
        do                                                      \
        {                                                       \
            if((__p) != NULL)                                   \
            {                                                   \
                printf("[%d]: IX_OSSL_FREE_POINTER() called\n"  \
                "---> %p has been freed\n\n",                   \
                (int)getpid(), __p);                            \
                                                                \
                free(__p);                                      \
                (__p) = NULL;                                   \
            }                                                   \
        }                                                       \
        while(0)
#else
#define IX_OSSL_FREE_POINTER(__p)                               \
        do                                                      \
        {                                                       \
            if((__p) != NULL)                                   \
            {                                                   \
                free(__p);                                      \
                (__p) = NULL;                                   \
            }                                                   \
        }                                                       \
        while(0)
#endif

/* FUNCTIONS */

#ifdef __cplusplus
extern "C"{
#endif

/**
*   ix_ossl_thread_main_wrapper
*
*   Purpose:    This funciton provides the needed entry point function. 
*               It basically acts as a wrapper around the user-provided function. 
*                
*
*   In:         ptrThreadInfo   pointer to our temporary structure
*                               containing pointers to the thread's
*                               entry point function and its
*                               argument structure
*
*   Out:        void
*/
void* ix_ossl_thread_main_wrapper(void* ptrThreadInfo);

#define IX_OSSL_ERROR_NEW(arg_ErrorCode,arg_ErrorLevel) IX_ERROR_NEW(arg_ErrorCode, IX_ERROR_GROUP_OSSL, arg_ErrorLevel)

#if 0
#define IX_OSSL_ERROR_NEW(arg_ErrorCode,arg_ErrorLevel) printf(" ix_ossl_failed  Error code %d \n",arg_ErrorCode);
#endif 

#ifdef __cplusplus
}
#endif

#endif /* _OSSL_THREAD_UTILS_H */
