/* delay.h
 * Common Library
 *
 *---------------------------------------------------------------------------
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
 *---------------------------------------------------------------------------
 *
 *
 *  system: SA1200
 *  subsystem: Debug Library
 * Author: Intel Corporation
 */
#ifndef __DELAY_H
#define __DELAY_H

#include <time.h>
#include "ostype.h"

#if (OS == UNIX)
#ifdef __cplusplus
extern "C" {
#endif
#define DELAYMS_RES 1
void delayMs(unsigned int msec);
void delayTick(unsigned int tick);
#ifdef __cplusplus
}
#endif
#endif

#if (OS == VXWORKS)
#include <taskLib.h>
#define DELAYMS_RES (1000/CLOCKS_PER_SEC)   /* milliseconds per clock tick (~ 16) */
#define delayMs(ms) taskDelay((ms)/DELAYMS_RES)
#define delayTick(t) taskDelay((t))
#endif

#if (OS == UCOS)
#include "os.h"
#define DELAYMS_RES (1000/CLOCKS_PER_SEC)   /* milliseconds per clock tick (~ 16) */
/* prevent a delay of zero from putting the task in a perpetual sleep */
#define delayMs(ms) OSTimeDly(((ms) < DELAYMS_RES) ? 1 : ((ms)/DELAYMS_RES))
#define delayTick(t) OSTimeDly(((t) < 1 ? 1 : (t)))
#endif

#if (OS == WIN_32)
#include<wtypes.h>
#include <winbase.h>
#define DELAYMS_RES 1  /* milliseconds per clock tick */
#define delayMs(ms) Sleep((ms))
#define delayTick(t) Sleep((t))
#endif
#endif		/* __DELAY_H */
