/* delay.c
 * Common Library
 *
 *---------------------------------------------------------------------------
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
 *---------------------------------------------------------------------------
 *  system: SA1200
 *  subsystem: Debug Library
 * Author: Intel Corporation
 * ---------------------------------------------------------------------
 */
#include "delay.h"
#if (OS == UNIX)
#include <pthread.h>
#endif

static const char __copyright[] =
"Copyright Intel Corp, 1998. All rights reserved";

/*-----------------------------------------------------------------------------
   Function: 	delayMs
   Description: Suspends the process for the specified milli-seconds
   Returns:		
   Uses:
   Modifies:
-----------------------------------------------------------------------------*/
#if (OS == UNIX)
void delayMs(unsigned int msec)
{
   struct timespec req, rem;
   unsigned int t;

   if(msec >= 1000) req.tv_sec = msec/1000;
   else req.tv_sec = 0;

   t = msec - (req.tv_sec * 1000);
   req.tv_nsec = t * 1000000;
#if (defined(__DECC) || defined(__DECCXX))
   pthread_delay_np(&req);
#else
   nanosleep(&req, &rem);
#endif
   return;
}

void delayTick(unsigned int tick)
{
   struct timespec req, rem;
   req.tv_sec = 0;
   req.tv_nsec = tick;
#if (defined(__DECC) || defined(__DECCXX))
   pthread_delay_np(&req);
#else
   nanosleep(&req, &rem);
#endif
   return;
}

#endif

