/*
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
*/
#include <asm-arm/system.h>
#include <asm-arm/semaphore.h>
#include <linux/kernel.h>
#include <linux/time.h>
#include <linux/sched.h> 
#include <linux/slab.h>

#include "vx.h"

struct {
    char name[16];
    FUNCPTR entry_pt;
    int arg[10];
} task_data;

DECLARE_MUTEX(data_mutex);

typedef int (*entry_pt_t)(int, int, int, int, int, int, int, int, int, int);

int task_data_start_internal(void *unused)
{
    int arg[10], i;
    FUNCPTR entry_pt = task_data.entry_pt;
    
    for (i = 0; i < 10; i++)
	arg[i] = task_data.arg[i];
    
    strncpy(current->comm, task_data.name, sizeof(current->comm));
    current->comm[sizeof(current->comm)-1] = 0;
    
    up(&data_mutex);
    
    ((entry_pt_t)entry_pt)(arg[0], arg[1], arg[2], arg[3], arg[4], arg[5],
	arg[6], arg[7], arg[8], arg[9]);
    return 0;
}
 
int taskSpawn(char *name, int priority, int options, int stack_sz,
    FUNCPTR entry_pt, int arg1, int arg2, int arg3, int arg4, int arg5,
    int arg6, int arg7, int arg8, int arg9, int arg10)
{
    pid_t pid;
	
    down(&data_mutex);
    
    memset(&task_data, 0, sizeof (task_data));
    strncpy(task_data.name, name, sizeof(task_data.name));
    task_data.name[sizeof(task_data.name)-1] = 0;
    task_data.entry_pt = entry_pt;

    task_data.arg[0] = arg1;
    task_data.arg[1] = arg2;
    task_data.arg[2] = arg3;
    task_data.arg[3] = arg4;
    task_data.arg[4] = arg5;
    task_data.arg[5] = arg6;
    task_data.arg[6] = arg7;
    task_data.arg[7] = arg8;
    task_data.arg[8] = arg9;
    task_data.arg[9] = arg10;
  
    pid = kernel_thread(task_data_start_internal, NULL, CLONE_SIGHAND);

    if (pid < 0)
    {
	up(&data_mutex);
	return ERROR;
    }
    
    return (int)pid;
}

STATUS taskDelete(int tid)
{
    kill_proc(tid, SIGKILL, 1);
    return OK;
}

int taskIdSelf(void)
{
    return (int)current->pid;
}

STATUS taskDelay(int ticks)
{
    if (ticks == 0 )
	{
	    schedule();
	    return OK;
	}

    current->state = TASK_INTERRUPTIBLE;
    schedule_timeout(ticks);
    return OK;
}

STATUS taskPrioritySet(int tid, int newPriority)
{
    return OK;
}

int sysClkRateGet(void)
{
    return HZ;
}

int clock_gettime(clockid_t clock_id, struct timespec *tp)
{
    do_gettimeofday((struct timeval *)tp);
    tp->tv_nsec *= 1000;
    return 0;
}

ULONG tickGet(void)
{
    return jiffies;
}

STATUS semGive(SEM_ID sem_id)
{
    up((struct semaphore *)sem_id);
    return OK;
}

STATUS semTake(SEM_ID sem_id, int timeout)
{
    int ret;
    switch (timeout)
    {
        case WAIT_FOREVER:
            down((struct semaphore *)sem_id);
            break;
        case NO_WAIT:
            ret = down_trylock((struct semaphore *)sem_id);
            return ret ? ERROR : OK;
        default:
        {
            unsigned int time = jiffies + timeout;
            for (;;)
            {
                ret = down_trylock((struct semaphore *)sem_id);
                if (!ret)
                    return OK;
                else
                {
                    if (time>jiffies)
                	return ERROR;
                }
                schedule();
            }
        return ERROR;
        }
    }
    return OK;
}

