/*
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
*/
#ifndef _STD_H_
#define _STD_H_

#include <linux/slab.h>
#include <linux/kernel.h>
#include <asm/semaphore.h>

#include <linux/in.h>
#include <linux/ip.h>
#include <linux/if_ether.h>

#define INET_ADDR_LEN		18

#define printf printk
#define malloc(size) kmalloc(size, GFP_ATOMIC)
#define free kfree

/* TODO */
#define rand()		net_random()
/* TODO */
#define srand(x)	net_srandom(x)

#define CODELETS_GETCHAR_ESC 27
extern struct semaphore __codlet_getchar;
static __inline__ int getchar(void)
{
    down(&__codlet_getchar);
    return CODELETS_GETCHAR_ESC;
}

/* for IxUART.h */
#undef CLOCAL
#undef CREAD 
#undef CSIZE 
#undef CS5   
#undef CS6   
#undef CS7   
#undef CS8   
#undef STOPB 
#undef PARENB
#undef PARODD

/* assert macro. TODO - all uses of this should be changed to IxAssert */
#define assert(E) if (!(E)) { printk("Assertion '%s' failed.\n",#E); }

#endif
