/**
 * @file IxOsServicesComponents.h
 *
 * @brief Header file for memory access
 *
 * @par
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 1999-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 */

#ifndef IxOsServicesComponents_H
#define IxOsServicesComponents_H

#if !defined (IxOsServicesMemAccess_H) && !defined (IxOsServicesMemMap_H)

#error IxOsServicesComponents.h should not be included directly - use IxOsServicesMemAccess.h instead

#endif /* protection against direct inclusion */

/* List of components maintained in this file
 * Please update the list when adding or removing component definitions
 * making sure you update the value definitions below, remembering to
 * prefix the component #define with "ix_"
 *
 * osServices
 * dmaAcc
 * atmdAcc
 * atmsch
 * ethAcc
 * npeMh
 * qmgr
 * npeDl
 * atmm
 * hssAcc
 * ethDB
 * ethMii
 * timerCtrl
 * adsl
 * usb
 * uartAcc
 * featureCtrl
 * cryptoAcc
 * perfProfAcc
 * flashUpgrade
 * codelets_uartAcc
 * codelets_timers
 * codelets_atm
 * codelets_ethAal5App
 * integration_hssAcc
 * codelets_demoUtils
 * codelets_usb
 * codelets_hssAcc
 * integration_adsl
 * integration_atmdAcc
 * integration_usb
 * integration_dma
 * unloadAcc
 */

/*
 * Component controlled defines
 *
 * Each component must define exactly one of the following mappings:
 *
 * CSR_BE_MAPPING
 * CSR_LE_DATA_COHERENT_MAPPING
 * CSR_LE_ADDRESS_COHERENT_MAPPING
 * CSR_NO_MAPPING
 *
 * If a component defined below does not access I/O mapped memory
 * then CSR_NO_MAPPING should be used. Alternatively,
 * the component could not use (include) IxOsServicesMem.h at all.
 *
 * In Big Endian systems the CSR_BE_MAPPING is defined by default
 * in IxOsServicesMem.h. If a component does not use I/O mapped
 * memory it must define CSR_NO_MAPPING.
 *
 * By default IX_STATIC_MEMORY_MAP is defined for all the components.
 * If any component uses a dynamic memory map it must define
 * IX_DYNAMIC_MEMORY_MAP in its corresponding section.
 */

#define ix_osServices          1
#define ix_dmaAcc              2
#define ix_atmdAcc             3

#define ix_atmsch              5
#define ix_ethAcc              6
#define ix_npeMh               7
#define ix_qmgr                8
#define ix_npeDl               9
#define ix_atmm                10
#define ix_hssAcc              11
#define ix_ethDB               12
#define ix_ethMii              13
#define ix_timerCtrl           14
#define ix_adsl                15
#define ix_usb                 16
#define ix_uartAcc             17
#define ix_featureCtrl         18
#define ix_cryptoAcc           19
#define ix_flashUpgrade        20
#define ix_codelets_uartAcc    21
#define ix_codelets_timers     22
#define ix_codelets_atm        23
#define ix_codelets_ethAal5App 24
#define ix_integration_hssAcc  25
#define ix_codelets_demoUtils  26
#define ix_codelets_usb        27
#define ix_codelets_hssAcc     28
#define ix_integration_adsl    29
#define ix_integration_atmdAcc 30
#define ix_integration_usb     31
#define ix_integration_dmaAcc  32
#define ix_unloadAcc           33
#define ix_perfProfAcc         34
#define ix_integration_perfProfAcc  35

/*********************************
 * Trap for not defining a value *
 * associated to the component   *
 *********************************/
#if (IX_COMPONENT_NAME == 0)

#error Invalid IX_COMPONENT_NAME

#endif

/***************************
 * osServices
 ***************************/
#if (IX_COMPONENT_NAME == ix_osServices)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* osServices */

/***************************
 * dmaAcc
 ***************************/
#if (IX_COMPONENT_NAME == ix_dmaAcc)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* dmaAcc */

/***************************
 * atmdAcc
 ***************************/
#if (IX_COMPONENT_NAME == ix_atmdAcc)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* atmdAcc */

/***************************
 * atmsch
 ***************************/
#if (IX_COMPONENT_NAME == ix_atmsch)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* atmsch */

/***************************
 * ethAcc
 ***************************/
#if (IX_COMPONENT_NAME == ix_ethAcc)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* ethAcc */

/***************************
 * npeMh
 ***************************/
#if (IX_COMPONENT_NAME == ix_npeMh)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* npeMh */

/***************************
 * qmgr
 ***************************/
#if (IX_COMPONENT_NAME == ix_qmgr)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* qmgr */

/***************************
 * npeDl
 ***************************/
#if (IX_COMPONENT_NAME == ix_npeDl)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* npeDl */

/***************************
 * atmm
 ***************************/
#if (IX_COMPONENT_NAME == ix_atmm)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* atmm */

/***************************
 * hssAcc
 ***************************/
#if (IX_COMPONENT_NAME == ix_hssAcc)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_NO_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* hssAcc */

/***************************
 * ethDB
 ***************************/
#if (IX_COMPONENT_NAME == ix_ethDB)

#define CSR_NO_MAPPING

#endif /* ethDB */

/***************************
 * ethMii
 ***************************/
#if (IX_COMPONENT_NAME == ix_ethMii)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* ethMii */

/***************************
 * timerCtrl
 ***************************/
#if (IX_COMPONENT_NAME == ix_timerCtrl)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* timerCtrl */

/***************************
 * adsl
 ***************************/
#if (IX_COMPONENT_NAME == ix_adsl)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_ADDRESS_COHERENT_MAPPING

#elif defined (IX_OSSERV_LINUX_BE)

/* uses dynamic mapped memory in linux */
#define IX_DYNAMIC_MEMORY_MAP

#endif /* OS selection */

#endif /* adsl */

/***************************
 * usb
 ***************************/
#if (IX_COMPONENT_NAME == ix_usb)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* usb */

/***************************
 * uartAcc
 ***************************/
#if (IX_COMPONENT_NAME == ix_uartAcc)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* uartAcc */

/***************************
 * featureCtrl
 ***************************/
#if (IX_COMPONENT_NAME == ix_featureCtrl)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* featureCtrl */

/***************************
 * cryptoAcc
 ***************************/
#if (IX_COMPONENT_NAME == ix_cryptoAcc)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* cryptoAcc */

/***************************
 * flashUpgrade
 ***************************/
#if (IX_COMPONENT_NAME == ix_flashUpgrade)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* flashUpgrade */

/***************************
 * codelets_usb
 ***************************/
#if (IX_COMPONENT_NAME == ix_codelets_usb)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* codelets_usb */

/***************************
 * integration_usb
 ***************************/
#if (IX_COMPONENT_NAME == ix_integration_usb)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* integration_usb */

/***************************
 * codelets_uartAcc
 ***************************/
#if (IX_COMPONENT_NAME == ix_codelets_uartAcc)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* codelets_uartAcc */

/***************************
 * codelets_timers
 ***************************/
#if (IX_COMPONENT_NAME == ix_codelets_timers)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* codelets_timers */

/***************************
 * codelets_atm
 ***************************/
#if (IX_COMPONENT_NAME == ix_codelets_atm)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* codelets_atm */

/***************************
 * codelets_ethAal5App
 ***************************/
#if (IX_COMPONENT_NAME == ix_codelets_ethAal5App)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* codelets_ethAal5App */

/***************************
 * integration_hssAcc
 ***************************/
#if (IX_COMPONENT_NAME == ix_integration_hssAcc)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* integration_hssAcc */

/***************************
 * codelets_demoUtils
 ***************************/
#if (IX_COMPONENT_NAME == ix_codelets_demoUtils)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* codelets_demoUtils */

/***************************
 * codelets_hssAcc
 ***************************/
#if (IX_COMPONENT_NAME == ix_codelets_hssAcc)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_NO_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif  /* codelets_hssAcc */

/***************************
 * integration_adsl
 ***************************/
#if (IX_COMPONENT_NAME == ix_integration_adsl)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif  /* integration_adsl */

/***************************
 * integration_atmdAcc
 ***************************/
#if (IX_COMPONENT_NAME == ix_integration_atmdAcc)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif  /* ix_integration_atmAcc */

/***************************
 * perfProfAcc
 ***************************/
#if (IX_COMPONENT_NAME == ix_perfProfAcc)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_ADDRESS_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* perfProfAcc */

/***************************
 * integration_perfProfAcc
 ***************************/
#if (IX_COMPONENT_NAME == ix_integration_perfProfAcc)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_ADDRESS_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif  /* ix_integration_perfProfAcc */


/***************************
 * unloadAcc
 ***************************/
#if (IX_COMPONENT_NAME == ix_unloadAcc)

#if defined (IX_OSSERV_VXWORKS_LE)

#define CSR_LE_DATA_COHERENT_MAPPING

#endif /* IX_OSSERV_VXWORKS_LE */

#endif /* unloadAcc */


#endif /* IxOsServicesComponents_H */

