/** 
 * @file IxUSBRNDISEnd.h
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
*/

/**
 * @ingroup IxUSBRNDIS
 *
 * @defgroup IxUSBRNDISEnd IXP425 USB RNDIS End Driver Codelet (IxUSBRNDIS) API
 *
 * @brief IXP425 codelet for RNDIS End API
 *
 * Description of the RNDIS End driver
 *
 * <b>Running the codelet in Linux.</b>
 * - insmod lib/linuxbe/ixp400.o
 * - insmod lib/linuxbe/ixp400_codelets_usb.o
 * - ifconfig usb0 x.x.x.x (Where x.x.x.x is the desired ip address of the 
 *                          interface)
 *
 * <b>Running the codelet in VxWorks big endian.</b>
 * - Load module that was built
 *   - ld < lib/vxbe/codelets_usbTest.out
 * - Run the codelet 
 *   - ixUSBRNDISStart	
 *   - ifAddrSet "usb0", "x.x.x.x" (Where x.x.x.x is the desired ip address 
 *                                  of the interface)
 *
 * <b>Running the codelet in VxWorks little endian.</b>
 * - Load module that was built
 *   - ld < lib/vxle/codelets_usbTest.out
 * - Run the codelet 
 *   - ixUSBRNDISStart 
 *   - ifAddrSet "usb0", "x.x.x.x" (Where x.x.x.x is the desired ip address 
 *                                  of the interface)
 *                         
 * The codelet is executed by calling the ixUSBRNDISStart function. No parameters
 * are needed to be passed in. The start function first loads and initializes 
 * the device driver. It then goes on to load the device driver
 * into the MUX. The function then goes on to call muxDevStart() passing in the 
 * called earlier. muxDevStart start the device that has already been initialized
 * and handles registering the driver's interrupt service routine and anything 
 * else necessary to handle receiving and transmitting. The function finally 
 * assigns an IP address to the RNDIS interface.
 * 
 *
 * <b>Overview of IxRNDISEnd.c</b>
 *
 * <b>Description of macros.</b>
 *
 * In this example driver the macros RNDIS_OUT_SHORT and RNDIS_IN_SHORT
 * are sample macros to read/write data to a mock device.  If a device
 * communicates through formatted control blocks in shared memory, the
 * accesses to those control blocks should also be through redefinable
 * macros.
 *
 * The macros SYS_INT_CONNECT, SYS_INT_DISCONNECT, and SYS_INT_ENABLE allow
 * the driver to be customized for BSPs that use special versions of these
 * routines.
 *
 * The macro SYS_INT_CONNECT is used to connect the interrupt handler to
 * the appropriate vector.  By default it is the routine intConnect().
 *
 * The macro SYS_INT_DISCONNECT is used to disconnect the interrupt handler prior
 * to unloading the module.  By default this is a dummy routine that
 * returns OK.
 *
 * The macro SYS_INT_ENABLE is used to enable the interrupt level for the
 * end device.  It is called once during initialization.  By default this is
 * the routine sysLanIntEnable(), defined in the module sysLib.o.
 *
 * The macro SYS_ENET_ADDR_GET is used to get the ethernet address (MAC)
 * for the device.  The single argument to this routine is the END_DEVICE
 * pointer.  By default this routine copies the ethernet address stored in
 * the global variable sysTemplateEnetAddr into the END_DEVICE structure.
 *
 * <b>Brief overview of the APIs.</b>
 * ixUSBRNDISStart()
 * - Initializes and starts the end driver. Called to run the codelet.
 *
 * END_OBJ* rndisLoad
 *   (
 *   char* initString,         
 *   void *unused
 *   )
 * - This routine initializes the driver and the device to the operational state.
 *   All of the device specific parameters are passed in the initString.
 *
 * rndisParse
 * (
 *   END_DEVICE * pDrvCtrl,   
 *   char * initString      
 * )
 * - Parse the input string.  Fill in values in the driver control structure.
 *
 * rndisMemInit
 * (
 *   END_DEVICE * pDrvCtrl  
 * )
 * - Initialize memory for the chip.
 *
 * rndisStart
 * (
 *  END_OBJ * pDrvCtrl  
 * )
 * - Handle controller interrupt.
 *
 * rndisRecv
 * (
 *  END_DEVICE *pDrvCtrl, 
 *  M_BLK_ID packet     
 * )
 * - Process the next incoming packet.
 *
 * rndisHandleRcvInt
 * (
 *  END_DEVICE *pDrvCtrl,    
 *  M_BLK_ID packet
 * ) 
 * - Task level interrupt service for input packets.
 *
 * rndisSend
 * (
 *  END_DEVICE * pDrvCtrl,    
 *  M_BLK_ID     pMblk    
 * )
 * - The driver send routine.  
 *
 * rndisIoctl
 * (
 *  END_DEVICE * pDrvCtrl,
 *  int cmd,          
 *  caddr_t data     
 * )
 * - The driver I/O control routine. 
 *
 * rndisConfig
 * (
 *  END_DEVICE *pDrvCtrl      
 * )
 * - Reconfigure the interface under us.
 *
 * rndisAddrFilterSet
 * (
 *  END_DEVICE *pDrvCtrl       
 * )
 * - Set the address filter for multicast addresses. 
 *
 * rndisPollRcv
 * (
 *  END_DEVICE * pDrvCtrl,   
 *  M_BLK_ID      pMblk     
 * )
 * - Routine to receive a packet in polled mode.
 *
 * rndisPollSend
 * (
 *  END_DEVICE*         pDrvCtrl,   
 *  M_BLK_ID    pMblk  
 * )
 * - Routine to send a packet in polled mode.
 *
 * rndisMCastAdd
 * (
 *  END_DEVICE *pDrvCtrl
 *  char* pAddress      
 * )
 * - Add a multicast address for the device.
 *
 * rndisMCastDel
 * (
 *  END_DEVICE *pDrvCtrl,         
 *  char* pAddress            
 * )
 * - Delete a multicast address for the device.
 *
 * rndisMCastGet
 * (
 *  END_DEVICE *pDrvCtrl,  
 *  MULTI_TABLE* pTable   
 * )
 * - Get the multicast address list for the device.
 *
 * rndisStop
 * (
 *  END_DEVICE *pDrvCtrl     
 * ) 
 *  - Stop the device.
 *
 * rndisUnload
 * (
 *  END_DEVICE* pDrvCtrl  
 * )
 * - Unload a driver from the system.
 *
 * rndisPollStart
 * (
 *  END_DEVICE * pDrvCtrl 
 * )
 * - Start polled mode operations. 
 *
 * rndisPollStop
 * (
 *  END_DEVICE * pDrvCtrl     
 * )
 * - Stop polled mode operations.
 *
 * rndisReset
 * (
 *  END_DEVICE *pDrvCtrl
 * )
 * - Reset device.
 * @{
 */

/**
 * @def RNDIS_END_INET_ADDR
 *
 * @brief RNDIS END driver with inet address
 */
#define RNDIS_END_INET_ADDR "192.168.1.1"

/**
 * @def RNDIS_END_MAC_ADDRESS 
 *
 * @brief RNDIS END driver with MAC address
 */
#define RNDIS_END_MAC_ADDRESS { 0x00, 0x00, 0x00, 0x00, 0x00, 0x02 }

/**
 * @ingroup IxUSBRNDISEnd
 *
 * @fn PUBLIC STATUS ixUSBRNDISStart(void)
 *
 * @brief Starts the RNDIS component
 *
 * @param None
 *
 * @return @li OK - Succesfully start RNDIS component
 * @return @li ERROR - Failed to start RNDIS component
 */
PUBLIC STATUS ixUSBRNDISStart(void);

/**
 * @ingroup IxUSBRNDISEnd
 *
 * @fn PUBLIC void rndisInt(void *pDrvCtrl, int packet)
 *
 * @brief RNDIS END hook for receiving packets 
 *
 * @param pDrvCtrl - pointer to END device
 * @param packet - received packet
 *
 * @return  None
 */
PUBLIC void rndisInt(void *pDrvCtrl, int packet);

/** @} defgroup IxUSBRNDISEnd*/
