/**
 * file IxHssAccCodeletConfig.h
 *
 * date 21 May 2002
 *
 * brief This file contains the interface for config implementation of
 * the HSS Access Codelet.
 *
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
 *
 * sa IxHssAccCodelet.h
 */

/**
 * ingroup IxHssAccCodelet
 *
 * defgroup IxHssAccCodeletConfig IXP425 HSS Access Codelet Config (IxHssAccCodeletConfig) API
 *
 * brief The interface for config implementation of the HSS Access Codelet.
 *
 * {
*/

#ifndef IXHSSACCCODELETCONFIG_H
#define IXHSSACCCODELETCONFIG_H

/*
 * #defines for function return types, etc.
 */

/*
 * Prototypes for interface functions.
 */

/**
 * ingroup IxHssAccCodeletConfig
 *
 * fn IxHssAccTdmSlotUsage ixHssAccCodeletChannelisedTimeslotGet (
           unsigned channelIndex)
 *
 * param unsigned channelIndex (in) - the voice channel index.
 *
 * This function returns the timeslot assignment for the specified voice
 * channel.
 *
 * return
 *     - the channel's timeslot assignment.
 */

IxHssAccTdmSlotUsage
ixHssAccCodeletChannelisedTimeslotGet (
    unsigned channelIndex);

#endif /* IXHSSACCCODELETCONFIG_H */

/**} defgroup IxHssAccCodeletConfig */

/**} defgroup Codelets*/
