/**
 * @file IxEthAccCodeletSymbols.c
 *
 * @date 14-Oct-2002
 *
 * @brief This file declares exported symbols for linux kernel module builds.
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 */

#ifdef __linux

#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <asm/semaphore.h>

#include "IxTypes.h"
#include "IxEthAcc.h"
#include "IxEthAcc_p.h"
#include "IxEthAccCodelet.h"

EXPORT_SYMBOL(ixEthAccCodeletMain);

int operationType = 0;
MODULE_PARM(operationType, "i");
MODULE_PARM_DESC(operationType, "EthAcc Codelet operation options (1-6)\n"
		 "\t1 - Rx Sink\n"
		 "\t2 - Sw Loopback\n"
		 "\t3 - Tx Gen/Rx Sink Loopback\n"
                 "\t4 - PHY Loopback\n"
		 "\t5 - Bridge\n"
		 "\t6 - DB Learning\n");

DECLARE_MUTEX_LOCKED(__codlet_getchar);
DECLARE_MUTEX_LOCKED(__codlet_end);

static int operation_func(void *unused)
{
    ixEthAccCodeletMain(operationType);
    up(&__codlet_end);
    return 0;
}

static int __init ethAccCodelet_init_module(void)
{
    printk ("Load Codelet: EthAcc.\n");
    if ((operationType < IX_ETHACC_CODELET_RX_SINK) || 
        (operationType > IX_ETHACC_CODELET_ETH_LEARNING))
    {
	printk("\nUsage :");
	printk("\n # insmod codelets_ethAcc.o operationType=<x>");
	printk("\n");	    
	printk("\n Where x : %d = Rx Sink", IX_ETHACC_CODELET_RX_SINK);
	printk("\n           %d = Sw Loopback", IX_ETHACC_CODELET_SW_LOOPBACK);
	printk("\n           %d = Tx Gen/Rx Sink Loopback", IX_ETHACC_CODELET_TXGEN_RXSINK);
	printk("\n           %d = PHY Loopback", IX_ETHACC_CODELET_PHY_LOOPBACK);
	printk("\n           %d = Bridge",IX_ETHACC_CODELET_BRIDGE);
        printk("\n           %d = Eth DB Learning", IX_ETHACC_CODELET_ETH_LEARNING);        
	printk("\n");
        return 1;
    }
    kernel_thread(operation_func, NULL, CLONE_SIGHAND);
    return 0;
}

static void __init ethAccCodelet_cleanup_module(void)
{
    ixEthAccDataPlaneShow();
    up(&__codlet_getchar);
    down(&__codlet_end);
    ixEthAccCodeletUninit();
    printk("Unload Codelet: Ethernet Access Codelet.\n");
}

module_init(ethAccCodelet_init_module);
module_exit(ethAccCodelet_cleanup_module);

#endif
