/**
 * @file IxAdslCtrleLib.h
 *
 * @date 2-Jun-2003
 *
 * @brief  ADSL Driver CTRL-E Library header file adopted from STMicro(formerly Alcatel) reference design
 *         dated 29-April-2000
 *
 * Design Notes:
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2000-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 */

#if !defined(ASW_CTRLEHEADER)
#define	ASW_CTRLEHEADER

#include "IxAdslCtrleConstants.h"
#include "IxAdslUtil.h"
typedef     int bool;
typedef	struct T_swVersion
{	unsigned char near_end;
    unsigned char far_end;
}T_swVersion;

typedef	struct T_VendorId
{	unsigned short near_end;
    unsigned short far_end;
}T_VendorId;

typedef	struct T_DMTEngineInfo
{	unsigned short version;
}T_DMTEngineInfo;

typedef	struct T_Controller_SW_version
{	unsigned char number1,number2,number3;
}T_Controller_SW_version;

typedef	struct T_LTadslNearEndLineOperData
{	unsigned short relCapacityOccupationUpstr;
    unsigned short attainableBitrate;
    signed char noiseMarginUpstr;
    signed char outputPowerDnstr;
    unsigned char attenuationUpstr;
    unsigned char carrierLoad[128];
        unsigned short interleavedBitRate;
        unsigned short fastBitRate;
}T_LTadslNearEndLineOperData;

typedef	struct T_LTadslFarEndLineOperData
{	unsigned short relCapacityOccupationDnstr;
    unsigned short attainableBitrate;
    signed char noiseMarginDnstr;
    signed char outputPowerUpstr;
    unsigned char attenuationDnstr;
        unsigned short interleavedBitRate;
        unsigned short fastBitRate;
}T_LTadslFarEndLineOperData;

typedef	struct T_NTadslNearEndLineOperData
{	unsigned short relCapacityOccupationDnstr;
    signed char noiseMarginDnstr;
    signed char outputPowerUpstr;
    unsigned char attenuationDnstr;
}T_NTadslNearEndLineOperData;

typedef	struct T_NTadslFarEndLineOperData
{	unsigned short relCapacityOccupationUpstr;
    signed char noiseMarginUpstr;
    signed char outputPowerDnstr;
    unsigned char attenuationUpstr;
    unsigned char carrierLoad[128];
}T_NTadslFarEndLineOperData;

typedef	struct T_adslChannelOperData
{	unsigned short actualBitrateNearInt;
    unsigned short actualBitrateNearFast;
    unsigned short actualBitrateFarInt;
    unsigned short actualBitrateFarFast;
}T_adslChannelOperData;

typedef	struct T_adsl_def_counters
{	unsigned short FecNotInterleaved;
    unsigned short FecInterleaved;
    unsigned short CrcNotInterleaved;
    unsigned short CrcInterleaved;
    unsigned short HecNotInterleaved;
    unsigned short HecInterleaved;
} T_adsl_def_counters;

typedef	struct T_adsl_def_counter_set
{	T_adsl_def_counters near_end;
    T_adsl_def_counters far_end;
}T_adsl_def_counter_set;

typedef	struct T_adsl_def_bitmaps
{	unsigned char status;
    unsigned char change;
}T_adsl_def_bitmaps;

typedef	struct T_adsl_def_bitmap_set
{	T_adsl_def_bitmaps near_end;
    T_adsl_def_bitmaps far_end;
}T_adsl_def_bitmap_set;

typedef	struct T_BERdata
{	unsigned short AccumulatedBer;
    unsigned int NsecValidBer;
    unsigned int NsecInvalidBer;
}T_BERdata;

typedef	struct T_BERdata_set
{	T_BERdata berFast;
    T_BERdata berInterleaved;
}T_BERdata_set;

typedef	enum T_RAMode
{	OPERATOR,
    AUTOMATIC,
    DYNAMIC
} T_RAMode;

typedef	struct T_adsl_ConfigurationData
{	unsigned char	MinNoiseMarginDnstr;
    unsigned char	MinNoiseMarginUpstr;
    unsigned char	MaxAddNoiseMarginDnstr;
    unsigned char	MaxAddNoiseMarginUpstr;
    unsigned char	TargetNoiseMarginDnstr;
    unsigned char	TargetNoiseMarginUpstr;
    signed char	MaxPSDDnstr;
    unsigned char	MaxAggrPwrLvlDnstr;
    unsigned char	MaxAggrPwrLvlUpstr;
    unsigned char	CarrierMask[32];
    T_RAMode		RAModeDnstr;
    T_RAMode		RAModeUpstr;
    unsigned char	RARatioDnstr;
    unsigned char	RARatioUpstr;
    unsigned char	RADownshiftMarginDnstr;
    unsigned char	RADownshiftMarginUpstr;
    unsigned char	RAUpshiftMarginDnstr;
    unsigned char	RAUpshiftMarginUpstr;
    unsigned char	RADownshiftIntervalDnstr;
    unsigned char	RADownshiftIntervalUpstr;
    unsigned short	RAUpshiftIntervalDnstr;
    unsigned short	RAUpshiftIntervalUpstr;
    unsigned short	InterlMinBitrateDnstr;
    unsigned short	InterlMinBitrateUpstr;
    unsigned short	InterlPlannedBitrateDnstr;
    unsigned short	InterlPlannedBitrateUpstr;
    unsigned short	InterlMaxBitrateDnstr;
    unsigned short	InterlMaxBitrateUpstr;
    unsigned char	InterlMaxDelayDnstr;
    unsigned char	InterlMaxDelayUpstr;
    unsigned short	FastMinBitrateDnstr;
    unsigned short	FastMinBitrateUpstr;
    unsigned short	FastPlannedBitrateDnstr;
    unsigned short	FastPlannedBitrateUpstr;
    unsigned short	FastMaxBitrateDnstr;
    unsigned short	FastMaxBitrateUpstr;
    unsigned char	UtopiaLevel;
    unsigned char	UtopiaAddrFast;
    unsigned char	UtopiaAddrInterl;
    unsigned char	FunctionCode1FD;
    unsigned char	ExtraFunctionCode1FC;
    unsigned char itu_vendorid_countrycode;
    unsigned char itu_vendorid_reserved;
    unsigned char itu_vendorid_vendorcode_1;
    unsigned char itu_vendorid_vendorcode_2;
    unsigned char itu_vendorid_vendorcode_3;
    unsigned char itu_vendorid_vendorcode_4;
    unsigned char itu_vendorid_vendorspecific_1;
    unsigned char itu_vendorid_vendorspecific_2;
}T_adsl_ConfigurationData;

typedef	struct T_GabaritInfo
{	signed int data[NUMBER_OF_TONES];
    double gablowvarlt[NUMBER_OF_TONES];
    double gablowvarnt[NUMBER_OF_TONES];
    double gabhighvarlt[NUMBER_OF_TONES];
    double gabhighvarnt[NUMBER_OF_TONES];
    double gablowtemp[NUMBER_OF_TONES];
    double gabhightemp[NUMBER_OF_TONES];
}T_GabaritInfo;

typedef	struct T_LogInfo
{	char data[NUMBER_OF_LOGWORDS*4];
}T_LogInfo;

typedef	struct T_ADSL_Requested_Info
{	unsigned char adsl_requested_info_0;
    unsigned char adsl_requested_info_1;
    unsigned char adsl_requested_info_2;
    unsigned char adsl_requested_info_3;
    unsigned char adsl_requested_info_4;
    unsigned char adsl_requested_info_5;
    unsigned char adsl_requested_info_6;
    unsigned char adsl_requested_info_7;
    unsigned char adsl_requested_info_8;
}T_ADSL_Requested_Info;


unsigned int ADSL_getVersion(unsigned int lineNum, T_swVersion* p_swVersion);
unsigned int ADSL_getVendorId(unsigned int lineNum, T_VendorId* p_VendorId);
unsigned int ADSL_get_controller_SWVersion(unsigned int lineNum, T_Controller_SW_version* p_ControllerSWVersion);

unsigned int LT_ADSL_get_NearEndLineOperData(unsigned int lineNum, T_LTadslNearEndLineOperData* p_OperData);
unsigned int LT_ADSL_get_FarEndLineOperData(unsigned int lineNum, T_LTadslFarEndLineOperData*	p_OperData);

unsigned int NT_ADSL_get_NearEndLineOperData(unsigned int lineNum, T_NTadslNearEndLineOperData* p_OperData);
unsigned int NT_ADSL_get_FarEndLineOperData(unsigned int lineNum, T_NTadslFarEndLineOperData*	p_OperData);

unsigned int ADSL_get_ChannelOperData(unsigned int lineNum, T_adslChannelOperData*p_Operdata);
unsigned int ADSL_def_counter_poll(unsigned int lineNum, T_adsl_def_counter_set*p_counter_set);
unsigned int ADSL_def_bitmap_poll(unsigned int lineNum, T_adsl_def_bitmap_set*p_bitmap_set);
unsigned int ADSL_get_BER_data(unsigned int lineNum, T_BERdata_set*p_ber_set);

unsigned int LT_ADSL_enableModemLine(unsigned int lineNum, T_adsl_ConfigurationData* configData);
unsigned int LT_ADSL_enableModemLine_glite(unsigned int lineNum, T_adsl_ConfigurationData* configData);
unsigned int LT_ADSL_enableModemLine_gdmt(unsigned int lineNum, T_adsl_ConfigurationData* configData);
unsigned int LT_ADSL_enableModemLine_multimode(unsigned int lineNum, T_adsl_ConfigurationData* configData);
unsigned int LT_ADSL_enableModemLine_ansi(unsigned int lineNum, T_adsl_ConfigurationData* configData);
unsigned int LT_ADSL_enableModemLine_loopback(unsigned int lineNum, T_adsl_ConfigurationData* configData);
unsigned int LT_ADSL_downloadModemConfig(unsigned int lineNum, T_adsl_ConfigurationData* configData);
unsigned int ADSL_disableModemLine(unsigned int lineNum);
unsigned int ADSL_disableModemLine_orderly_shutdown(unsigned int lineNum);
unsigned int NT_ADSL_dyingGasp(unsigned int lineNum);
unsigned int ADSL_SelfTest_Long(unsigned int lineNum);
unsigned int ADSL_SelfTest_Short(unsigned int lineNum);
unsigned int ADSL_sendDMTEngineInfoCommand(unsigned int lineNum);
unsigned int ADSL_getDMTEngineInfo(unsigned int lineNum, T_DMTEngineInfo*);
unsigned int ADSL_sendGabaritInfoCommand(unsigned int lineNum,unsigned int offset);
unsigned int ADSL_sendLogInfoCommand2(unsigned int lineNum,unsigned int offset, unsigned int	baseaddress);
unsigned int ADSL_getGabaritInfo(unsigned int lineNum, T_GabaritInfo*,unsigned int offset);
unsigned int ADSL_write_functionality_code_1FD(unsigned int lineNum, char ch);
unsigned int ADSL_sendLogInfoCommand(unsigned int lineNum,unsigned int offset);
unsigned int ADSL_getLogInfo(unsigned int lineNum,T_LogInfo*,unsigned int offset);
unsigned int ADSL_sendITUVendorIDInfoCommand(unsigned int lineNum, bool nearnotfar);
unsigned int ADSL_getITUVendorIDInfo(unsigned int lineNum, T_ADSL_Requested_Info* pinfo);
unsigned int ADSL_send_getoperationalmode_InfoCommand(unsigned int lineNum);
unsigned int ADSL_getoperationalmode_Info(unsigned int lineNum,T_ADSL_Requested_Info* pinfo);
unsigned int ADSL_getModemState(unsigned int lineNum,unsigned char *retStatus);
unsigned int ADSL_getRxCommand(unsigned int lineNum, char unsigned *rxCommand );
unsigned int ADSL_SelfTest_Long(unsigned int lineNum);
unsigned int ADSL_CloseLine(unsigned int lineNum);
unsigned int ADSL_SelfTest_SendTones(unsigned int lineNum);
unsigned char ADSL_setFunctionCode(unsigned int lineNum, unsigned char code);
#endif





