#ifndef GETS_ALLOC_H
#define GETS_ALLOC_H

#include <stdio.h>

#include <features.h>

#if defined(__cplusplus)
extern "C" {
#endif

/**
 * Like gets() except returns a dynamically sized buffer.
 * The buffer is reused on each invocation.
 *
 * If reading stops before EOF, call gets_alloc_done() to free any
 * memory allocated.
 *
 * Returns 0 at EOF.
 */
char *gets_alloc(FILE *f);

/**
 * Frees up any memory used by gets_alloc()
 */
void gets_alloc_done(void);

#if defined(__cplusplus)
}
#endif

#endif
