#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "config.h"

/*#define DEBUG*/

static void write_section(FILE *fh, config_section_t *s);
static void write_params(FILE *fh, config_param_t *params);
static void write_param(FILE *fh, config_param_t *p);

int config_write(const char *filename, config_t *conf)
{
	FILE *fh = fopen(filename, "w");
	if (fh == 0) {
		fprintf(stderr, "Failed to write to configuration file %s\n", filename);
		return(-1);
	}
	config_write_to_fh(fh, conf);

	fclose(fh);

	return(0);
}

void config_write_to_fh(FILE *fh, config_t *conf)
{
	config_section_t *q = conf->sections;

	while (q) {
		write_section(fh, q);
		fprintf(fh, "\n");
		q = q->next;
	}
}

static void write_section(FILE *fh, config_section_t *s)
{
	fprintf(fh, "%s %s\n", s->type, s->name);
	write_params(fh, s->vars);
}

static void write_params(FILE *fh, config_param_t *params)
{
	while (params) {
		write_param(fh, params);
		params = params->next;
	}
}

static void write_param(FILE *fh, config_param_t *p)
{
	/* If the value contains spaces or equals, quote it */
	if (strpbrk(p->value, " \t=")) {
		fprintf(fh, "\t%s = \"%s\"\n", p->name, p->value);
	}
	else {
		fprintf(fh, "\t%s = %s\n", p->name, p->value);
	}
}
