/* ld script to make ARM Linux kernel
 * taken from the i386 version by Russell King
 * Written by Martin Mares <mj@atrey.karlin.mff.cuni.cz>
 */
OUTPUT_ARCH(arm)
ENTRY(stext)
SECTIONS
{
	. = 0xc0008000;
	.init : {			/* Init code and data		*/
		_stext = .;
		__init_begin = .;
			*(.text.init)
		__proc_info_begin = .;
			*(.proc.info)
		__proc_info_end = .;
		__arch_info_begin = .;
			*(.arch.info)
		__arch_info_end = .;
		__tagtable_begin = .;
			*(.taglist)
		__tagtable_end = .;
			*(.data.init)
		. = ALIGN(16);
		__setup_start = .;
			*(.setup.init)
		__setup_end = .;
		__initcall_start = .;
			*(.initcall.init)
		__initcall_end = .;
		. = ALIGN(4096);
		__init_end = .;
	}

	/DISCARD/ : {			/* Exit code and data		*/
		*(.text.exit)
		*(.data.exit)
		*(.exitcall.exit)
	}

	.text : {			/* Real text segment		*/
		_text = .;		/* Text and read-only data	*/
			*(.text)
			*(.fixup)
			*(.gnu.warning)
			*(.rodata)
			*(.rodata.*)
			*(.glue_7)
			*(.glue_7t)
		*(.got)			/* Global offset table		*/

		_etext = .;		/* End of text section		*/
	}

	.kstrtab : { *(.kstrtab) }

	. = ALIGN(16);
	__ex_table : {			/* Exception table		*/
		__start___ex_table = .;
			*(__ex_table)
		__stop___ex_table = .;
	}

	__ksymtab : {			/* Kernel symbol table		*/
		__start___ksymtab = .;
			*(__ksymtab)
		__stop___ksymtab = .;
	}

	. = ALIGN(8192);

	.data : {
		/*
		 * first, the init task union, aligned
		 * to an 8192 byte boundary.
		 */
		*(.init.task)

		/*
		 * then the cacheline aligned data
		 */
		. = ALIGN(32);
		*(.data.cacheline_aligned)

		/*
		 * and the usual data section
		 */
		*(.data)
		CONSTRUCTORS

		_edata = .;
	}

	.bss : {
		__bss_start = .;	/* BSS				*/
		*(.bss)
		*(COMMON)
		_end = . ;
	}
					/* Stabs debugging sections.	*/
	.stab 0 : { *(.stab) }
	.stabstr 0 : { *(.stabstr) }
	.stab.excl 0 : { *(.stab.excl) }
	.stab.exclstr 0 : { *(.stab.exclstr) }
	.stab.index 0 : { *(.stab.index) }
	.stab.indexstr 0 : { *(.stab.indexstr) }
	.comment 0 : { *(.comment) }
}
