///////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2000 Intel Corporation 
// All rights reserved. 
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are met: 
//
// * Redistributions of source code must retain the above copyright notice, 
// this list of conditions and the following disclaimer. 
// * Redistributions in binary form must reproduce the above copyright notice, 
// this list of conditions and the following disclaimer in the documentation 
// and/or other materials provided with the distribution. 
// * Neither name of Intel Corporation nor the names of its contributors 
// may be used to endorse or promote products derived from this software 
// without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR 
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "upnp.h"
#include "PRO_file.h"

#define _DEBUG_
#define UPNP_MAXLEN	128
#define UPNP_PORT	6789
#define UPNP_XML_FN	"device.xml"
#define UPNP_WEB_PATH	"/home/httpd/html/"

typedef struct Upnp_Data{
	char device_type[UPNP_MAXLEN];		//<deviceType>
	char friendly_name[UPNP_MAXLEN];	//<friendlyName>
	char manufacturer[UPNP_MAXLEN]; 	//<manufacturer>
	char manufacturerURL[UPNP_MAXLEN];	//<manufacturerURL>
	char model_description[UPNP_MAXLEN];	//<modelDescription>
	char model_name[UPNP_MAXLEN];		//<modelName>
	char model_number[UPNP_MAXLEN];		//<modelNumber>
}Upnp_Data;


UpnpDevice_Handle device_handle=-1;

/* The amount of time before advertisements will expire */
int default_advr_expire=180;

void init(void)
{
	int pid;

	if ((pid = fork()) < 0) {
		printf("Program fork fail\n");
		exit(-1);
	} else if (pid != 0) {
		exit(0);	/* parent goes bye-bye */
	}
				/* child continues */
	setsid();		/* standard daemon procedure */
	chdir("/");
	close(0);
	close(1);
	close(2);
	umask(0);
}


int DsDeviceCallbackEventHandler(Upnp_EventType EventType, 
			 void *Event, 
			 void *Cookie)
{
    switch ( EventType) {

		case UPNP_EVENT_SUBSCRIPTION_REQUEST:
		case UPNP_CONTROL_GET_VAR_REQUEST:
		case UPNP_CONTROL_ACTION_REQUEST:
    
		case UPNP_DISCOVERY_ADVERTISEMENT_ALIVE:
		case UPNP_DISCOVERY_SEARCH_RESULT:
		case UPNP_DISCOVERY_SEARCH_TIMEOUT:
		case UPNP_DISCOVERY_ADVERTISEMENT_BYEBYE:
		case UPNP_CONTROL_ACTION_COMPLETE:
		case UPNP_CONTROL_GET_VAR_COMPLETE:
		case UPNP_EVENT_RECEIVED:
		case UPNP_EVENT_RENEWAL_COMPLETE:
		case UPNP_EVENT_SUBSCRIBE_COMPLETE:
		case UPNP_EVENT_UNSUBSCRIBE_COMPLETE:
			break;
		default:
			printf("Error in DsDeviceCallbackEventHandler: unknown event type %d\n", EventType);
    }
    return(0);
}

void IN_info(Upnp_Data *data)
{
	FILE *fp;
	char name[32]={0},version[12]={0};
        char model_name[UPNP_MAXLEN];

	fp=fopen("/etc/CGI_ds.conf","r");
	if(fp){
		PRO_GetStr("network","disk_server_name",name,sizeof(name)-1,fp);
		fclose(fp);
	}
	
	fp=fopen("/usr/local/CGI_ds.conf","r");
	if(fp){
		PRO_GetStr("network","version",version,sizeof(version)-1 ,fp);  
		PRO_GetStr("upnp","model_name",model_name,sizeof(model_name)-1,fp);
		PRO_GetStr("upnp","manuf",data->manufacturer,sizeof(data->manufacturer)-1,fp);
		PRO_GetStr("upnp","manuf_url",data->manufacturerURL,sizeof(data->manufacturerURL)-1,fp);
		PRO_GetStr("upnp","device_type",data->device_type,sizeof(data->device_type)-1,fp);		
		fclose(fp);
	}	
	sprintf(data->friendly_name,"%s",name);
	sprintf(data->model_description,"%s %s",model_name, version);
	sprintf(data->model_name,"%s", model_name);
	strcpy(data->model_number,version);
}


void generate_xml(Upnp_Data *data)
{
	FILE *fp;
	char ip_address[16]={0};
	char desc_doc_name[UPNP_MAXLEN];
	char pro_mac_add[20]={0};
	char mac_address[13]={0};
	char *service=" ";
	char port[8];

	fp=fopen("/etc/CGI_ds.conf","r");
	if(fp){
		PRO_GetStr("network","ip_addr",ip_address,16,fp);  
		PRO_GetStr("network","hw_addr",pro_mac_add,20,fp);
		PRO_GetStr("network","port",port,7,fp);
		fclose(fp);
	}
	mac_address[0]=pro_mac_add[0];
	mac_address[1]=pro_mac_add[1];
	mac_address[2]=pro_mac_add[3];
	mac_address[3]=pro_mac_add[4];
	mac_address[4]=pro_mac_add[6];
	mac_address[5]=pro_mac_add[7];
	mac_address[6]=pro_mac_add[9];
	mac_address[7]=pro_mac_add[10];
	mac_address[8]=pro_mac_add[12];
	mac_address[9]=pro_mac_add[13];
	mac_address[10]=pro_mac_add[15];
	mac_address[11]=pro_mac_add[16];
	mac_address[12]='\0';	

	sprintf(desc_doc_name,"%s/%s",UPNP_WEB_PATH,UPNP_XML_FN);

	if((fp=fopen(desc_doc_name,"w"))==NULL){
		perror("FOPEN FAILED");
		exit(-1);
	}
	else
	{
	// These are identical contents to every device 
	    fputs("<?xml version=\"1.0\"?>\n",fp);
	    fputs("<root xmlns=\"urn:schemas-upnp-org:device-1-0\">\n",fp);
	    fputs("<specVersion>\n\t<major>1</major>\n\t<minor>0</minor>\n</specVersion>\n",fp);
	    fprintf(fp,"<URLBase>http://%s:%d</URLBase>\n",ip_address,UPNP_PORT);
	    fputs("<device>\n",fp);
	    fprintf(fp,"<deviceType>urn:schemas-upnp-org:device:%s:1</deviceType>\n",data->device_type);
	    fprintf(fp,"<friendlyName>%s </friendlyName>\n",data->friendly_name);
	    fprintf(fp,"<manufacturer>%s </manufacturer>\n",data->manufacturer);
	    fprintf(fp,"<manufacturerURL>%s </manufacturerURL>\n",data->manufacturerURL);
	    fprintf(fp,"<modelDescription>%s </modelDescription>\n",data->model_description);
	    fprintf(fp,"<modelName>%s </modelName>\n",data->model_name);
	    fprintf(fp,"<modelNumber>%s </modelNumber>\n",data->model_number);
	    fprintf(fp,"<UDN>uuid:upnp-%s_%s-%s</UDN>\n",data->manufacturer,data->device_type,mac_address);  // here we use manufacturer_devicetype and mac_address as our UDN number
	    fprintf(fp,"<serviceList>\
		        <service>\t\
			    <serviceType>%s</serviceType>\t\
			    <serviceId>%s</serviceId>\t\t\
			    <controlURL>%s</controlURL>\t\t\
			    <eventSubURL>%s</eventSubURL>\t\t\
			    <SCPDURL>%s</SCPDURL>\t\
		        </service>\n</serviceList>\n",service,service,service,service,service);
	    fprintf(fp,"<presentationURL>http://%s:%s</presentationURL>",ip_address,port);
	    fputs("</device>\n</root>\n",fp);		
	}
	fclose(fp);
}


void sig_term(int sig)
{
#ifdef _DEBUG_	    
	printf("Shutting down on signal %d...\n", sig);
#endif	    
	UpnpUnRegisterRootDevice(device_handle);
#ifdef _DEBUG_	 
	printf("UpnpFinsh()\n");
#endif	
	UpnpFinish();
	remove("/var/run/upnpd.pid");
	exit(0);
}

int main(int argc, char** argv)
{
	FILE *fh;
	const long port=UPNP_PORT;
	const char *desc_doc_name="device.xml";
	const char *web_dir_path="/home/httpd/html/";
	int ret=1;
	char ip_address[16];
	char desc_doc_url[200];
	Upnp_Data com;
	struct sigaction act;	
	
//	init();				
	/* Construct the device description XML page*/
	IN_info(&com);
	generate_xml(&com);
	fh=fopen("/etc/CGI_ds.conf","r");
	if(fh){
		PRO_GetStr("network","ip_addr",ip_address,16,fh);  
		fclose(fh);
	}
	sprintf(desc_doc_url, "http://%s:%ld/%s", ip_address, port, desc_doc_name);
#ifdef _DEBUG_
	printf("Intializing UPnP \n\twith desc_doc_url=%s\n\t", desc_doc_url);
	printf("\t     ipaddress=%s port=%ld\n", ip_address, port);
	printf("\t     web_dir_path=%s\n", web_dir_path);
#endif
	if ((ret = UpnpInit(ip_address, port)) != UPNP_E_SUCCESS) {
		printf("Error with UpnpInit -- %d\n", ret);
		UpnpFinish();
		exit(1);
	}
#ifdef _DEBUG_	    
	printf("UPnP Initialized\n");
	printf("Specifying the webserver root directory -- %s\n", web_dir_path);
#endif
	if ((ret = UpnpSetWebServerRootDir(web_dir_path)) != UPNP_E_SUCCESS) {
		printf("Error specifying webserver root directory -- %s: %d\n", web_dir_path, ret);
		UpnpFinish();
		exit(1);
	}
#ifdef _DEBUG_	
	printf("Registering the RootDevice\n");
#endif	
	if ((ret = UpnpRegisterRootDevice(desc_doc_url, DsDeviceCallbackEventHandler, &device_handle, &device_handle)) != UPNP_E_SUCCESS) {
		printf("Error registering the rootdevice : %d\n", ret);
		UpnpFinish();
		exit(1);
	}
	else {
#ifdef _DEBUG_		
		printf("RootDevice Registered\n");
#endif		
		if ((ret = UpnpSendAdvertisement(device_handle, default_advr_expire)) != UPNP_E_SUCCESS) {
#ifdef _DEBUG_
			printf("Error sending advertisements : %d\n", ret);
#endif			
			UpnpFinish();
			exit(1);
		}	
#ifdef _DEBUG_		
		printf("Advertisements Sent\n");
#endif		
}

	fh=fopen("/var/run/upnpd.pid", "wt");
	if(!fh){
		UpnpFinish();
		exit(1);
	}
	fprintf(fh,"%d",getpid());
	fclose(fh);	
#if 0
	sigemptyset(&sigs_to_catch);
	sigaddset(&sigs_to_catch, SIGINT);
	sigaddset(&sigs_to_catch, SIGTERM);
	sigwait(&sigs_to_catch, &sig);
#else	
		act.sa_handler=sig_term;
		sigemptyset(&act.sa_mask);
		act.sa_flags=0;
		sigaction(SIGINT, &act, NULL);	
		
		act.sa_handler=sig_term;
		sigemptyset(&act.sa_mask);
		act.sa_flags=0;
		sigaction(SIGTERM, &act, NULL);			
#endif
            pause();	
	exit(0);
}




