#include <sys/types.h>		/* open, umask */
#include <sys/stat.h>		/* open, umask */
#include <sys/ioctl.h>
#include <fcntl.h>		/* open */
#include <unistd.h>		/* read, setsid, chdir */
#include <string.h>		/* memset */
#include <stdio.h>		/* printf */
#include <stdlib.h>		/* system */


#include "IXCryptoAction.h"








int CRYPTO_DES_ECB(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *DES_KEY,
		      int enc)
{
  int fd;
  int len;

  CryptoSSLServiceParam * PTemp;
 
  CryptoSSLServiceParam Temp;
  PTemp=&Temp;
  PTemp->cipherAlgo=CRYPTO_ACC_CIPHER_DES;
  PTemp->cipherMode=CRYPTO_ACC_MODE_ECB;
  PTemp->cipherKeyLen=CRYPTO_ACC_DES_KEY_64;
  PTemp->cipherBlockLen=CRYPTO_ACC_DES_BLOCK_64;
  PTemp->cipherInitialVectorLen=0;
  PTemp->authAlgo=CRYPTO_ACC_AUTH_NULL;
  PTemp->authKeyLen=0;
  PTemp->authDigestLen=0;
  PTemp->useDifferentSrcAndDestMbufs=FALSE;
  if(enc){
     PTemp->frwdOperation=CRYPTO_ACC_OP_ENCRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_DECRYPT;
   }
   else{
     PTemp->frwdOperation=CRYPTO_ACC_OP_DECRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_ENCRYPT;
   }  
   PTemp->cipherKey=DES_KEY;
   PTemp->IV=NULL;
   PTemp->data=(unsigned char*)input;
   PTemp->bufferlen=length;         
     
  fd=open(DEV_CRYPTOSSL,O_RDWR);
  if(fd!=-1){
   len=write(fd,PTemp,sizeof(CryptoSSLServiceParam));

    close(fd);
    return 1;
  }
  return 0;
} 
               
int CRYPTO_DES_CBC(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *DES_KEY,DES_cblock *ivec,
		      int enc)
{
  int fd;
  int len;
  
  CryptoSSLServiceParam * PTemp;
  
  CryptoSSLServiceParam Temp;
   
  DES_cblock iv;
  
   if(!enc)
      memcpy(&iv,&input[length-sizeof(DES_cblock)],sizeof(DES_cblock));
  PTemp=&Temp;
  PTemp->cipherAlgo=CRYPTO_ACC_CIPHER_DES;
  PTemp->cipherMode=CRYPTO_ACC_MODE_CBC;
  PTemp->cipherKeyLen=CRYPTO_ACC_DES_KEY_64;
  PTemp->cipherBlockLen=CRYPTO_ACC_DES_BLOCK_64;
  PTemp->cipherInitialVectorLen=CRYPTO_ACC_DES_IV_64;
  PTemp->authAlgo=CRYPTO_ACC_AUTH_NULL;
  PTemp->authKeyLen=0;
  PTemp->authDigestLen=0;
  PTemp->useDifferentSrcAndDestMbufs=FALSE;
  if(enc){
     PTemp->frwdOperation=CRYPTO_ACC_OP_ENCRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_DECRYPT;
   }
   else{
     PTemp->frwdOperation=CRYPTO_ACC_OP_DECRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_ENCRYPT;
   }  
   PTemp->cipherKey=DES_KEY;
   PTemp->IV=(unsigned char*)ivec;
   PTemp->data=(unsigned char*)input;
   PTemp->bufferlen=length;     
     
  fd=open(DEV_CRYPTOSSL,O_RDWR);
  if(fd!=-1){
    len=write(fd,PTemp,sizeof(CryptoSSLServiceParam));
  if(enc)
      memcpy(ivec,&output[length-sizeof(DES_cblock)],sizeof(DES_cblock)); 
  else
      memcpy(ivec,&iv,sizeof(DES_cblock));
    close(fd);
    return 1;
  }
  return 0;
}             
   
   
int CRYPTO_3DES_ECB(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *DES_KEY,
		      int enc)
{
  int fd;
  int len;
 
  CryptoSSLServiceParam * PTemp;
  
  CryptoSSLServiceParam Temp;
  PTemp=&Temp;
  PTemp->cipherAlgo=CRYPTO_ACC_CIPHER_3DES;
  PTemp->cipherMode=CRYPTO_ACC_MODE_ECB;
  PTemp->cipherKeyLen=CRYPTO_ACC_3DES_KEY_192;
  PTemp->cipherBlockLen=CRYPTO_ACC_DES_BLOCK_64;
  PTemp->cipherInitialVectorLen=0;
  PTemp->authAlgo=CRYPTO_ACC_AUTH_NULL;
  PTemp->authKeyLen=0;
  PTemp->authDigestLen=0;
  PTemp->useDifferentSrcAndDestMbufs=FALSE;
  if(enc){
     PTemp->frwdOperation=CRYPTO_ACC_OP_ENCRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_DECRYPT;
   }
   else{
     PTemp->frwdOperation=CRYPTO_ACC_OP_DECRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_ENCRYPT;
   }  
   PTemp->cipherKey=DES_KEY;
   PTemp->IV=NULL;
   PTemp->data=(unsigned char*)input;
   PTemp->bufferlen=length;

     
     
  fd=open(DEV_CRYPTOSSL,O_RDWR);
  if(fd!=-1){
    len=write(fd,PTemp,sizeof(CryptoSSLServiceParam));
   close(fd);
   return 1;
  }
  return 0;
}                 
int CRYPTO_3DES_CBC(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *DES_KEY,DES_cblock *ivec,
		      int enc)
{
  int fd;
  int len;
 
  CryptoSSLServiceParam * PTemp;
 
  CryptoSSLServiceParam Temp;

  DES_cblock iv;
  
   if(!enc)
      memcpy(&iv,&input[length-sizeof(DES_cblock)],sizeof(DES_cblock));
    
  
  PTemp=&Temp;
  PTemp->cipherAlgo=CRYPTO_ACC_CIPHER_3DES;
  PTemp->cipherMode=CRYPTO_ACC_MODE_CBC;
  PTemp->cipherKeyLen=CRYPTO_ACC_3DES_KEY_192;
  PTemp->cipherBlockLen=CRYPTO_ACC_DES_BLOCK_64;
  PTemp->cipherInitialVectorLen=CRYPTO_ACC_DES_IV_64;
  PTemp->authAlgo=CRYPTO_ACC_AUTH_NULL;
  PTemp->authKeyLen=0;
  PTemp->authDigestLen=0;
  PTemp->useDifferentSrcAndDestMbufs=FALSE;
  if(enc){
     PTemp->frwdOperation=CRYPTO_ACC_OP_ENCRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_DECRYPT;
   }
   else{
     PTemp->frwdOperation=CRYPTO_ACC_OP_DECRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_ENCRYPT;
   }  
   PTemp->cipherKey=DES_KEY;
   PTemp->IV=(unsigned char*)ivec;
   PTemp->data=(unsigned char*)input;
   PTemp->bufferlen=length;
	
     

  fd=open(DEV_CRYPTOSSL,O_RDWR);

  if(fd!=-1){
    len=write(fd,PTemp,sizeof(CryptoSSLServiceParam));
   if(enc)
      memcpy(ivec,&output[length-sizeof(DES_cblock)],sizeof(DES_cblock)); 
   else
      memcpy(ivec,&iv,8);
    close(fd);
    return 1;
  }
  return 0;
}             
   


int CRYPTO_AES128_ECB(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *AES_KEY,
		      int enc)
{
  int fd;
  int len;
 
  CryptoSSLServiceParam * PTemp;
 
  CryptoSSLServiceParam Temp;
  PTemp=&Temp;
  PTemp->cipherAlgo=CRYPTO_ACC_CIPHER_AES;
  PTemp->cipherMode=CRYPTO_ACC_MODE_ECB;
  PTemp->cipherKeyLen=CRYPTO_ACC_AES_KEY_128;
  PTemp->cipherBlockLen=CRYPTO_ACC_AES_BLOCK_128;
  PTemp->cipherInitialVectorLen=0;
  PTemp->authAlgo=CRYPTO_ACC_AUTH_NULL;
  PTemp->authKeyLen=0;
  PTemp->authDigestLen=0;
  PTemp->useDifferentSrcAndDestMbufs=FALSE;
  if(enc){
     PTemp->frwdOperation=CRYPTO_ACC_OP_ENCRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_DECRYPT;
   }
   else{
     PTemp->frwdOperation=CRYPTO_ACC_OP_DECRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_ENCRYPT;
   }  
   PTemp->cipherKey=AES_KEY;
   PTemp->IV=NULL;
   PTemp->data=(unsigned char*)input;
   PTemp->bufferlen=length;  
           
     
  fd=open(DEV_CRYPTOSSL,O_RDWR);
  if(fd!=-1){
   len=write(fd,PTemp,sizeof(CryptoSSLServiceParam));
    close(fd);
    return 1;
  }
  return 0;
}               		      
		      
int CRYPTO_AES128_CBC(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *AES_KEY,unsigned char *ivec,
		      int enc)
{
  int fd;
  int len;
  
  CryptoSSLServiceParam * PTemp;
  
  CryptoSSLServiceParam Temp;

  unsigned char iv[16];
  
   if(!enc)
      memcpy(iv,&input[length-16],16);
  PTemp=&Temp;
  PTemp->cipherAlgo=CRYPTO_ACC_CIPHER_AES;
  PTemp->cipherMode=CRYPTO_ACC_MODE_CBC;
  PTemp->cipherKeyLen=CRYPTO_ACC_AES_KEY_192;
  PTemp->cipherBlockLen=CRYPTO_ACC_AES_BLOCK_128;
  PTemp->cipherInitialVectorLen=CRYPTO_ACC_AES_CBC_IV_128;
  PTemp->authAlgo=CRYPTO_ACC_AUTH_NULL;
  PTemp->authKeyLen=0;
  PTemp->authDigestLen=0;
  PTemp->useDifferentSrcAndDestMbufs=FALSE;
  if(enc){
     PTemp->frwdOperation=CRYPTO_ACC_OP_ENCRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_DECRYPT;
   }
   else{
     PTemp->frwdOperation=CRYPTO_ACC_OP_DECRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_ENCRYPT;
   }  
   PTemp->cipherKey=AES_KEY;
   PTemp->IV=(unsigned char*)ivec;
   PTemp->data=(unsigned char*)input;
   PTemp->bufferlen=length;     
     
  fd=open(DEV_CRYPTOSSL,O_RDWR);
  if(fd!=-1){
   len=write(fd,PTemp,sizeof(CryptoSSLServiceParam));
   if(enc)
      memcpy(ivec,&output[length-16],16); 
   else
      memcpy(ivec,iv,16);   
   
    
    close(fd);
    return 1;
  }
  return 0;
}             		      
int CRYPTO_AES192_ECB(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *AES_KEY,
		      int enc)
{
  int fd;
  int len;
 
  CryptoSSLServiceParam * PTemp;
 
  CryptoSSLServiceParam Temp;
  PTemp=&Temp;
  PTemp->cipherAlgo=CRYPTO_ACC_CIPHER_AES;
  PTemp->cipherMode=CRYPTO_ACC_MODE_ECB;
  PTemp->cipherKeyLen=CRYPTO_ACC_AES_KEY_192;
  PTemp->cipherBlockLen=CRYPTO_ACC_AES_BLOCK_128;
  PTemp->cipherInitialVectorLen=0;
  PTemp->authAlgo=CRYPTO_ACC_AUTH_NULL;
  PTemp->authKeyLen=0;
  PTemp->authDigestLen=0;
  PTemp->useDifferentSrcAndDestMbufs=FALSE;
  if(enc){
     PTemp->frwdOperation=CRYPTO_ACC_OP_ENCRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_DECRYPT;
   }
   else{
     PTemp->frwdOperation=CRYPTO_ACC_OP_DECRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_ENCRYPT;
   }  
   PTemp->cipherKey=AES_KEY;
   PTemp->IV=NULL;
   PTemp->data=(unsigned char*)input;
   PTemp->bufferlen=length;             
     
  fd=open(DEV_CRYPTOSSL,O_RDWR);
  if(fd!=-1){
   len=write(fd,PTemp,sizeof(CryptoSSLServiceParam));
    close(fd);
    return 1;
  }
  return 0;
}             		      
int CRYPTO_AES192_CBC(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *AES_KEY,unsigned char *ivec,
		      int enc)
{
  int fd;
  int len;
  
  CryptoSSLServiceParam * PTemp;
 
  CryptoSSLServiceParam Temp;

  unsigned char iv[16];
  
   if(!enc)
      memcpy(iv,&input[length-16],16);
  PTemp=&Temp;
  PTemp->cipherAlgo=CRYPTO_ACC_CIPHER_AES;
  PTemp->cipherMode=CRYPTO_ACC_MODE_CBC;
  PTemp->cipherKeyLen=CRYPTO_ACC_AES_KEY_192;
  PTemp->cipherBlockLen=CRYPTO_ACC_AES_BLOCK_128;
  PTemp->cipherInitialVectorLen=CRYPTO_ACC_AES_CBC_IV_128;
  PTemp->authAlgo=CRYPTO_ACC_AUTH_NULL;
  PTemp->authKeyLen=0;
  PTemp->authDigestLen=0;
  PTemp->useDifferentSrcAndDestMbufs=FALSE;
  if(enc){
     PTemp->frwdOperation=CRYPTO_ACC_OP_ENCRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_DECRYPT;
   }
   else{
     PTemp->frwdOperation=CRYPTO_ACC_OP_DECRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_ENCRYPT;
   }  
   PTemp->cipherKey=AES_KEY;
   PTemp->IV=(unsigned char*)ivec;
   PTemp->data=(unsigned char*)input;
   PTemp->bufferlen=length;          
     
  fd=open(DEV_CRYPTOSSL,O_RDWR);
  if(fd!=-1){
      len=write(fd,PTemp,sizeof(CryptoSSLServiceParam));
   if(enc)
      memcpy(ivec,&output[length-16],16); 
   else
      memcpy(ivec,iv,16);     
    
     
    close(fd);
    return 1;
  }
  return 0;
}             		      
int CRYPTO_AES256_ECB(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *AES_KEY,
		      int enc)
{
  int fd;
  int len;
  
  CryptoSSLServiceParam * PTemp;
  
  CryptoSSLServiceParam Temp;
  PTemp=&Temp;
  PTemp->cipherAlgo=CRYPTO_ACC_CIPHER_AES;
  PTemp->cipherMode=CRYPTO_ACC_MODE_ECB;
  PTemp->cipherKeyLen=CRYPTO_ACC_AES_KEY_256;
  PTemp->cipherBlockLen=CRYPTO_ACC_AES_BLOCK_128;
  PTemp->cipherInitialVectorLen=0;
  PTemp->authAlgo=CRYPTO_ACC_AUTH_NULL;
  PTemp->authKeyLen=0;
  PTemp->authDigestLen=0;
  PTemp->useDifferentSrcAndDestMbufs=FALSE;
  if(enc){
     PTemp->frwdOperation=CRYPTO_ACC_OP_ENCRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_DECRYPT;
   }
   else{
     PTemp->frwdOperation=CRYPTO_ACC_OP_DECRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_ENCRYPT;
   }  
   PTemp->cipherKey=AES_KEY;
   PTemp->IV=NULL;
   PTemp->data=(unsigned char*)input;
   PTemp->bufferlen=length;          
     
  fd=open(DEV_CRYPTOSSL,O_RDWR);
  if(fd!=-1){
    len=write(fd,PTemp,sizeof(CryptoSSLServiceParam));
    close(fd);
    return 1;
  }
  return 0;
}             
    		      
int CRYPTO_AES256_CBC(const unsigned char *input,unsigned char *output,
		      long length,unsigned char *AES_KEY,unsigned char *ivec,
		      int enc)
{
  int fd;
  int len;
  
  CryptoSSLServiceParam * PTemp;
  
  CryptoSSLServiceParam Temp;
  
  unsigned char iv[16];
  
   if(!enc)
      memcpy(iv,&input[length-16],16);
  PTemp=&Temp;
  PTemp->cipherAlgo=CRYPTO_ACC_CIPHER_3DES;
  PTemp->cipherMode=CRYPTO_ACC_MODE_CBC;
  PTemp->cipherKeyLen=CRYPTO_ACC_AES_KEY_256;
  PTemp->cipherBlockLen=CRYPTO_ACC_AES_BLOCK_128;
  PTemp->cipherInitialVectorLen=CRYPTO_ACC_AES_CBC_IV_128;
  PTemp->authAlgo=CRYPTO_ACC_AUTH_NULL;
  PTemp->authKeyLen=0;
  PTemp->authDigestLen=0;
  PTemp->useDifferentSrcAndDestMbufs=FALSE;
  if(enc){
     PTemp->frwdOperation=CRYPTO_ACC_OP_ENCRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_DECRYPT;
   }
   else{
     PTemp->frwdOperation=CRYPTO_ACC_OP_DECRYPT;
     PTemp->revOperation=CRYPTO_ACC_OP_ENCRYPT;
   }  
   PTemp->cipherKey=AES_KEY;
   PTemp->IV=(unsigned char*)ivec;
   PTemp->data=(unsigned char*)input;
   PTemp->bufferlen=length;           
     
  fd=open(DEV_CRYPTOSSL,O_RDWR);
  if(fd!=-1){
   len=write(fd,PTemp,sizeof(CryptoSSLServiceParam));
   if(enc)
      memcpy(ivec,&output[length-16],16); 
   else
      memcpy(ivec,iv,16);     
    close(fd);
    return 1;
  }
  return 0;
}             		      


