/**
 * @file IxHssAccPktTx_p.h
 *
 * @author Intel Corporation
 * @date  14 Dec 2001
 *
 * @brief This file contains the private API of the HSS Packetised Tx  module
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2001-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
*/
/**
 * @defgroup IxHssAccPktTx_p IxHssAccPktTx_p
 *
 * @brief IXP425 HSS Access Packet Tx Module
 * 
 * @{
 */

#include "IxQMgr.h"
#include "IxHssAcc.h"
#include "IxOsBuffMgt.h"

#ifndef IXHSSACCPKTTX_P_H
#define IXHSSACCPKTTX_P_H 


/**
 * Prototypes for interface functions.
 */

/**
 * @fn IX_STATUS ixHssAccPktTxInternal (IxHssAccHssPort hssPortId,
                                        IxHssAccHdlcPort hdlcPortId,
					IX_MBUF *buffer)
 *
 * @brief This function is the transmit function which is called by the client.
 * The buffer is attached to a descriptor and placed on the Tx QMQ
 *
 * @param IxHssAccHssPort hssPortId (in) -  The HSS port number on which the
 *  calling client is operating on i.e.(0-1)
 * @param IxHssAccHdlcPort hdlcPortId (in) - The HDLC port number on which 
 * the calling client is operating on i.e. 1, 2, 3 or 4.
 * @param IX_MBUF *buffer (in) - This is the client supplied buffer which holds 
 * the data the client wants to transmit, it is attached to the Packetised 
 * Descriptor and placed on the Tx QMQ
 *
 * @return 
 *         - IX_SUCCESS The function executed successfully
 *         - IX_FAIL The function did not execute successfully
 *         - IX_HSSACC_RESOURCE_ERR The function did not execute successfully due
 *                          to a resource error
 * 
 */
IX_STATUS 
ixHssAccPktTxInternal (IxHssAccHssPort hssPortId, 
		       IxHssAccHdlcPort hdlcPortId,
		       IX_MBUF *buffer);

/**
 * @fn void ixHssAccPktTxDoneCallback (IxQMgrQId qId, 
                                       IxQMgrCallbackId cbId);
 *
 * @brief This function is called by the TxDone QMQ interrupt 
 * (Callback Mechaninsm)
 *
 * @param IxQMgrQId qId (in) -  The IxQMQ Queue Id, this is the ID number 
 * of the queue
 * @param IxQMgrCallbackId cbId  (in) - The IxQMQ callback ID
 * not to call this callback again in the same context.
 * @return void
 */
void 
ixHssAccPktTxDoneCallback (IxQMgrQId qId, 
			   IxQMgrCallbackId cbId);


/**
 * @fn  void ixHssAccPktTxShow (void)
 *
 * @brief This function is called by to display the stats in the Tx Module
 *
 * @return void
 */
void 
ixHssAccPktTxShow (void);


/**
 * @fn void ixHssAccPktTxStatsInit (void)
 *
 * @brief This function is called by to initialise the stats in the Tx Module
 *
 * @return void
 */
void 
ixHssAccPktTxStatsInit (void);

/**
 * @fn IX_STATUS ixHssAccPktTxInit (void)
 *
 * @brief This function will initialise the PktTx module
 *
 * @return 
 *           - IX_SUCCESS Function executed successfully
 *           - IX_FAIL Function failed to execute
 */
IX_STATUS 
ixHssAccPktTxInit (void);

#endif /* IXHSSACCPKTTX_P_H */

/**
 * @} defgroup  IxHssAccPktTx_p
 */
