/**
 * @file IxEthAccCommon.c
 *
 * @author Intel Corporation
 * @date 12-Feb-2002
 *
 * @brief This file contains the implementation common support routines for the component
 *
 * Design Notes:
 *
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 */

/* 
 * Component header files 
 */
#include <stdio.h>

#include <IxEthAcc.h>
#include <IxEthAcc_p.h>
#include <IxEthAccQueueAssign_p.h>

#include "IxEthAccDataPlane_p.h"
#include "IxEthAccMii_p.h"

/* 
 * Other components.
 */
#include <IxFeatureCtrl.h>

/* 
 * ANSI headers
 */
#include <string.h>

/**
 * @addtogroup IxEthAccPri
 *@{
 */

BOOL ixEthAccServiceInit=FALSE;

/**
 *
 * @brief Data structure used to register & initialize the QMgr callbacks.
 *
 */
IX_ETH_ACC_PRIVATE
ixEthAccQregInfo ixEthAccQmgrInfo[]=
{

  { 
    IX_ETH_ACC_RX_FRAME_ETH_Q, 	     /**< Queue ID */
    "Eth Rx Q", 
    ixEthRxFrameQMCallback,          /**< Functional callback */
    (IxQMgrCallbackId) 0,	     /**< Callback tag	      */ 
    IX_QMGR_Q_SIZE128,		     /**< Allocate Max Size Q */
    IX_QMGR_Q_ENTRY_SIZE1,	     /** Queue Entry Sizes - all Q entries are single ord entries   */
    TRUE,			     /** Enable Q notification at startup */
    IX_ETH_ACC_RX_FRAME_ETH_Q_SOURCE, /** Q Condition to drive callback   */
    IX_QMGR_Q_WM_LEVEL0, 	     /* No queues use almost empty */
    IX_QMGR_Q_WM_LEVEL1,	     /** Q High water mark - needed by NPE */
    
  },


  { 
    IX_ETH_ACC_RX_FREE_BUFF_ENET0_Q, 
    "Eth Rx Fr Q 1", 
    ixEthRxFreeQMCallback,      
    (IxQMgrCallbackId) IX_ETH_PORT_1,
    IX_QMGR_Q_SIZE128,		     /**< Allocate Max Size Q */
    IX_QMGR_Q_ENTRY_SIZE1,	     /** Queue Entry Sizes - all Q entries are single ord entries   */
    FALSE,			     /** Disable Q notification at startup */
    IX_ETH_ACC_RX_FREE_BUFF_ENET0_Q_SOURCE,	     /** Q Condition to drive callback  */
    IX_QMGR_Q_WM_LEVEL0, 	     /* No queues use almost empty */
    IX_QMGR_Q_WM_LEVEL64,	      /** Q High water mark - needed used  */
  },

  { 
    IX_ETH_ACC_RX_FREE_BUFF_ENET1_Q, 
    "Eth Rx Fr Q 2", 
    ixEthRxFreeQMCallback,      
    (IxQMgrCallbackId) IX_ETH_PORT_2,
    IX_QMGR_Q_SIZE128,		     /**< Allocate Max Size Q */
    IX_QMGR_Q_ENTRY_SIZE1,	     /** Queue Entry Sizes - all Q entries are single ord entries   */
    FALSE,			     /** Disable Q notification at startup */
    IX_ETH_ACC_RX_FREE_BUFF_ENET1_Q_SOURCE,	     /** Q Condition to drive callback  */
    IX_QMGR_Q_WM_LEVEL0, 	     /* No queues use almost empty */
    IX_QMGR_Q_WM_LEVEL64,	      /** Q High water mark - needed used  */
  },

  { 
     IX_ETH_ACC_TX_FRAME_ENET0_Q,     
    "Eth Tx Q 1", 
     ixEthTxFrameQMCallback,     
     (IxQMgrCallbackId) IX_ETH_PORT_1,
    IX_QMGR_Q_SIZE128,		     /**< Allocate Max Size Q */
    IX_QMGR_Q_ENTRY_SIZE1,	     /** Queue Entry Sizes - all Q entries are single ord entries   */
    FALSE,			     /** Disable Q notification at startup */
    IX_ETH_ACC_TX_FRAME_ENET0_Q_SOURCE,	     /** Q Condition to drive callback  */
    IX_QMGR_Q_WM_LEVEL0, 	     /* No queues use almost empty */
    IX_QMGR_Q_WM_LEVEL64,	      /** Q High water mark - needed used  */
  },

  { 
     IX_ETH_ACC_TX_FRAME_ENET1_Q,     
    "Eth Tx Q 2", 
     ixEthTxFrameQMCallback,     
     (IxQMgrCallbackId) IX_ETH_PORT_2,
    IX_QMGR_Q_SIZE128,		     /**< Allocate Max Size Q */
    IX_QMGR_Q_ENTRY_SIZE1,	     /** Queue Entry Sizes - all Q entries are single ord entries   */
    FALSE,			     /** Disable Q notification at startup */
    IX_ETH_ACC_TX_FRAME_ENET1_Q_SOURCE,	     /** Q Condition to drive callback  */
    IX_QMGR_Q_WM_LEVEL0, 	     /* No queues use almost empty */
    IX_QMGR_Q_WM_LEVEL64,	      /** Q High water mark - needed used  */
  },


  { 
     IX_ETH_ACC_TX_FRAME_DONE_ETH_Q,  
    "Eth Tx Done Q", 
     ixEthTxFrameDoneQMCallback, 
     (IxQMgrCallbackId) 0,
    IX_QMGR_Q_SIZE128,		     /**< Allocate Max Size Q */
    IX_QMGR_Q_ENTRY_SIZE1,	     /** Queue Entry Sizes - all Q entries are single ord entries   */
    TRUE,			     /** Enable Q notification at startup */
    IX_ETH_ACC_TX_FRAME_DONE_ETH_Q_SOURCE,	 /** Q Condition to drive callback  */
    IX_QMGR_Q_WM_LEVEL0, 	     /* No queues use almost empty */
    IX_QMGR_Q_WM_LEVEL1,	      /** Q High water mark - needed by NPE */
  },

  {  /* Null Termination entry */
     (IxQMgrQId) NULL,		     
     (char *) NULL,
     (IxQMgrCallback) NULL,	 
     (IxQMgrCallbackId) 0,
     0,
     0,
     0,
     0,
     0,
     0
  } 

};



/**
 * @fn ixEthAccRegisterQMgrCallbacks(void)
 *
 * @brief Register all callbacks required by this component to the QMgr
 *
 * @param none
 *
 * @return IxEthAccStatus
 *
 * @internal
 */
IX_ETH_ACC_PUBLIC
IxEthAccStatus ixEthAccRegisterQMgrCallbacks(void)
{

  IxEthAccStatus ret=IX_ETH_ACC_SUCCESS;

  ixEthAccQregInfo *qInfoDes = &ixEthAccQmgrInfo[0];

  while ( (qInfoDes->qCallback != (IxQMgrCallback) NULL ) && ret == IX_ETH_ACC_SUCCESS)
  {

    /*
     * Configure each Q.
     */
    if ( ixQMgrQConfig( qInfoDes->qName,
			qInfoDes->qId,
			qInfoDes->qSize,
			qInfoDes->qWords) != IX_SUCCESS)
    {
	ret = IX_ETH_ACC_FAIL;
	break;
    }

    if ( ixQMgrWatermarkSet( qInfoDes->qId,
			     qInfoDes->AlmostEmptyThreshold,
			     qInfoDes->AlmostFullThreshold
			     ) != IX_SUCCESS)
    {
	ret = IX_ETH_ACC_FAIL;
	break;
    }
    /* 
     * Set dispatcher priority. 
     */
    if ( ixQMgrDispatcherPrioritySet( qInfoDes->qId, IX_ETH_ACC_QM_QUEUE_DISPATCH_PRIORITY) != IX_SUCCESS)
    {
	ret = IX_ETH_ACC_FAIL;
	break;
    }
   
    /*
     * Register callbacks for each Q.
     */ 
    if (   ixQMgrNotificationCallbackSet(qInfoDes->qId,
				      qInfoDes->qCallback,
				      qInfoDes->callbackTag) != IX_SUCCESS )
    {
	ret = IX_ETH_ACC_FAIL;
	break;
    }

    /*
     * Set notification condition for Q
     */  
    if ( qInfoDes->qNotificationEnableAtStartup == TRUE ) 
    {
      if (   ixQMgrNotificationEnable(qInfoDes->qId,
                                    qInfoDes->qConditionSource) != IX_SUCCESS )
      {
        ret = IX_ETH_ACC_FAIL;
        break;
      }
    }
 
    ++qInfoDes;

  }

  return(ret);
}

IX_ETH_ACC_PUBLIC
IxEthAccStatus ixEthAccSingleEthNpeCheck(IxEthAccPortId portId)
{
    if ((ixFeatureCtrlProductIdRead() & IX_FEATURE_CTRL_SILICON_STEPPING_MASK) == 
         IX_FEATURE_CTRL_SILICON_TYPE_B0) 
    {  
        if ((IX_ETH_PORT_1 == portId) && 
            (ixFeatureCtrlComponentCheck(IX_FEATURECTRL_ETH0) ==
             IX_FEATURE_CTRL_COMPONENT_DISABLED))
        {
	    return IX_ETH_ACC_FAIL;
        }

        if ((IX_ETH_PORT_2 == portId) &&
            (ixFeatureCtrlComponentCheck(IX_FEATURECTRL_ETH1) ==
             IX_FEATURE_CTRL_COMPONENT_DISABLED))
        {
	    return IX_ETH_ACC_FAIL;	    
        }
    }
    return IX_ETH_ACC_SUCCESS;
}

/**
 * @fn ixEthAccStatsShow
 *
 * @brief Display all stats
 *
 * @return void
 *
 *
 *
 */
void ixEthAccStatsShow(IxEthAccPortId portId)
{
    ixEthAccMdioShow();

    printf("\nPort %u\nUnicast MAC : ", portId);
    ixEthAccPortUnicastAddressShow(portId);
    ixEthAccPortMulticastAddressShow(portId);
    printf("\n");

    ixEthAccDataPlaneShow();
}



