#!/bin/sh
# This script need 3 arguments. 
#  ###ex: ./mkramdisk.sh simple_nas neutral 13312
# I will build a ramdisk image from current dir's ramdisk/,
# then I will move the $1.ram to diff/$1/$2

# We need check the number of the argument
if [ $# -ne 3 ] ; then
    echo " ex: ./mkramdisk.sh simple_nas neutral 13312"
    exit 1
fi

MODULE_NAME="$1"
RAMPATH=`pwd`
TMPPATH=${RAMPATH}/tmp
SOURCE=${RAMPATH}/ramdisk

# Clear in tmp path
rm -rf ${TMPPATH}/tmpmnt
rm -rf ${TMPPATH}/ramrootfs
mkdir ${TMPPATH}/tmpmnt

# Clear the old ramdisk
rm -f ${RAMPATH}/"$MODULE_NAME".ram

# Make a temp file which size is 4096Kbytes
dd if=/dev/zero of=${TMPPATH}/ramrootfs bs=1k count=$3

# Create a ext2 filesystem
/sbin/mke2fs -F -m 0 -i 2000 ${TMPPATH}/ramrootfs

# Mount it to tmpmnt/
mount -o loop -t ext2 ${TMPPATH}/ramrootfs ${TMPPATH}/tmpmnt

# Copy everything from kernel to this.
cd ${TMPPATH}/tmpmnt
echo ${SOURCE}
cp -a ${SOURCE}/*  .
cd ${TMPPATH}

df ${TMPPATH}/tmpmnt | tail +2

# Unmount it the ext2 filesystem
umount ${TMPPATH}/tmpmnt
cat ${TMPPATH}/ramrootfs | gzip -9 > /${RAMPATH}/diff/"$1"/"$2"/"$MODULE_NAME".ram
echo Copying ramdisk image to ${RAMPATH}/diff/"$1"/"$2"

