/**
 * file IxTimerCtrl_p.h
 * 
 * author Intel Corporation
 * date 28-Aug-2002
 *
 *
 *
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
*/



#ifndef IXTIMERCTRL_H
#define IXTIMERCTRL_H

/*
 * Prototypes for interface functions.
 */

PRIVATE void
msec_To_ix_ossl_time(UINT32 ms, ix_ossl_time_t *timeVal);

/*
 * #defines for function return types, etc.
 */
#define IX_MAX_TIMER_CALLBACK_TIME  (100000000) /* 100,000,000 nS = 100 mS */
#define IX_CONVERT_TO_MILLISECONDS  (1000)



/*
 *  MAX_TIMERS must NEVER be set to 20 or below due to the threshold below.
 */
#define IX_MAX_TIMERS 100
#define IX_TIMER_WARNING_THRESHOLD (IX_MAX_TIMERS - 20)


#if (IX_MAX_TIMERS <= 20)
#error "IX_MAX_TIMERS must be defined to be >20"
#endif

#endif
/* defined IXTIMERCTRL_H */
