/**
 * @file IxOsslSymbols.c
 *
 * @author Intel Corporation
 * @date 04-Oct-2002
 *
 * @brief This file declares exported symbols for linux kernel module builds.
 *
 * @version $Revision: 1.1.1.1 $
 * 
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * @par
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * @par
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * @par
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * @par
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * @par
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * @par
 * -- End Intel Copyright Notice --
 */

#ifdef __linux

#include <linux/module.h>
#include <ix_ossl.h>

EXPORT_SYMBOL(ix_ossl_sem_init);
EXPORT_SYMBOL(ix_ossl_sem_take);
EXPORT_SYMBOL(ix_ossl_sem_give);
EXPORT_SYMBOL(ix_ossl_mutex_init);
EXPORT_SYMBOL(ix_ossl_mutex_lock);
EXPORT_SYMBOL(ix_ossl_mutex_unlock);
EXPORT_SYMBOL(ix_ossl_thread_create);
EXPORT_SYMBOL(ix_ossl_thread_kill);
EXPORT_SYMBOL(ix_ossl_thread_set_priority);
EXPORT_SYMBOL(ix_ossl_sleep);
EXPORT_SYMBOL(ix_ossl_thread_exit);
EXPORT_SYMBOL(ix_ossl_time_get);
EXPORT_SYMBOL(ix_ossl_thread_delay);
EXPORT_SYMBOL(ix_ossl_tick_get);


#endif /* __linux */
