/*
 * File Version: $Revision: 1.1.1.1 $
 * 
 * -- Intel Copyright Notice --
 * 
 * Copyright 2002-2003 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents
 * related to the source code ("Material") are owned by Intel Corporation
 * or its suppliers or licensors.  Title to the Material remains with
 * Intel Corporation or its suppliers and licensors.
 * 
 * The Material is protected by worldwide copyright and trade secret laws
 * and treaty provisions. No part of the Material may be used, copied,
 * reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way except in accordance with the
 * applicable license agreement .
 * 
 * No license under any patent, copyright, trade secret or other
 * intellectual property right is granted to or conferred upon you by
 * disclosure or delivery of the Materials, either expressly, by
 * implication, inducement, estoppel, except in accordance with the
 * applicable license agreement.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or
 * alter this notice or any other notice embedded in Materials by Intel
 * or Intel's suppliers or licensors in any way.
 * 
 * For further details, please see the file README.TXT distributed with
 * this software.
 * 
 * -- End Intel Copyright Notice --
*/

/*
 * Below is sample utility code solely for the purpose of conversion
 * between firmware provided by STMicro in binary format to a byte
 * table format that is compatible with the Adsl driver in version 1.3
 * of the Intel IXP400 Software Release.
 *
 * usage: bin2h.exe <input_file> <output_file> 
 * 
 * Intel shall not be responsible/liable for any damages resulting from 
 * the use of this sample utility code. 
 */


#include <stdio.h>

int main(int argc, char *argv[])
{

  FILE *fpIN;
  FILE *fpOUT;
  int done=0;
  int byteCnt=0;
  int bytesInLine=0;
  unsigned char ch;

  fpIN = fopen(argv[1],"r");

  if ((int) fpIN == -1 )
   exit(1); 

  fpOUT = fopen(argv[2],"w");
  if ((int) fpOUT == -1 )
    exit(1); 

  fprintf(fpOUT,"\n\n\nunsigned char adsl_load[]={\n");

  while( !done ) 
  {

    ch = fgetc(fpIN);
    if (! feof(fpIN ) )
    {
      fprintf(fpOUT,"0x%02X, ",ch);
      byteCnt++;
      bytesInLine++;
      if ( bytesInLine == 8 )
      {
	fprintf(fpOUT,"\n");
	bytesInLine=0;
      }
    }
    else
    {
      done=1;
    }

  }

  fprintf(fpOUT,"\n};\n\n\n");

  fclose(fpOUT);
  fclose(fpIN);
   
}


     
