/* 
 * musb.h - mobilygen merlin usb
 *
 * Copyright 2007 Mobilygen
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __MUSB_H
#define __MUSB_H

#include <linux/mobi_usb_device.h>

#define MUSB_MAX_DEVS 6			// max number of /dev/musb.x devices 


#define VCI_INTF_ENTRIES   8

struct uvc_vc_interface_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u16 bcdUVC;
	__u16 wTotalLength;
	__u32 dwClockFrequency;
	__u8  bInCollection;
	__u8  baInterfaceNr[VCI_INTF_ENTRIES];
} __attribute__ ((packed));


struct uvc_input_terminal_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bTerminalID;
	__u16 wTerminalType;
	__u8  bAssocTerminal;
	__u8  iTerminal;
} __attribute__ ((packed));


struct uvc_input_terminal_camera_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bTerminalID;
	__u16 wTerminalType;
	__u8  bAssocTerminal;
	__u8  iTerminal;
	//--additional fields depending on termianl type--
	__u16 wObjectiveFocalLengthMin;
	__u16 wObjectiveFocalLengthMax;
	__u16 wOcularFocalLength;
	__u8  bControlSize;
	__u16 bmControls;
} __attribute__ ((packed));


struct uvc_output_terminal_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bTerminalID;
	__u16 wTerminalType;
	__u8  bAssocTerminal;
	__u8  bSourceID;
	__u8  iTerminal;
} __attribute__ ((packed));


struct uvc_selector_unit_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bUnitID;
	__u8  bNrInPins;		// number of input pins
	__u8  baSourceID1;
	__u8  baSourceID2;
	//...
	__u8  iSelector;
} __attribute__ ((packed));


struct uvc_processing_unit_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bUnitID;
	__u8  bSourceID;
	__u16 wMaxMultiplier;
	__u8  bControlSize;
	__u16 bmControls;
	__u8  iProcessing;
} __attribute__ ((packed));


struct uvc_interrupt_endpoint_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bEndpointAddress;
	__u8  bmAttributes;
	__u16 wMaxPacketSize;
	__u8  bInterval;
} __attribute__ ((packed));


struct uvc_class_spec_interrupt_endpoint_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u16 wMaxTransferSize;
} __attribute__ ((packed));




//------------------------------------------------------------------------------
// Video Interface Class Codes
//------------------------------------------------------------------------------
#define UVC_CC_VIDEO									0x0E

//------------------------------------------------------------------------------
// Video Interface Subclass Codes
//------------------------------------------------------------------------------
#define UVC_SC_UNDEFINED								0x00
#define UVC_SC_VIDEOCONTROL								0x01
#define UVC_SC_VIDEOSTREAMING							0x02
#define UVC_SC_VIDEO_INTERFACE_COLLECTION				0x03

//------------------------------------------------------------------------------
// Video Interface Protocol Codes
//------------------------------------------------------------------------------
#define UVC_PC_PROTOCOL_UNDEFINED						0x00

//------------------------------------------------------------------------------
// Video Class-Specific Descriptor Types
//------------------------------------------------------------------------------
#define UVC_CS_UNDEFINED								0x20
#define UVC_CS_DEVICE									0x21
#define UVC_CS_CONFIGURATION							0x22
#define UVC_CS_STRING									0x23
#define UVC_CS_INTERFACE								0x24
#define UVC_CS_ENDPOINT									0x25

//------------------------------------------------------------------------------
// Video Class Interface Descriptor Subtypes
//------------------------------------------------------------------------------
#define UVC_VC_DESCRIPTOR_UNDEFINED						0x00
#define UVC_VC_HEADER									0x01
#define UVC_VC_INPUT_TERMINAL							0x02
#define UVC_VC_OUTPUT_TERMINAL							0x03
#define UVC_VC_SELECTOR_UNIT							0x04
#define UVC_VC_PROCESSING_UNIT							0x05
#define UVC_VC_EXTENSION_UNIT							0x06

//------------------------------------------------------------------------------
// Video Class-Specific VS Interface Descriptor Subtypes
//------------------------------------------------------------------------------
#define UVC_VS_UNDEFINED								0x00
#define UVC_VS_INPUT_HEADER 							0x01
#define UVC_VS_OUTPUT_HEADER							0x02
#define UVC_VS_STILL_IMAGE_FRAME						0x03
#define UVC_VS_FORMAT_UNCOMPRESSED						0x04
#define UVC_VS_FRAME_UNCOMPRESSED						0x05
#define UVC_VS_FORMAT_MJPEG 							0x06
#define UVC_VS_FRAME_MJPEG								0x07
// reserved												0x08
// reserved												0x09
#define UVC_VS_FORMAT_MPEG2TS							0x0A	
// reserved												0x0B
#define UVC_VS_FORMAT_DV								0x0C
#define UVC_VS_COLORFORMAT								0x0D
// reserved												0x0E
// reserved												0x0F
#define UVC_VS_FORMAT_FRAME_BASED						0x10
#define UVC_VS_FRAME_FRAME_BASED						0x11
#define UVC_VS_FORMAT_STREAM_BASED						0x12

//------------------------------------------------------------------------------
// Video Class-Specific Endpoint Descriptor Subtypes
//------------------------------------------------------------------------------
#define UVC_EP_UNDEFINED								0x00
#define UVC_EP_GENERAL									0x01
#define UVC_EP_ENDPOINT 								0x02
#define UVC_EP_INTERRUPT								0x03

//------------------------------------------------------------------------------
// Video Class-Specific Request Codes
//------------------------------------------------------------------------------
#define UVC_REQ_RC_UNDEFINED							0x00
#define UVC_REQ_SET_CUR									0x01
#define UVC_REQ_GET_CUR									0x81
#define UVC_REQ_GET_MIN 								0x82
#define UVC_REQ_GET_MAX 								0x83
#define UVC_REQ_GET_RES 								0x84
#define UVC_REQ_GET_LEN 								0x85
#define UVC_REQ_GET_INFO								0x86
#define UVC_REQ_GET_DEF 								0x87

//------------------------------------------------------------------------------
// VideoControl Interface Control Selectors
//------------------------------------------------------------------------------
#define UVC_VC_CONTROL_UNDEFINED						0x00
#define UVC_VC_VIDEO_POWER_MODE_CONTROL					0x01
#define UVC_REQUEST_ERROR_CODE_CONTROL					0x02
// reserved												0x03

//------------------------------------------------------------------------------
// Terminal Control Selectors
//------------------------------------------------------------------------------
#define UVC_TE_CONTROL_UNDEFINED						0x00

//------------------------------------------------------------------------------
// Selector Unit Control Selectors
//------------------------------------------------------------------------------
#define UVC_SU_CONTROL_UNDEFINED						0x00
#define UVC_SU_INPUT_SELECT_CONTROL						0x01

//------------------------------------------------------------------------------
// Camera Terminal Control Selectors
//------------------------------------------------------------------------------
#define UVC_CT_CONTROL_UNDEFINED						0x00
#define UVC_CT_SCANNING_MODE_CONTROL					0x01
#define UVC_CT_AE_MODE_CONTROL							0x02
#define UVC_CT_AE_PRIORITY_CONTROL						0x03
#define UVC_CT_EXPOSURE_TIME_ABSOLUTE_CONTROL			0x04
#define UVC_CT_EXPOSURE_TIME_RELATIVE_CONTROL			0x05
#define UVC_CT_FOCUS_ABSOLUTE_CONTROL					0x06
#define UVC_CT_FOCUS_RELATIVE_CONTROL					0x07
#define UVC_CT_FOCUS_AUTO_CONTROL						0x08
#define UVC_CT_IRIS_ABSOLUTE_CONTROL					0x09
#define UVC_CT_IRIS_RELATIVE_CONTROL					0x0A
#define UVC_CT_ZOOM_ABSOLUTE_CONTROL					0x0B
#define UVC_CT_ZOOM_RELATIVE_CONTROL					0x0C
#define UVC_CT_PANTILT_ABSOLUTE_CONTROL 				0x0D
#define UVC_CT_PANTILT_RELATIVE_CONTROL 				0x0E
#define UVC_CT_ROLL_ABSOLUTE_CONTROL					0x0F
#define UVC_CT_ROLL_RELATIVE_CONTROL					0x10
#define UVC_CT_PRIVACY_CONTROL							0x11
													
//------------------------------------------------------------------------------
// Processing Unit Control Selectors			
//------------------------------------------------------------------------------
#define UVC_PU_CONTROL_UNDEFINED						0x00
#define UVC_PU_BACKLIGHT_COMPENSATION_CONTROL			0x01
#define UVC_PU_BRIGHTNESS_CONTROL						0x02
#define UVC_PU_CONTRAST_CONTROL 						0x03
#define UVC_PU_GAIN_CONTROL 							0x04
#define UVC_PU_POWER_LINE_FREQUENCY_CONTROL 			0x05
#define UVC_PU_HUE_CONTROL								0x06
#define UVC_PU_SATURATION_CONTROL						0x07
#define UVC_PU_SHARPNESS_CONTROL						0x08
#define UVC_PU_GAMMA_CONTROL							0x09
#define UVC_PU_WHITE_BALANCE_TEMPERATURE_CONTROL		0x0A
#define UVC_PU_WHITE_BALANCE_TEMPERATURE_AUTO_CONTROL	0x0B
#define UVC_PU_WHITE_BALANCE_COMPONENT_CONTROL			0x0C
#define UVC_PU_WHITE_BALANCE_COMPONENT_AUTO_CONTROL 	0x0D
#define UVC_PU_DIGITAL_MULTIPLIER_CONTROL				0x0E
#define UVC_PU_DIGITAL_MULTIPLIER_LIMIT_CONTROL 		0x0F
#define UVC_PU_HUE_AUTO_CONTROL 						0x10
#define UVC_PU_ANALOG_VIDEO_STANDARD_CONTROL			0x11
#define UVC_PU_ANALOG_LOCK_STATUS_CONTROL				0x12

//------------------------------------------------------------------------------
// Extension Unit Control Selectors
//------------------------------------------------------------------------------
#define UVC_XU_CONTROL_UNDEFINED						0x00

//------------------------------------------------------------------------------
// VideoStreaming Interface Control Selectors
//------------------------------------------------------------------------------
#define UVC_VS_CONTROL_UNDEFINED						0x00
#define UVC_VS_PROBE_CONTROL							0x01
#define UVC_VS_COMMIT_CONTROL							0x02
#define UVC_VS_STILL_PROBE_CONTROL						0x03
#define UVC_VS_STILL_COMMIT_CONTROL 					0x04
#define UVC_VS_STILL_IMAGE_TRIGGR_CONTROL				0x05
#define UVC_VS_STREAM_ERROR_CODE_CONTROL				0x06
#define UVC_VS_GENERATE_KEY_FRAME_CONTROL				0x07
#define UVC_VS_UPDATE_FRAME_SEGMENT_CONTROL 			0x08
#define UVC_VS_SYNCH_DELAY_CONTROL						0x09

//------------------------------------------------------------------------------
// USB Terminal Types
//------------------------------------------------------------------------------
#define UVC_TT_VENDOR_SPECIFIC							0x0100
#define UVC_TT_STREAMING								0x0101

//------------------------------------------------------------------------------
// Input Terminal Types
//------------------------------------------------------------------------------
#define UVC_ITT_VENDOR_SPECIFIC							0x0200
#define UVC_ITT_CAMERA									0x0201
#define UVC_ITT_MEDIA_TRANSPORT_INPUT					0x0202

//------------------------------------------------------------------------------
// Output Terminal Types
//------------------------------------------------------------------------------
#define UVC_OTT_VENDOR_SPECIFIC							0x0300
#define UVC_OTT_DISPLAY									0x0301
#define UVC_OTT_MEDIA_TRANSPORT_OUTPUT					0x0302

//------------------------------------------------------------------------------
// External Terminal Types
//------------------------------------------------------------------------------
#define UVC_EXTERNAL_VENDOR_SPECIFIC					0x0400
#define UVC_COMPOSITE_CONNECTOR							0x0401
#define UVC_SVIDEO_CONNECTOR							0x0402
#define UVC_COMPONENT_CONNECTOR							0x0403


//------------------------------------------------------------------------------
// user app and host driver ioctl passing struct 
//------------------------------------------------------------------------------
struct usbtest_param {
	// inputs
	unsigned test_num;
	unsigned iterations;
	unsigned length;
	unsigned sglen;

	// outputs
	struct timeval duration;
};

//------------------------------------------------------------------------------
// usbtest IOCTL codes:
//------------------------------------------------------------------------------
#define USBTEST_REQUEST	_IOWR('U', 100, struct usbtest_param)









//##############################################################################
// below are crusher-like stuff: csr/mem read/writes.  
// This is placed here for internal testing and debugging purpose.
//##############################################################################

#define DEVICE_CONFIG_NUM				1	// Device USB configuration number
#define DEVICE_IFACE_NUM				0	// Device USB interface number for this configuration



#define VR_ENDPOINT	    0   // vendor request endpoint

#define DEVICE_EP1_OUT_MG_CMD           (1 | USB_ENDPOINT_OUT)   //MG1264 Bulk Command 
#define DEVICE_EP1_IN_MG_CMD            (1 | USB_ENDPOINT_IN)   //MG1264 Bulk Command
#define DEVICE_EP2_USB_DATA				(2 | USB_ENDPOINT_OUT)  // Bulk test endpoint
#define DEVICE_EP6_IN_DATA              (6 | USB_ENDPOINT_IN)   //MG1264 Bulk Command
#define DEVICE_EP8_IN_MG_EVT   	        (8 | USB_ENDPOINT_IN)


// Mobilygen Vendor Requests
#define VX_CSR_READ 					0xB5 // Control Status Register Read (8051)
#define VX_CSR_WRITE 					0xB6 // Control Status Register Write (8051)
#define VX_CSR_READ_MEM_BLOCK 			0xB7 // Control Status Register Read memory Block (8051)
#define VX_CSR_WRITE_MEM_BLOCK 			0xB8 // Control Status Register Write memory Block (8051)
#define VX_HOST_READ_REG 				0xB9 // Host Read Register (GPIF)
#define VX_HOST_WRITE_REG 				0xBA // Host Write Register (GPIF)
#define VX_EEPROM       				0xBB // Read/Write EEPROM
#define VX_MG1264_RESET					0xBC // Reset MG1264
#define VX_CSR_CFG_READ_MEM_BLOCK		0xBD // Configure the Read Mem Block  VR Command for address, Block Id, ...
#define VX_CSR_WRITE_MEM_BLOCK_DATA 	0xBE // Sending down the paylod for the Write Mem Block, you must first setup and configure the write mem block prior to sending down this command.

#define HostWriteReg  					0XBA
#define HostReadReg   					0XB9
#define HOST_WRITE_ENDPOINT   			0
#define HOST_READ_ENDPOINT    			0

// Timeout in milliseconds for a bulk transfer of BUFFER_SIZE bytes
#define USB_BULK_TIMEOUT  				5000	

// Buffer size for bulk transfer test (block size)
#define BUFFER_SIZE  					65536

// Default total transfer size to use
#define DEFAULT_SIZE 					10000000

// USB Vendor Request Commands FX2 data size requirements. Structure sizes are different accross platforms.
#define SIZE_OF_CSR_WRITE_FOR_FX2  			8	// VRCSRWrite_struct
#define SIZE_OF_CSR_BULK_MEM_WRITE_FOR_FX2 	9
#define SIZE_OF_CSR_BULK_MEM_READ_FOR_FX2 	9	


#endif
