#ifndef MHIF_DEVICE_H
#define MHIF_DEVICE_H

#define MHIF_AMBA_NAME			"mhif"
#define MHIF_AMBA_DEVID			0x00041113
#define MHIF_AMBA_DEVID_MASK	0x000fffff

/* for devConfigA register */
#define MHIF_DEVICE_DATA_WIDTH_8	0
#define MHIF_DEVICE_DATA_WIDTH_16	1

#define MHIF_DEVICE_LITTLE_ENDIAN	0
#define MHIF_DEVICE_BIG_ENDIAN		1

/* addr and data write: 0=separate bus, 1=same bus */
#define MHIF_DEVICE_BUS_SEPARATE	0
#define MHIF_DEVICE_BUS_SHARED		1

/* 0=normal 1=mhif write waits for MHIF_DMARQ hardware signal */
#define MHIF_DEVICE_DMAWAIT_DISABLE		0
#define MHIF_DEVICE_DMAWAIT_ENABLE		1

/* 0=normal 1=mhif waits for MHIF_WAIT from other devices */
#define MHIF_DEVICE_MHIFWAIT_DISABLE	0
#define MHIF_DEVICE_MHIFWAIT_ENABLE		1

/* 0=no auto increment. 1=auto increment of address */
#define MHIF_DEVICE_ADDRINC_DISABLE		0
#define MHIF_DEVICE_ADDRINC_ENABLE		1

/* for devConfigB register */
/* timeout enable disable ignores MHIF_WAIT & CntTO */
#define MHIF_DEVICE_TIMEOUT_DISABLE		0
#define MHIF_DEVICE_TIMEOUT_ENABLE		1

/* ale strobe on 0=rise, 1=fall edge*/
#define MHIF_DEVICE_ALE_STROBE_RISING	0
#define MHIF_DEVICE_ALE_STROBE_FALLING	1

/* Chip select 0=active high, 1=active low*/
#define MHIF_DEVICE_CS_ACTIVE_HIGH	0
#define MHIF_DEVICE_CS_ACTIVE_LOW	1

/* MHIF_WAIT input 0=active high, 1=active low*/
#define MHIF_DEVICE_WAITEN_ACTIVE_HIGH	0
#define MHIF_DEVICE_WAITEN_ACTIVE_LOW	1

/* MHIF_DMARQ input 0=active high, 1=active low*/
#define MHIF_DEVICE_DMARQ_ACTIVE_HIGH	0
#define MHIF_DEVICE_DMARQ_ACTIVE_LOW	1

#define MHIF_DEVICE0_START	0x0
#define MHIF_DEVICE0_END	(MHIF_DEVICE0_START+MHIF_DEVICE0_SIZE-1)
#define MHIF_DEVICE1_START	(MHIF_DEVICE0_END+1)
#define MHIF_DEVICE1_END	(MHIF_DEVICE1_START+MHIF_DEVICE1_SIZE-1)
#define MHIF_DEVICE2_START	(MHIF_DEVICE1_END+1)
#define MHIF_DEVICE2_END	(MHIF_DEVICE2_START+MHIF_DEVICE2_SIZE-1)
#define MHIF_DEVICE3_START	(MHIF_DEVICE2_END+1)
#define MHIF_DEVICE3_END	(MHIF_DEVICE3_START+MHIF_DEVICE3_SIZE-1)
#define MHIF_DEVICE4_START	(MHIF_DEVICE3_END+1)
#define MHIF_DEVICE4_END	(MHIF_DEVICE4_START+MHIF_DEVICE4_SIZE-1)
#define MHIF_DEVICE5_START	(MHIF_DEVICE4_END+1)
#define MHIF_DEVICE5_END	(MHIF_DEVICE5_START+MHIF_DEVICE5_SIZE-1)

struct mhif_device_t {
    uint8_t    chip_select;         
    uint8_t    width;         
    uint8_t    endian;         
    uint8_t    bus_mux;      
    uint8_t    dma_wen;        
    uint8_t    wait_en;        
    uint8_t    addr_inc;      

    uint16_t   ale_setup_ns; 
    uint16_t   ale_width_ns;
    uint16_t   ale_hold_ns;
    uint16_t   rd_wait_ns;
    uint16_t   wr_hold_ns; 
    uint16_t   dev_timeout_ns;
    uint16_t   dev_idle_ns; 
    uint8_t    prescaler;  
    uint8_t    timeout_en;     
    uint16_t   wr_delay_ns;   
    uint8_t    ale_edge;
    uint8_t    cs_lvl; 
    uint8_t    wait_lvl; 
    uint8_t    dmarq_lvl;
    uint16_t   rd_hold_ns;  

	/* use to define device address space */
	uint32_t resource_start;
	uint32_t resource_end;
	char dev_name[32];
};

struct mhif_driver_data_t {
	int	num_devices;
	struct mhif_device_t *devices;
	char clk_name[32];
};

#endif  /* MHIF_DEVICE_H */
