/*
 *	mb86290fb.h  --  MB86290 Series FrameBuffer Driver
 *
 *      Copyright (C) FUJITSU LIMITED 2003
 *	1.01.002
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version
 *  2 of the License, or (at your option) any later version.
 */
#ifndef _MB86290FB_H_
#define _MB86290FB_H_

#ifndef __KERNEL__
#include <sys/ioctl.h>
#endif

#if defined(CONFIG_FB_MB86290_CORALP)
#define		CORAL_LP
/*#define	CORAL_LB */
#elif defined(CONFIG_FB_MB86290_LIME)
#define		LIME
#endif

/*--------------------------------------------------------*/
/* MB86290 Series Frame Buffer Driver Original Definition */
/*--------------------------------------------------------*/
#define	MB86290FB_MAGIC_NUMBER			0x4D423836

/* ioctl */
#define	MB86290FB_IOC_MAGIC		'M'
#define FBIO_MB86290_GETSEM		_IO(MB86290FB_IOC_MAGIC,   1)
#define FBIO_MB86290_UNGETSEM		_IO(MB86290FB_IOC_MAGIC,   2)
#define	FBIO_MB86290_DMATRANSFER	_IO(MB86290FB_IOC_MAGIC,   3)
#define	FBIO_MB86290_GETSYSINFO		_IO(MB86290FB_IOC_MAGIC,   4)
#define	FBIO_MB86290_WAITDRAWCOMPLETE	_IO(MB86290FB_IOC_MAGIC,   5)
#define FBIO_MB86290_POLLDRAWCOMPLETE	_IO(MB86290FB_IOC_MAGIC,   6)
#define FBIO_MB86290_RESETDRAWQUEUE	_IO(MB86290FB_IOC_MAGIC,   7)
#define FBIO_MB86290_CANCELDRAW		_IO(MB86290FB_IOC_MAGIC,   8)
#define FBIO_MB86290_CANCELDRAWALL	_IO(MB86290FB_IOC_MAGIC,   9)
#define FBIO_MB86290_ADDDRAWQUEUE	_IO(MB86290FB_IOC_MAGIC,  10)
#define FBIO_MB86290_SWITCHDRAWQUEUE	_IO(MB86290FB_IOC_MAGIC,  11)
#define FBIO_MB86290_SUSPENDDRAWQUEUE	_IO(MB86290FB_IOC_MAGIC,  12)
#define FBIO_MB86290_GENSIGNAL		_IO(MB86290FB_IOC_MAGIC,  13)
#define FBIO_MB86290_STOPSIGNAL		_IO(MB86290FB_IOC_MAGIC,  14)
#define FBIO_MB86290_SOFTWARERESET	_IO(MB86290FB_IOC_MAGIC,  15)
#define FBIO_MB86290_FREEDMAMEMORY	_IO(MB86290FB_IOC_MAGIC,  16)
#define	FBIO_MB86290_GETDISPINFO	_IO(MB86290FB_IOC_MAGIC,  17)
#define FBIO_MB86290_DISPFLIPAUTOF	_IO(MB86290FB_IOC_MAGIC,  18)
#define FBIO_MB86290_DISPPOSSYNC	_IO(MB86290FB_IOC_MAGIC,  19)
#define FBIO_MB86290_SETFRAMESIZE	_IO(MB86290FB_IOC_MAGIC,  20)

#define FBIO_MB86290_ALLOCVRAM		_IO(MB86290FB_IOC_MAGIC,  21)
#define FBIO_MB86290_FREEVRAM		_IO(MB86290FB_IOC_MAGIC,  22)

#define FBIO_MB86290_SETFLAG		_IO(MB86290FB_IOC_MAGIC,  23)
#define FBIO_MB86290_CLEARFLAG		_IO(MB86290FB_IOC_MAGIC,  24)
#define FBIO_MB86290_WAITFLAG		_IO(MB86290FB_IOC_MAGIC,  25)

#define	FBIO_MB86290_READ_REGISTER	_IO(MB86290FB_IOC_MAGIC,  26)
#define	FBIO_MB86290_WRITE_REGISTER	_IO(MB86290FB_IOC_MAGIC,  27)

#define FBIO_MB86290_READDRAWMAN	_IO(MB86290FB_IOC_MAGIC,  28)
#define FBIO_MB86290_READDRAWHEAD	_IO(MB86290FB_IOC_MAGIC,  29)
#define FBIO_MB86290_READDRAWLIST	_IO(MB86290FB_IOC_MAGIC,  30)

#define FBIO_MB86290_ENABLELDMA		_IO(MB86290FB_IOC_MAGIC,  31)
#define FBIO_MB86290_DISABLELDMA	_IO(MB86290FB_IOC_MAGIC,  32)

#define FBIO_MB86290_GETEXTPINS		_IO(MB86290FB_IOC_MAGIC,  33)
#define FBIO_MB86290_RELEASEEXTPINS	_IO(MB86290FB_IOC_MAGIC,  34)

#define FBIO_MB86290_GETCAPTURE		_IO(MB86290FB_IOC_MAGIC,  35)
#define FBIO_MB86290_RELEASECAPTURE	_IO(MB86290FB_IOC_MAGIC,  36)

#define FBIO_MB86290_SIOREADWRITE	_IO(MB86290FB_IOC_MAGIC,  37)
#define FBIO_MB86290_WAITGPIO		_IO(MB86290FB_IOC_MAGIC,  38)

#define FBIO_MB86290_SETBIT		_IO(MB86290FB_IOC_MAGIC,  39)
#define FBIO_MB86290_CLEARBIT		_IO(MB86290FB_IOC_MAGIC,  40)

#define FBIO_MB86290_READ_DISP_REG	_IO(MB86290FB_IOC_MAGIC,  41)
#define FBIO_MB86290_WRITE_DISP_REG	_IO(MB86290FB_IOC_MAGIC,  42)
#define FBIO_MB86290_READ_CAP_REG	_IO(MB86290FB_IOC_MAGIC,  43)
#define FBIO_MB86290_WRITE_CAP_REG	_IO(MB86290FB_IOC_MAGIC,  44)
#define FBIO_MB86290_READ_GEO_REG	_IO(MB86290FB_IOC_MAGIC,  45)
#define FBIO_MB86290_WRITE_GEO_REG	_IO(MB86290FB_IOC_MAGIC,  46)
#define FBIO_MB86290_READ_DRAW_REG	_IO(MB86290FB_IOC_MAGIC,  47)
#define FBIO_MB86290_WRITE_DRAW_REG	_IO(MB86290FB_IOC_MAGIC,  48)

/* displaylist/data transfer mode */
#define MB86290FB_BURST_SLAVE_WRITE	0x00000000
#define MB86290FB_BURST_SLAVE_READ	0x00000001
#define MB86290FB_BURST_LOCAL		0x00000002
#define MB86290FB_BURST_MASTER_READ	0x00000004
#define MB86290FB_BURST_MASTER_WRITE	0x00000005
#define MB86290FB_BURST_MASTER_RW	0x00000006
#define	MB86290FB_BURST_SRCINC		0x20000000
#define	MB86290FB_BURST_DSTINC		0x40000000
#define MB86290FB_DLTRANSMODE_SLAVE	\
(MB86290FB_TRANSMODE_DL|MB86290FB_BURST_SLAVE_WRITE|MB86290FB_BURST_SRCINC)
#define MB86290FB_DLTRANSMODE_LOCAL	\
(MB86290FB_TRANSMODE_DL|MB86290FB_BURST_LOCAL|MB86290FB_BURST_SRCINC)
#define MB86290FB_DLTRANSMODE_MASTER	\
(MB86290FB_TRANSMODE_DL|MB86290FB_BURST_MASTER_READ|MB86290FB_BURST_SRCINC)
#define	MB86290FB_TRANSMODE_DL		0x01000000
#define	MB86290FB_TRANSMODE_DATA	0x02000000

/* Semaphore */
#define MB86290FB_SEM_LAYER	0
#define MB86290FB_SEM_L1	1
#define MB86290FB_SEM_CURSOR	2
#define MB86290FB_SEM_GPIO	3

#endif /*_MB86290FB_H_*/
