/*
 * usb_cap_interface.c USB Video Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 * The file implements vendor frame desciptors 
 *
 */
#include "vend_frame_descript.h"


#if HAS_H264_TRANS_SINK_RES_120	== 1
struct uvc_vs_frame_descriptor_frame_based vs_frame_descriptor_sink_h264_120 = {
	.bLength 			= sizeof(vs_frame_descriptor_sink_h264_120),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_FRAME_BASED,
	.bFrameIndex			=  H264_TRANS_SINK_INDEX_RES_120,
	.bmCapabilities			= 0x01,
	.wWidth				= 160,
	.wHeight			= 120,
	.dwMinBitRate			= 0x000DEC00,	
	.dwMaxBitRate			= 0x000DEC00,
	.dwDefaultFrameInterval		= 0x000A2C2A,
	.bFrameIntervalType		= 0x00,
	.dwMinFrameInterval		= 0x000A2C2A,
	.dwMaxFrameInterval		= 0x000A2C2A,
	.dwFrameIntervalStep	= 0x00
};
#endif

#if HAS_H264_TRANS_SINK_RES_144	== 1
struct uvc_vs_frame_descriptor_frame_based vs_frame_descriptor_sink_h264_144 = {
	.bLength 			= sizeof(vs_frame_descriptor_sink_h264_144),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_FRAME_BASED,
	.bFrameIndex			=  H264_TRANS_SINK_INDEX_RES_144,
	.bmCapabilities			= 0x01,
	.wWidth				= 176,
	.wHeight			= 144,
	.dwMinBitRate			= 0x000DEC00,	
	.dwMaxBitRate			= 0x000DEC00,
	.dwDefaultFrameInterval		= 0x000A2C2A,
	.bFrameIntervalType		= 0x00,
	.dwMinFrameInterval		= 0x000A2C2A,
	.dwMaxFrameInterval		= 0x000A2C2A,
	.dwFrameIntervalStep	= 0x00
};
#endif

#if HAS_H264_TRANS_SINK_RES_240	== 1
struct uvc_vs_frame_descriptor_frame_based vs_frame_descriptor_sink_h264_240 = {
	.bLength 			= sizeof(vs_frame_descriptor_sink_h264_240),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_FRAME_BASED,
	.bFrameIndex			=  H264_TRANS_SINK_INDEX_RES_240,
	.bmCapabilities			= 0x01,
	.wWidth				= 320,
	.wHeight			= 240,
	.dwMinBitRate			= 0x000DEC00,	
	.dwMaxBitRate			= 0x000DEC00,
	.dwDefaultFrameInterval		= 0x000A2C2A,
	.bFrameIntervalType		= 0x00,
	.dwMinFrameInterval		= 0x000A2C2A,
	.dwMaxFrameInterval		= 0x000A2C2A,
	.dwFrameIntervalStep	= 0x00
};
#endif

#if HAS_H264_TRANS_SINK_RES_240W	== 1
struct uvc_vs_frame_descriptor_frame_based vs_frame_descriptor_sink_h264_240W = {
	.bLength 			= sizeof(vs_frame_descriptor_sink_h264_240W),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_FRAME_BASED,
	.bFrameIndex			=  H264_TRANS_SINK_INDEX_RES_240W,
	.bmCapabilities			= 0x01,
	.wWidth				= 384,
	.wHeight			= 240,
	.dwMinBitRate			= 0x000DEC00,	
	.dwMaxBitRate			= 0x000DEC00,
	.dwDefaultFrameInterval		= 0x000A2C2A,
	.bFrameIntervalType		= 0x00,
	.dwMinFrameInterval		= 0x000A2C2A,
	.dwMaxFrameInterval		= 0x000A2C2A,
	.dwFrameIntervalStep	= 0x00
};
#endif
#if HAS_H264_TRANS_SINK_RES_288	== 1
struct uvc_vs_frame_descriptor_frame_based vs_frame_descriptor_sink_h264_288 = {
	.bLength 			= sizeof(vs_frame_descriptor_sink_h264_288),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_FRAME_BASED,
	.bFrameIndex			= H264_TRANS_SINK_INDEX_RES_288,
	.bmCapabilities			= 0x01,
	.wWidth				= 352,
	.wHeight			= 288,
	.dwMinBitRate			= 0x000DEC00,	
	.dwMaxBitRate			= 0x000DEC00,
	.dwDefaultFrameInterval		= 0x000A2C2A,
	.bFrameIntervalType		= 0x00,
	.dwMinFrameInterval		= 0x000A2C2A,
	.dwMaxFrameInterval		= 0x000A2C2A,
	.dwFrameIntervalStep	= 0x00
};
#endif

#if HAS_H264_TRANS_SINK_RES_480I	== 1
struct uvc_vs_frame_descriptor_frame_based vs_frame_descriptor_sink_h264_480I = {
	.bLength 			= sizeof(vs_frame_descriptor_sink_h264_480I),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_FRAME_BASED,
	.bFrameIndex			= H264_TRANS_SINK_INDEX_RES_480I,
	.bmCapabilities			= 0x01,
	.wWidth				= 640,
	.wHeight			= 480,
	.dwMinBitRate			= 0x000DEC00,	
	.dwMaxBitRate			= 0x000DEC00,
	.dwDefaultFrameInterval		= 0x000A2C2A,
	.bFrameIntervalType		= 0x00,
	.dwMinFrameInterval		= 0x000A2C2A,
	.dwMaxFrameInterval		= 0x000A2C2A,
	.dwFrameIntervalStep	= 0x00
};
#endif


#if HAS_H264_TRANS_SINK_RES_480P	== 1
struct uvc_vs_frame_descriptor_frame_based vs_frame_descriptor_sink_h264_480P = {
	.bLength 			= sizeof(vs_frame_descriptor_sink_h264_480P),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_FRAME_BASED,
	.bFrameIndex			= H264_TRANS_SINK_INDEX_RES_480P,
	.bmCapabilities			= 0x01,
	.wWidth				= 640,
	.wHeight			= 480,
	.dwMinBitRate			= 0x000DEC00,	
	.dwMaxBitRate			= 0x000DEC00,
	.dwDefaultFrameInterval		= 0x000A2C2A,
	.bFrameIntervalType		= 0x00,
	.dwMinFrameInterval		= 0x000A2C2A,
	.dwMaxFrameInterval		= 0x000A2C2A,
	.dwFrameIntervalStep	= 0x00
};
#endif

#if HAS_H264_TRANS_SINK_RES_480W	== 1
struct uvc_vs_frame_descriptor_frame_based vs_frame_descriptor_sink_h264_480W = {
	.bLength 			= sizeof(vs_frame_descriptor_sink_h264_480W),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_FRAME_BASED,
	.bFrameIndex			= H264_TRANS_SINK_INDEX_RES_480W,
	.bmCapabilities			= 0x01,
	.wWidth				= 768,
	.wHeight			= 480,
	.dwMinBitRate			= 0x000DEC00,	
	.dwMaxBitRate			= 0x000DEC00,
	.dwDefaultFrameInterval		= 0x000A2C2A,
	.bFrameIntervalType		= 0x00,
	.dwMinFrameInterval		= 0x000A2C2A,
	.dwMaxFrameInterval		= 0x000A2C2A,
	.dwFrameIntervalStep	= 0x00
};
#endif

#if HAS_H264_TRANS_SINK_RES_576I	== 1
struct uvc_vs_frame_descriptor_frame_based vs_frame_descriptor_sink_h264_576I = {
	.bLength 			= sizeof(vs_frame_descriptor_sink_h264_576I),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_FRAME_BASED,
	.bFrameIndex			= H264_TRANS_SINK_INDEX_RES_576I,
	.bmCapabilities			= 0x01,
	.wWidth				=  704,
	.wHeight			=  576,
	.dwMinBitRate			= 0x000DEC00,	
	.dwMaxBitRate			= 0x000DEC00,
	.dwDefaultFrameInterval		= 0x000A2C2A,
	.bFrameIntervalType		= 0x00,
	.dwMinFrameInterval		= 0x000A2C2A,
	.dwMaxFrameInterval		= 0x000A2C2A,
	.dwFrameIntervalStep	= 0x00
};
#endif


#if HAS_H264_TRANS_SINK_RES_576P	== 1
struct uvc_vs_frame_descriptor_frame_based vs_frame_descriptor_sink_h264_576P = {
	.bLength 			= sizeof(vs_frame_descriptor_sink_h264_576P),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_FRAME_BASED,
	.bFrameIndex			= H264_TRANS_SINK_INDEX_RES_576P,
	.bmCapabilities			= 0x01,
	.wWidth				=  704,
	.wHeight			=  576,
	.dwMinBitRate			= 0x000DEC00,	
	.dwMaxBitRate			= 0x000DEC00,
	.dwDefaultFrameInterval		= 0x000A2C2A,
	.bFrameIntervalType		= 0x00,
	.dwMinFrameInterval		= 0x000A2C2A,
	.dwMaxFrameInterval		= 0x000A2C2A,
	.dwFrameIntervalStep	= 0x00
};
#endif

#if HAS_H264_TRANS_SINK_RES_720	== 1
struct uvc_vs_frame_descriptor_frame_based vs_frame_descriptor_sink_h264_720 = {
	.bLength 			= sizeof(vs_frame_descriptor_sink_h264_720),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_FRAME_BASED,
	.bFrameIndex			= H264_TRANS_SINK_INDEX_RES_720,
	.bmCapabilities			= 0x01,
	.wWidth				= 0x0500,	// 1280
	.wHeight			= 0x02D0,	// 720
	.dwMinBitRate			= 0x000DEC00,	
	.dwMaxBitRate			= 0x000DEC00,
	.dwDefaultFrameInterval		= 0x000A2C2A,
	.bFrameIntervalType		= 0x00,
	.dwMinFrameInterval		= 0x000A2C2A,
	.dwMaxFrameInterval		= 0x000A2C2A,
	.dwFrameIntervalStep	= 0x00
};
#endif

  
#if HAS_H264_TRANS_SINK_RES_800	== 1
struct uvc_vs_frame_descriptor_frame_based vs_frame_descriptor_sink_h264_800 = {
	.bLength 			= sizeof(vs_frame_descriptor_sink_h264_800),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_FRAME_BASED,
	.bFrameIndex			= H264_TRANS_SINK_INDEX_RES_800,
	.bmCapabilities			= 0x01,
	.wWidth				= 1280,	
	.wHeight			= 800,		
	.dwMinBitRate			= 0x000DEC00,	
	.dwMaxBitRate			= 0x000DEC00,
	.dwDefaultFrameInterval		= 0x000A2C2A,
	.bFrameIntervalType		= 0x00,
	.dwMinFrameInterval		= 0x000A2C2A,
	.dwMaxFrameInterval		= 0x000A2C2A,
	.dwFrameIntervalStep	= 0x00
};
#endif
