/*
 * usb_cap_interface.c USB Video Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 * The file implements careation UVC descriptors 
 *
 */

#include "uvcdescript.h"
#include "uvc_ext_api.h"
#include "mjpg_frame_descript.h"
#include "dbgout.h"


#define PACKET_INTERVAL		1
#define HAS_INTERRUPT		1

#if HAS_VIDCAP_ISOCH == 1
/* Video capture */
struct usb_endpoint_descriptor ep_vidcap0_desc_isoc_1 = {
	.bLength 		= USB_DT_ENDPOINT_SIZE,
	.bDescriptorType 	= USB_DT_ENDPOINT,
	.bEndpointAddress 	= USB_DIR_IN |  VID_CAP_EP_ADDR,
	.bmAttributes 		= USB_ENDPOINT_XFER_ISOC | (0x01 << 2),	// Asynchronous Synch type
	.wMaxPacketSize 	= __constant_cpu_to_le16(PKT_SIZE_ISOC1),
	.bInterval		= PACKET_INTERVAL
};
struct usb_endpoint_descriptor ep_vidcap0_desc_isoc_2 = {
	.bLength 		= USB_DT_ENDPOINT_SIZE,
	.bDescriptorType 	= USB_DT_ENDPOINT,
	.bEndpointAddress 	= USB_DIR_IN |  VID_CAP_EP_ADDR,
	.bmAttributes 		= USB_ENDPOINT_XFER_ISOC | (0x01 << 2),	// Asynchronous Synch type
	.wMaxPacketSize 	= __constant_cpu_to_le16(PKT_SIZE_ISOC2),
	.bInterval		= PACKET_INTERVAL
};
struct usb_endpoint_descriptor ep_vidcap0_desc_isoc_3 = {
	.bLength 		= USB_DT_ENDPOINT_SIZE,
	.bDescriptorType 	= USB_DT_ENDPOINT,
	.bEndpointAddress 	= USB_DIR_IN |  VID_CAP_EP_ADDR,
	.bmAttributes 		= USB_ENDPOINT_XFER_ISOC | (0x01 << 2),	// Asynchronous Synch type
	.wMaxPacketSize 	= __constant_cpu_to_le16(PKT_SIZE_ISOC3),
	.bInterval		= PACKET_INTERVAL
};
struct usb_endpoint_descriptor ep_vidcap0_desc_isoc_4 = {
	.bLength 		= USB_DT_ENDPOINT_SIZE,
	.bDescriptorType 	= USB_DT_ENDPOINT,
	.bEndpointAddress 	= USB_DIR_IN |  VID_CAP_EP_ADDR,
	.bmAttributes 		= USB_ENDPOINT_XFER_ISOC | (0x01 << 2),	// Asynchronous Synch type
	.wMaxPacketSize 	= __constant_cpu_to_le16(PKT_SIZE_ISOC4),
	.bInterval		= PACKET_INTERVAL
};
struct usb_endpoint_descriptor ep_vidcap0_desc_isoc_5 = {
	.bLength 		= USB_DT_ENDPOINT_SIZE,
	.bDescriptorType 	= USB_DT_ENDPOINT,
	.bEndpointAddress 	= USB_DIR_IN |  VID_CAP_EP_ADDR,
	.bmAttributes 		= USB_ENDPOINT_XFER_ISOC | (0x01 << 2),	// Asynchronous Synch type
	.wMaxPacketSize 	= __constant_cpu_to_le16(PKT_SIZE_ISOC5),
	.bInterval		= PACKET_INTERVAL
};

struct usb_endpoint_descriptor ep_vidcap0_desc_isoc_6 = {
        .bLength                = USB_DT_ENDPOINT_SIZE,
        .bDescriptorType        = USB_DT_ENDPOINT,
        .bEndpointAddress       = USB_DIR_IN |  VID_CAP_EP_ADDR,
        .bmAttributes           = USB_ENDPOINT_XFER_ISOC | (0x01 << 2), // Asynchronous Synch type
        .wMaxPacketSize         = __constant_cpu_to_le16(PKT_SIZE_ISOC6),
        .bInterval              = PACKET_INTERVAL
};
struct usb_endpoint_descriptor ep_vidcap0_desc_isoc_7 = {
        .bLength                = USB_DT_ENDPOINT_SIZE,
        .bDescriptorType        = USB_DT_ENDPOINT,
        .bEndpointAddress       = USB_DIR_IN |  VID_CAP_EP_ADDR,
        .bmAttributes           = USB_ENDPOINT_XFER_ISOC | (0x01 << 2), // Asynchronous Synch type
        .wMaxPacketSize         = __constant_cpu_to_le16(PKT_SIZE_ISOC7),
        .bInterval              = PACKET_INTERVAL
};

#else
/* Video capture */
struct usb_endpoint_descriptor ep_vidcap0_desc_bulk = {
	.bLength 			= USB_DT_ENDPOINT_SIZE,
	.bDescriptorType 	= USB_DT_ENDPOINT,
	.bEndpointAddress 	= USB_DIR_IN |  VID_CAP_EP_ADDR,
	.bmAttributes 		= USB_ENDPOINT_XFER_BULK,
	.wMaxPacketSize 	= __constant_cpu_to_le16(PKT_SIZE_CAP_BULK),
};

#endif

#if HAS_INTERRUPT == 1
/* Interrupt Endpoint */
struct usb_endpoint_descriptor ep_vidcap0_desc_int = {
	.bLength 		= USB_DT_ENDPOINT_SIZE,
	.bDescriptorType 	= USB_DT_ENDPOINT,
	.bEndpointAddress 	= USB_DIR_IN | VC_INT_EP_ADDR,
	.bmAttributes 		= USB_ENDPOINT_XFER_INT,
	.wMaxPacketSize 	= __constant_cpu_to_le16(0x0010),
};
#endif


#if HAS_VID_CAP == 1

//...more entries of configs go here, if any...

/******************************************************************************
 * IAD descriptor - describes VIC (Video Interface Collection) as Video Function
 * to group mulitple interfaces together in this 'Function'
 *
 ******************************************************************************/
static struct usb_interface_assoc_descriptor iad_desc = 
{
	.bLength 		= sizeof(struct usb_interface_assoc_descriptor),
	.bDescriptorType 	= USB_DT_INTERFACE_ASSOCIATION,
	.bFirstInterface	= 0, // interface # of the VideoControl interface that is associated with this function
	.bInterfaceCount	= 2,
	.bFunctionClass		= 0x0E,		// UVC_CC_VIDEO,
	.bFunctionSubClass	= 0x03,		// UVC_SC_VIDEO_INTERFACE_COLLECTION,
	.bFunctionProtocol	= 0x00,		// UVC_PC_PROTOCOL_UNDEFINED,
	.iFunction		= STN_PRODUCT	// Index of a string descriptor that describes this interface. 
						// This must be used for the device (function) name and be 
						// implemented in US English (LANGID = 0x0409) at the minimum.
};

static const struct usb_interface_descriptor standard_vc_interface_descriptor = {
	.bLength 		= sizeof(standard_vc_interface_descriptor),
	.bDescriptorType 	= 0x04,	//INTERFACE descriptor type,
	.bInterfaceNumber	= UVC_CTRL_INTERFACE_INDEX,
	.bAlternateSetting	= 0,
	.bNumEndpoints 		= 1,	
	.bInterfaceClass 	= 0x0E,	// CC_VIDEO,
	.bInterfaceSubClass	= 0x01,	// SC_VIDEOCONTROL,
	.bInterfaceProtocol	= 0x00,
	.iInterface 		= STN_PRODUCT,
};

static const struct uvc_vc_interface_descriptor class_specific_vc_interface_descriptor = {
	.bLength 		= sizeof(class_specific_vc_interface_descriptor), 
	.bDescriptorType 	= 0x24,			//CS_INTERFACE,
	.bDescriptorSubType	= VC_HEADER,
#ifdef ENABLE_UVC_1_1
	.bcdUVC			= 0x0110,
#else
	.bcdUVC			= 0x0100,
#endif
	.wTotalLength		= sizeof(struct uvc_vc_interface_descriptor)

#if HAS_CAMERA_INPUT == 1
							+ sizeof(struct uvc_input_terminal_camera_descriptor)
#endif
#if HAS_COMPOSITE_CONNECTOR_INPUT == 1
							+ sizeof(struct uvc_input_terminal_descriptor)
#endif
#if HAS_SVIDEO_CONNECTOR_INPUT == 1
							+ sizeof(struct uvc_input_terminal_descriptor)
#endif
#if HAS_COMPONENT_CONNECTOR_INPUT == 1
							+ sizeof(struct uvc_input_terminal_descriptor) 
#endif
#if HAS_HDMI_CONNECTOR_INPUT == 1
							+ sizeof(struct uvc_input_terminal_descriptor) 
#endif
							+ sizeof(struct uvc_output_terminal_descriptor) 
							+ sizeof(struct uvc_selector_unit_descriptor) 
#if HAS_VIDCAP_UNIT_PROCESSOR
							+ sizeof(struct uvc_processing_unit_descriptor) 
#endif
#if HAS_VIDCAP_UNIT_EXT == 1
							+ sizeof(struct uvc_vidcap_extension_descriptor) 
#endif
							,	/* Comma here */

	.dwClockFrequency	= 6000000,
	.bInCollection		= 0x01,			// number of streaming interfaces
	.baInterfaceNr[0]	= 0x01,
};

#if HAS_CAMERA_INPUT == 1
// camera IT
static const struct uvc_input_terminal_camera_descriptor intf_it_camera = {
	.bLength			= sizeof(intf_it_camera),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType = VC_INPUT_TERMINAL,
	.bTerminalID		= CAMERA_CONNECTOR_INPUT_ID, // ID of this terminal
	.wTerminalType		= UVC_ITT_CAMERA,
	.bAssocTerminal		= 0x00, // no association
	.iTerminal			= 0x00, // unused
	.wObjectiveFocalLengthMin = 0x0000,
	.wObjectiveFocalLengthMax = 0x0000,
	.wOcularFocalLength = 0x0000,
	.bControlSize       = 0x03,	// 4 bytes, this terminal does not implement any control
	.bmControls         = {CT_BM_CONTROLS_0,CT_BM_CONTROLS_1, CT_BM_CONTROLS_2}
};
#endif

#if HAS_COMPOSITE_CONNECTOR_INPUT == 1
// composit IT
static const struct uvc_input_terminal_descriptor intf_it_composite = {
	.bLength			= sizeof(intf_it_composite),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType = VC_INPUT_TERMINAL,
	.bTerminalID		= COMPOSITE_VID_CONNECTOR_INPUT_ID,	// ID of this terminal 
	.wTerminalType		= UVC_COMPOSITE_CONNECTOR,			// this terminal is the composite connector
	.bAssocTerminal		= 0x00,								// no association
	.iTerminal			= STN_INPUT_COMPOSITE,
};
#endif

#if HAS_SVIDEO_CONNECTOR_INPUT == 1
// composit IT
static const struct uvc_input_terminal_descriptor intf_it_svideo = {
	.bLength			= sizeof(intf_it_composite),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType = VC_INPUT_TERMINAL,
	.bTerminalID		= SVIDEO_VID_CONNECTOR_INPUT_ID,//0x02, // ID of this terminal 
	.wTerminalType		= UVC_SVIDEO_CONNECTOR, // this terminal is the composite connector
	.bAssocTerminal		= 0x00, // no association
	.iTerminal			= STN_INPUT_SVIDEO,
};
#endif
#if HAS_COMPONENT_CONNECTOR_INPUT == 1
// composit IT
static const struct uvc_input_terminal_descriptor intf_it_component = {
	.bLength			= sizeof(intf_it_component),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType = VC_INPUT_TERMINAL,
	.bTerminalID		= COMPONENT_VID_CONNECTOR_INPUT_ID,	// ID of this terminal 
	.wTerminalType		= UVC_COMPONENT_CONNECTOR,			// this terminal is the composite connector
	.bAssocTerminal		= 0x00,								// no association
	.iTerminal			= STN_INPUT_COMPONENT,
};
#endif

#if HAS_HDMI_CONNECTOR_INPUT == 1
// composit IT
static const struct uvc_input_terminal_descriptor intf_it_hdmi = {
	.bLength			= sizeof(intf_it_hdmi),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType = VC_INPUT_TERMINAL,
	.bTerminalID		= HDMI_VID_CONNECTOR_INPUT_ID,		// ID of this terminal 
	.wTerminalType		= UVC_EXTERNAL_VENDOR_SPECIFIC,		// this terminal is the composite connector
	.bAssocTerminal		= 0x00,								// no association
	.iTerminal			= STN_INPUT_COMPONENT,
};
#endif

// OT descriptor (to the host)
static const struct uvc_output_terminal_descriptor intf_ot = {
	.bLength			= sizeof(intf_ot),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType = VC_OUTPUT_TERMINAL,
	.bTerminalID		= VIDCAP_OUT_TERMINAL_ID,	// ID of this terminal 
	.wTerminalType		= UVC_TT_STREAMING,			
	.bAssocTerminal		= 0x00,						// no association
	.bSourceID			= VIDCAP_UNIT_ID_LAST - 1,
	.iTerminal			= 0x00,
};

struct uvc_selector_unit_descriptor selector_unit_descriptor = {
	.bLength		= sizeof(selector_unit_descriptor),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType	= VC_SELECTOR_UNIT,
	.bUnitID			= VIDCAP_UNIT_SELECTOR_ID,
	.bNrInPins			= VID_CONNECTOR_INPUT_ID_LAST - 1,
	.baSourceID = {
#if HAS_CAMERA_INPUT	== 1
	CAMERA_CONNECTOR_INPUT_ID,
#endif
#if HAS_COMPOSITE_CONNECTOR_INPUT == 1
	COMPOSITE_VID_CONNECTOR_INPUT_ID,
#endif
#if HAS_SVIDEO_CONNECTOR_INPUT	== 1
	SVIDEO_VID_CONNECTOR_INPUT_ID,
#endif
#if HAS_COMPONENT_CONNECTOR_INPUT == 1
	COMPONENT_VID_CONNECTOR_INPUT_ID,
#endif
#if HAS_HDMI_CONNECTOR_INPUT == 1
	HDMI_VID_CONNECTOR_INPUT_ID,
#endif
	},
	.iSelector			= 0x00	// Not used
};

struct uvc_processing_unit_descriptor processing_unit_descriptor = {
	.bLength		= sizeof(processing_unit_descriptor),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType	= VC_PROCESSING_UNIT,
	.bUnitID		= VIDCAP_UNIT_PROCESSOR_ID,
	.bSourceID		= VIDCAP_UNIT_SELECTOR_ID,
	.wMaxMultiplier	= 0x0000,
#ifdef ENABLE_UVC_1_1
	.bControlSize	= 0x03,
	.bmControls		= {PU_BM_CONTROLS_1,PU_BM_CONTROLS_2,0x00},
#else
	.bControlSize	= 0x02,
	.bmControls		= {PU_BM_CONTROLS_1,PU_BM_CONTROLS_2},//{0xFF,0xFF},
#endif
	.iProcessing	= 0x00
};

#if HAS_VIDCAP_UNIT_EXT == 1
struct uvc_vidcap_extension_descriptor vidcap_extension = 
{
	.bLength			= sizeof(struct uvc_vidcap_extension_descriptor),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubtype	= VC_EXTENSION_UNIT,
	.bUnitID			= VIDCAP_UNIT_EXT_ID,
	.guidExtensionCode	= GUID_VIDCAP_EXT,
	.bNumControls		= UVC_EXT_PARAM_ID_LAST - 1,
	.bNrInPins			= 0x01,
	.baSourceID			= {VIDCAP_UNIT_PROCESSOR_ID},
	.bControlSize		= 4,
	.bmControls			= UVC_EXT_CTRL_COUNT_MASK,
	.iExtension			= 0x00,
};
#endif

#if HAS_INTERRUPT == 1
struct uvc_class_spec_interrupt_endpoint_descriptor_t uvc_class_spec_interrupt_endpoint_descriptor = {
        .bLength = sizeof(uvc_class_spec_interrupt_endpoint_descriptor),
        .bDescriptorType = 0x25,
        .bDescriptorSubType = 0x03,
        .wMaxTransferSize = 0x0010
};
#endif

/**
 * This structure is made common for both ISOCH and BULK
 */
static const struct usb_interface_descriptor standard_vs_interface_descriptor_alt0 = {
	.bLength 			= sizeof(struct usb_interface_descriptor),
	.bDescriptorType 	= USB_DT_INTERFACE,
	.bInterfaceNumber	= UVC_CAP_STRM_IN_INDEX,
	.bAlternateSetting	= 0,
#if HAS_VIDCAP_ISOCH == 1
	.bNumEndpoints 		= 0,						// isoch end point
#else
	.bNumEndpoints 		= 1,						// bulk end point
#endif 
	.bInterfaceClass 	= 0x0E, //CC_VIDEO
	.bInterfaceSubClass	= 0x02,	// SC_VIDEOSTREAMING
	.bInterfaceProtocol = 0x00,
	.iInterface 		= 0x00					// Unused
};


static const struct usb_interface_descriptor standard_vs_interface_descriptor_alt1 = {
	.bLength 		= sizeof(standard_vs_interface_descriptor_alt1),
	.bDescriptorType 	= USB_DT_INTERFACE,
	.bInterfaceNumber	= UVC_CAP_STRM_IN_INDEX,
	.bAlternateSetting	= 1,
	.bNumEndpoints 		= 1,						// # of EP's excluding EP0
	.bInterfaceClass 	= 0x0E, //CC_VIDEO
	.bInterfaceSubClass	= 0x02,	// SC_VIDEOSTREAMING
	.bInterfaceProtocol = 0x00,
	.iInterface 		= 0x00,
};


static const struct usb_interface_descriptor standard_vs_interface_descriptor_alt2 = {
	.bLength 		= sizeof(standard_vs_interface_descriptor_alt1),
	.bDescriptorType 	= USB_DT_INTERFACE,
	.bInterfaceNumber	= UVC_CAP_STRM_IN_INDEX,
	.bAlternateSetting	= 2,
	.bNumEndpoints 		= 1,						// # of EP's excluding EP0
	.bInterfaceClass 	= 0x0E, //CC_VIDEO
	.bInterfaceSubClass	= 0x02,	// SC_VIDEOSTREAMING
	.bInterfaceProtocol = 0x00,
	.iInterface 		= 0x00,
};

static const struct usb_interface_descriptor standard_vs_interface_descriptor_alt3 = {
	.bLength 		= sizeof(standard_vs_interface_descriptor_alt1),
	.bDescriptorType 	= USB_DT_INTERFACE,
	.bInterfaceNumber	= UVC_CAP_STRM_IN_INDEX,
	.bAlternateSetting	= 3,
	.bNumEndpoints 		= 1,						// # of EP's excluding EP0
	.bInterfaceClass 	= 0x0E, //CC_VIDEO
	.bInterfaceSubClass	= 0x02,	// SC_VIDEOSTREAMING
	.bInterfaceProtocol = 0x00,
	.iInterface 		= 0x00,
};
static const struct usb_interface_descriptor standard_vs_interface_descriptor_alt4 = {
	.bLength 		= sizeof(standard_vs_interface_descriptor_alt1),
	.bDescriptorType 	= USB_DT_INTERFACE,
	.bInterfaceNumber	= UVC_CAP_STRM_IN_INDEX,
	.bAlternateSetting	= 4,
	.bNumEndpoints 		= 1,						// # of EP's excluding EP0
	.bInterfaceClass 	= 0x0E, //CC_VIDEO
	.bInterfaceSubClass	= 0x02,	// SC_VIDEOSTREAMING
	.bInterfaceProtocol = 0x00,
	.iInterface 		= 0x00,
};
static const struct usb_interface_descriptor standard_vs_interface_descriptor_alt5 = {
	.bLength 		= sizeof(standard_vs_interface_descriptor_alt1),
	.bDescriptorType 	= USB_DT_INTERFACE,
	.bInterfaceNumber	= UVC_CAP_STRM_IN_INDEX,
	.bAlternateSetting	= 5,
	.bNumEndpoints 		= 1,						// # of EP's excluding EP0
	.bInterfaceClass 	= 0x0E, //CC_VIDEO
	.bInterfaceSubClass	= 0x02,	// SC_VIDEOSTREAMING
	.bInterfaceProtocol = 0x00,
	.iInterface 		= 0x00,
};

static const struct usb_interface_descriptor standard_vs_interface_descriptor_alt6 = {
	.bLength 		= sizeof(standard_vs_interface_descriptor_alt1),
	.bDescriptorType 	= USB_DT_INTERFACE,
	.bInterfaceNumber	= UVC_CAP_STRM_IN_INDEX,
	.bAlternateSetting	= 6,
	.bNumEndpoints 		= 1,						// # of EP's excluding EP0
	.bInterfaceClass 	= 0x0E, //CC_VIDEO
	.bInterfaceSubClass	= 0x02,	// SC_VIDEOSTREAMING
	.bInterfaceProtocol = 0x00,
	.iInterface 		= 0x00,
};
static const struct usb_interface_descriptor standard_vs_interface_descriptor_alt7 = {
	.bLength 		= sizeof(standard_vs_interface_descriptor_alt1),
	.bDescriptorType 	= USB_DT_INTERFACE,
	.bInterfaceNumber	= UVC_CAP_STRM_IN_INDEX,
	.bAlternateSetting	= 7,
	.bNumEndpoints 		= 1,						// # of EP's excluding EP0
	.bInterfaceClass 	= 0x0E, //CC_VIDEO
	.bInterfaceSubClass	= 0x02,	// SC_VIDEOSTREAMING
	.bInterfaceProtocol = 0x00,
	.iInterface 		= 0x00,
};

struct uvc_vs_header_descriptor_cap_t vs_header_descriptor_cap =  {
	.bLength 			= sizeof( vs_header_descriptor_cap),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_INPUT_HEADER,
	.bNumFormats			= ENCODE_FORMAT_INDEX_LAST - 1,
	.wTotalLength			= sizeof(struct uvc_vs_header_descriptor_cap_t) 

#if HAS_MJPEG_ENCODE == 1
					+ sizeof(struct uvc_vs_format_descriptor)	/*MJPG*/ 
					+ sizeof(struct uvc_vs_frame_descriptor_mjpg) * ( MJPEG_FRAME_INDEX_LAST - 1)
#endif
#if HAS_H264_ENCODE == 1
					+ sizeof(struct uvc_vs_format_descriptor_mp2ts_t)/*MP2TS-AVC1*/
#endif
#if HAS_H264_ENCODE_VEN == 1
					+ sizeof(struct uvc_vs_format_descriptor_mp2ts_t)/*MP2TS-AVC1*/
#endif
					,	/* Comma here */
	.bEndpointAddress 	= USB_DIR_IN |  VID_CAP_EP_ADDR,
	.bmInfo					= 0x01, // Indicates the capabilities of this VideoStreaming interface:
									// D0: Dynamic Format Change supported
									// D7..1: Reserved, set to zero.
	.bTerminalLink			= VIDCAP_OUT_TERMINAL_ID,
	.bStillCaptureMethod	= 0x00,	// Not supported
	.bTriggerSupport		= 0x00,	// Hardware trigger
	.bTriggerUsage			= 0x00,
	.bControlSize			= 0x01,	// SIze of BMA Control filed
	.bmaControls		= {
#if HAS_YUV420_ENCODE
					BMA_SUPPORTED_YUV420,
#endif
#if HAS_MJPEG_ENCODE == 1
					BMA_SUPPORTED_MJPEG,	// TODO : Modify the flags
#endif
#if HAS_H264_ENCODE	== 1
					BMHINT_SUPPORTED_H264_MP2TS,
#endif
#if HAS_H264_ENCODE_VEN	== 1
					BMHINT_SUPPORTED_H264,
#endif

				}	
};

#if HAS_MJPEG_ENCODE ==  1
struct uvc_vs_format_descriptor vs_format_descriptor_mjpg =  {
	.bLength 			= sizeof(vs_format_descriptor_mjpg),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FORMAT_MJPEG,
	.bFormatIndex			= MJPEG_FORMAT_INDEX,
	.bNumFrameDescriptors	= (MJPEG_FRAME_INDEX_LAST - 1),
	.bmFlags				= 0x00,
	.bDefaultFrameIndex		= 0x01,
	.bAspectRatioX			= 0x00,
	.bAspectRatioY			= 0x00,
	.bmInterlaceFlags		= 0x00,
	.bCopyProtect			= 0x00
};
#endif

#if HAS_H264_ENCODE == 1
struct uvc_vs_format_descriptor_mp2ts_t vs_format_descriptor_h264_mpeg2ts =  {
	.bLength 			= sizeof(vs_format_descriptor_h264_mpeg2ts),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FORMAT_MPEG2TS,
	.bFormatIndex			= H264_FORMAT_INDEX,
	.bDataOffset			= 0,
 	.bPacketLength			= 188,
 	.bStrideLength			= 188
};
#endif

#if HAS_H264_ENCODE_VEN == 1
struct uvc_vs_format_descriptor_mp2ts_t vs_format_descriptor_h264_ven_mpeg2ts =  {
	.bLength 			= sizeof(vs_format_descriptor_h264_ven_mpeg2ts),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FORMAT_STREAM_BASED,
	.bFormatIndex			= H264_FORMAT_VEN_INDEX,
	.bDataOffset			= 0,
 	.bPacketLength			= 188,
 	.bStrideLength			= 188
};
#endif

#endif

/******************************************************************************
 * Full & high speed endpoints: 
 *
 * usb 2.0 devices need to expose both high speed and full speed
 * descriptors, unless they only run at full speed.
 *
 * that means alternate endpoint descriptors (bigger packets)
 * and a "device qualifier" ... plus more construction options
 * for the config descriptor.
 ******************************************************************************/



/******************************************************************************
 * UVC Interface descriptor
 ******************************************************************************/
const struct usb_descriptor_header *uvc_interface_descriptors[] = {
	/* Video Capture interface */
#if HAS_VID_CAP == 1
	(struct usb_descriptor_header *) &iad_desc,
	(struct usb_descriptor_header *) &standard_vc_interface_descriptor,
	(struct usb_descriptor_header *) &class_specific_vc_interface_descriptor,
#if HAS_CAMERA_INPUT == 1
	(struct usb_descriptor_header *) &intf_it_camera,
#endif
#if HAS_COMPOSITE_CONNECTOR_INPUT == 1
	(struct usb_descriptor_header *) &intf_it_composite,
#endif
#if HAS_SVIDEO_CONNECTOR_INPUT == 1
	(struct usb_descriptor_header *) &intf_it_svideo,
#endif
#if HAS_COMPONENT_CONNECTOR_INPUT == 1
	(struct usb_descriptor_header *) &intf_it_component,
#endif
#if HAS_HDMI_CONNECTOR_INPUT == 1
	(struct usb_descriptor_header *) &intf_it_hdmi,
#endif

	(struct usb_descriptor_header *) &intf_ot,
	(struct usb_descriptor_header *) &selector_unit_descriptor,

#if HAS_VIDCAP_UNIT_PROCESSOR
	(struct usb_descriptor_header *) &processing_unit_descriptor,
#endif

#if HAS_VIDCAP_UNIT_EXT == 1
	(struct usb_descriptor_header *) &vidcap_extension,
#endif

#if HAS_INTERRUPT == 1
	(struct usb_descriptor_header *) &ep_vidcap0_desc_int,
	(struct usb_descriptor_header *) &uvc_class_spec_interrupt_endpoint_descriptor,
#endif
	(struct usb_descriptor_header *) &standard_vs_interface_descriptor_alt0,
	(struct usb_descriptor_header *) &vs_header_descriptor_cap,
#if HAS_MJPEG_ENCODE == 1
	(struct usb_descriptor_header *) &vs_format_descriptor_mjpg,
	DEFINE_MJPG_FRAME_DESCRIPT
#endif // MJPEG FORMAT
#if HAS_H264_ENCODE == 1
	(struct usb_descriptor_header *) &vs_format_descriptor_h264_mpeg2ts,
#endif
#if HAS_H264_ENCODE_VEN == 1
	(struct usb_descriptor_header *) &vs_format_descriptor_h264_ven_mpeg2ts,
#endif

#if HAS_VIDCAP_ISOCH == 1
	(struct usb_descriptor_header *) &standard_vs_interface_descriptor_alt1,
	(struct usb_descriptor_header *) &ep_vidcap0_desc_isoc_1,
	(struct usb_descriptor_header *) &standard_vs_interface_descriptor_alt2,
	(struct usb_descriptor_header *) &ep_vidcap0_desc_isoc_2,
	(struct usb_descriptor_header *) &standard_vs_interface_descriptor_alt3,
	(struct usb_descriptor_header *) &ep_vidcap0_desc_isoc_3,
	(struct usb_descriptor_header *) &standard_vs_interface_descriptor_alt4,
	(struct usb_descriptor_header *) &ep_vidcap0_desc_isoc_4,
	(struct usb_descriptor_header *) &standard_vs_interface_descriptor_alt5,
	(struct usb_descriptor_header *) &ep_vidcap0_desc_isoc_5,
	(struct usb_descriptor_header *) &standard_vs_interface_descriptor_alt6,
	(struct usb_descriptor_header *) &ep_vidcap0_desc_isoc_6,
	(struct usb_descriptor_header *) &standard_vs_interface_descriptor_alt7,
	(struct usb_descriptor_header *) &ep_vidcap0_desc_isoc_7,
#else
	(struct usb_descriptor_header *) &ep_vidcap0_desc_bulk,
#endif

#endif
	//(struct usb_descriptor_header *) &otg_descriptor,
	NULL,
};

#if HAS_VIDCAP_ISOCH == 1
// Repetion form main descriptor table
const struct usb_descriptor_header *endpoint_descriptors_vidcap0[] = 
{
	(struct usb_descriptor_header *) &ep_vidcap0_desc_isoc_1,
	(struct usb_descriptor_header *) &ep_vidcap0_desc_isoc_2,
	(struct usb_descriptor_header *) &ep_vidcap0_desc_isoc_3,
	(struct usb_descriptor_header *) &ep_vidcap0_desc_isoc_4,
	(struct usb_descriptor_header *) &ep_vidcap0_desc_isoc_5,
	(struct usb_descriptor_header *) &ep_vidcap0_desc_isoc_6,
	(struct usb_descriptor_header *) &ep_vidcap0_desc_isoc_7,
};
#endif

struct uvc_vs_frame_descriptor_mjpg *get_frame_descriptor(int index)
{
	return (struct uvc_vs_frame_descriptor_mjpg *)mjpeg_frame_descriptors[index];
}

struct usb_endpoint_descriptor *get_endpoint_descriptor(int intf, int alt_setting)
{
#if HAS_VID_CAP == 1
#if HAS_VIDCAP_ISOCH == 1
	if(intf == UVC_CAP_STRM_IN_INDEX && alt_setting >= 1 && alt_setting <= 7) { // TODO define constants{
			UAV_DBG_MSG(":%d alt setting =%d\n", __LINE__,alt_setting);
		return (struct usb_endpoint_descriptor *)endpoint_descriptors_vidcap0[alt_setting - 1];
	}
	return NULL;
#else
	return &ep_vidcap0_desc_bulk;
#endif

#else
	UAV_DBG_MSG(":%d alt setting =%d\n", __LINE__,alt_setting);
	return 0;
#endif
}

struct usb_endpoint_descriptor *uvc_cap_get_int_decsc(void)
{
#if HAS_INTERRUPT == 1
	return &ep_vidcap0_desc_int;
#else
	return 0;
#endif
}
