/*
 * USB Video Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 * The file defines functions for video streaming interface 
 *
 */

#include <linux/types.h>
#include "uvcdescript.h"

struct stream_format_if_t {

	int (*GetUvcStreamingControl)(
		struct stream_format_if_t *pObj,
		struct uvc_streaming_control_request *pCtrl, 
		__u8  bIsProbe, 
		__u8  bFormatIndex, 
		__u8  bFrameIndex, 
		__u8  bProbeIndex);

	int (*SetUvcStreamingControl)(
		struct stream_format_if_t *pObj,
		struct uvc_streaming_control_request *pCtrl, 
		__u8  bIsProbe, 
		__u8  bFormatIndex, 
		__u8  bFrameIndex);

	int (*VerifyUvcStreamingControl)(
		struct stream_format_if_t *pObj,
		__u8  bFormatIndex, 
		__u8  bFrameIndex);

	int (*GetFrameParams)(
		struct stream_format_if_t *pObj,
		struct uvc_streaming_control_request *pCtrl, 
		__u8 bCrntFormatIndex, 
		__u8 bCrntFrameIndex, 
		long *pFormat, 
		long *plWidth, 
		long *plHeight,
		long *plMinBitrate,
		long *plMaxBitrate);

	int (*IsAltSettingVaiable)(
		struct stream_format_if_t *pObj);

	void *pStreamFormatCtx;
};
